#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef PDCDEBUG
char *rcsid__cattr = "$Header: c:/curses/private/RCS/_cattr.c%v 2.0 1992/11/15 03:24:41 MH Rel $";
#endif




/*man-start*********************************************************************

  PDC_chg_attr_pair()	- Writes character and attribute to physical screen

  PDCurses Description:
 	This is a private PDCurses function.

 	Writes a single character 'chr' with attribute 'attr' to the
 	current cursor location.

 	NOTE:	Though passed as 16 bit quantities, only the lower 8 bits
 		will be used to create a character/attribute pair.

  PDCurses Return Value:
 	This function returns OK on success and ERR on error.

  PDCurses Errors:
 	No errors are defined for this function under DOS.

 	An ERR may be returned under FLEXOS if s_copy() fails.  See the
 	Flexos Programmer's Reference Manual for details on the error.

  Portability:
 	PDCurses	int PDC_chg_attr_pair( chtype chr, chtype attr );

**man-end**********************************************************************/

int	PDC_chg_attr_pair(chtype chr, chtype attr)
{
	extern unsigned	char atrtab[MAX_ATRTAB];
	chtype	phys_attr=chtype_attr(attr);

#ifdef	OS2
	USHORT curCol, curRow, cell;
#endif

#ifdef	FLEXOS
	UBYTE	c = (UBYTE) chr;
	UBYTE	a = (UBYTE) phys_attr;
#endif

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_chg_attr_pair() - called\n");
#endif

#ifdef	FLEXOS
	drect.r_row = PDC_get_cur_row();
	drect.r_col = PDC_get_cur_col();
	drect.r_nrow = 1;
	drect.r_ncol = 1;

	sframe.fr_pl[0] = (UBYTE *) & c;
	sframe.fr_pl[1] = (UBYTE *) & a;
	sframe.fr_pl[2] = (UBYTE *) " ";
	sframe.fr_nrow = 1;
	sframe.fr_ncol = 1;
	sframe.fr_use = 0x00;

	srect.r_col = 0;
	srect.r_row = 0;
	srect.r_nrow = 1;
	srect.r_ncol = 1;

	retcode = s_copy(0x03, 0x01L, 0L, (far unsigned short *) &drect, (far unsigned short *) &sframe, (far unsigned short *) &srect);
	return( (retcode < 0L) ? ERR : OK );
#endif

#ifdef	DOS
	regs.h.ah = 0x09;
	regs.h.al = chr & A_CHARTEXT;
	regs.h.bh = _cursvar.video_page;
	regs.h.bl = (phys_attr & A_ATTRIBUTES) >> 8;
	regs.x.cx = 0x01;
	int86(0x10, &regs, &regs);
	return( OK );
#endif

#ifdef	OS2
	/* find the current cursor position */
	VioGetCurPos((PUSHORT) &curRow, (PUSHORT) &curCol, 0);
	cell = (chr & A_CHARTEXT) | (phys_attr & A_ATTRIBUTES);
	VioWrtNCell((PBYTE)&cell,1,curRow,curCol,0);
	return( OK );
#endif

#ifdef UNIX
/* INCOMPLETE - check attribute and output attr and/or color */
	putchar(chr & A_CHARTEXT);
	return(OK);
#endif
}
