#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef PDCDEBUG
char *rcsid__fixcurs = "$Header: c:/curses/private/RCS/_fixcurs.c%v 2.0 1992/11/15 03:24:21 MH Rel $";
#endif




/*man-start*********************************************************************

  PDC_fix_cursor()	- Fix the cursor start and stop scan lines (if necessary)

  PDCurses Description:
 	This is a private PDCurses routine.

 	This routine will fix the cursor shape for certain video adapters.
 	Normally, the values used are correct, but some adapters choke.
 	The most noticable choke is on a monochrome adapter.  The "correct"
 	scan lines will result in the cursor being set in the middle of the
 	character cell, rather than at the bottom.

 	The passed flag indicates whether the cursor is visible or not.

 	This only applies to the DOS platform.

  PDCurses Return Value:
 	This function returns OK on success and ERR on error.

  PDCurses Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int PDC_fix_cursor( int flag );

**man-end**********************************************************************/

int	PDC_fix_cursor(int flag)
{
#ifdef	DOS
#  if	SMALL || MEDIUM || MSC
	char far*	INFO = (char far *)_FAR_POINTER(0,0x0487);
#  else
	char *		INFO = (char *)_FAR_POINTER(0,0x0487);
#  endif

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_fix_cursor() - called\n");
#endif

#ifdef	FLEXOS
	return( OK );
#endif

	if (_cursvar.bogus_adapter)
		return( OK );

	switch (_cursvar.adapter)
	{
	case _EGACOLOR:
	case _EGAMONO:
	case _MDS_GENIUS:		/* Some clones look like a Genius;-)  */
		if (flag & 0x01)
			*INFO |= 0x01;			/* Enable  emnulation */
		else
			*INFO &= (*INFO & ~0x01);	/* Disable emnulation */
		break;

	case _VGACOLOR:
	case _VGAMONO:
		if (flag & 0x01)
			regs.x.ax = 0x1200;		/* Enable  emulation */
		else
			regs.x.ax = 0x1201;		/* Disable emulation */
		regs.h.bl = 0x34;
		int86(0x10, &regs, &regs);

		break;

	case _MCGACOLOR:
	case _MCGAMONO:
	case _MDA:
	case _CGA:
	case _NONE:
	default:
		break;
	}
	return( OK );
#endif

#ifdef     OS2
        return( OK );
#endif

#ifdef     UNIX
        return( OK );
#endif
}
