#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef PDCDEBUG
char *rcsid__gcrspos = "$Header: c:/curses/private/RCS/_gcrspos.c%v 2.0 1992/11/15 03:24:22 MH Rel $";
#endif




/*man-start*********************************************************************

  PDC_get_cursor_pos()	- return current cursor position

  PDCurses Description:
 	This is a private PDCurses function

 	Gets the cursor position in video page 0.  'row' and 'column'
 	are the cursor address.  At this time, there is no support for
 	use of multiple screen pages.

  PDCurses Return Value:
 	This routine will return OK upon success and otherwise ERR will be
 	returned.

  PDCurses Errors:
 	There are no defined errors for this routine.

  Portability:
 	PDCurses	int	PDC_get_cursor_pos( int* row, int* col );

**man-end**********************************************************************/

int	PDC_get_cursor_pos(int *row, int *col)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_get_cursor_pos() - called\n");
#endif

#ifdef	FLEXOS
	retcode = s_get(T_VIRCON, 0L, (char *) &vir, (long) sizeof(vir));
	if (retcode < 0L)
		return( ERR );
	*row = vir.vc_cursor.pos_row;
	*col = vir.vc_cursor.pos_col;
	return( OK );
#endif
#ifdef	DOS
	regs.h.ah = 0x03;
	regs.h.bh = _cursvar.video_page;
	int86(0x10, &regs, &regs);
	*row = regs.h.dh;
	*col = regs.h.dl;
	return( OK );
#endif
#ifdef	OS2
	VioGetCurPos((PUSHORT)row,(PUSHORT)col,0);
	return( OK );
#endif
#ifdef UNIX
/* INCOMPLETE */
#endif
}
