#ifndef NO_MEMORY_H
#include <memory.h>
#endif
#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef	REGISTERWINDOWS
#ifdef PDCDEBUG
char *rcsid__inswin = "$Header: c:/curses/private/RCS/_inswin.c%v 2.0 1992/11/15 03:24:27 MH Rel $";
#endif




/*man-start*********************************************************************

  _inswin()	- Register Window with PDCurses for auto refresh

  PDCurses Description:
 	This is a private PDCurses routine.

 	This routine inserts the passed window pointer after the specified
 	window.	 If the specified window is a (void*)0, then the passed
 	window pointer is inserted first in the list.

 	If the 'before' window is not on the visible list, then 'win'
 	will be insed to the end of the list.

 	This is the beginnings of full-tiled window support.  It is _very_
 	raw at this point.

  PDCurses Return Value:
 	This function returns OK on success and ERR on error.

  PDCurses Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	bool	_inswin( WINDOW* win, WINDOW* before );

**man-end**********************************************************************/

bool	_inswin(WINDOW *win, WINDOW *before)
{
extern	void*	(*mallc)( size_t );
extern	void*	(*callc)( size_t, size_t );
extern	void	(*fre)( void* );

	WINDS  *root = _cursvar.visible;
	WINDS  *wlst = _findwin(before);
	WINDS  *new  = (*mallc)(sizeof(WINDS));

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_inswin() - called\n");
#endif

	if (new == (WINDS *)NULL)
		return( FALSE );

	_rmwin(win);
	memset(new, 0, sizeof(WINDS));
	new->w = win;
	if (wlst == (WINDS *)NULL)
	{
		if (root == (WINDS *)NULL)
		{
			_cursvar.visible = new;
		}
		else
		{
			new->next = root;
			root->prev = new;
			_cursvar.visible = new;
		}
	}
	else
	{
		if (wlst == root)
		{
			new->next = root;
			root->prev = new;
			_cursvar.visible = new;
		}
		else
		{
			new->next = wlst;
			new->prev = wlst->prev;
			wlst->prev->next = new;
			wlst->prev = new;
		}
	}
	return( TRUE );
}
#endif
