#define	CURSES_LIBRARY	1
#include <curses.h>

#if	BUG68K
#ifdef PDCDEBUG
char *rcsid__sgetnl = "$Header: c:/curses/private/RCS/_sgetnl.c%v 2.0 1992/11/15 03:24:38 MH Rel $";
#endif

void c_setnl( char* );		/* conv nl -> CTRL-\ */
void c_getnl( char* );		/* conv CTRL-\ -> nl */
/*man-start*********************************************************************

  PDC_setnl()	- BUG68K: set newline for 68000 C compiler

  PDCurses Description:
 	This is a private PDCurses function.

 	This function circumvents a problem in the 68000 C library: If
 	the standard sprintf is used, it will ignore any newlines in
 	the format string. Therefore this routine changes the newlines
 	to CTRL-\ characters, to be restored later by the getnl()
 	function.

  PDCurses Return Value:
 	This function does not return a value.

  PDCurses Errors:
 	There are no defined errors for this routine.

  Portability:
 	PDCurses	void	PDC_setnl( char* fmt );  /* BUG68K only */

**man-end**********************************************************************/

void	PDC_setnl(char *fmt)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_setnl() - called\n");
#endif

	while (*fmt)
	{
		if (*fmt == '\n')
			*fmt = 0x1c;
		fmt++;
	}
}



/*----------------------------------------------------------------------
$ PDC_getnl()	- BUG68K: get newline for 68000 C compiler
$
$ PDCurses Description:
$	This is a private PDCurses function.
$
$	This function circumvents a problem in the 68000 C library: If
$	the standard sprintf is used, it will ignore any newlines in
$	the format string. Therefore this routine changes CTRL-\
$	characters (already set by setnl()) back to newlines.
$
$ PDCurses Return Value:
$	This function does not return a value.
$
$ PDCurses Errors:
$	There are no defined errors for this routine.
$
$ Portability:
$	PDCurses	void	PDC_getnl( char* fmt );  /* BUG68K only */
$
$----------------------------------------------------------------------
*/
void	PDC_getnl(cahr *fmt)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_getnl() - called\n");
#endif

	while (*fmt)
	{
		if (*fmt == 0x1c)
			*fmt = '\n';
	}
}
#endif
