#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef PDCDEBUG
char *rcsid__splitpl = "$Header: c:/curses/private/RCS/_splitpl.c%v 2.0 1992/11/15 03:24:41 MH Rel $";
#endif



#ifdef	FLEXOS
/*man-start*********************************************************************

  PDC_flexos_split_plane()	- splits a char/attr plane into separate planes

  PDCurses Description:
 	This is a private PDCurses function.

 	This routine is used only be the Flexos platform.

 	This routine will separate the character/attributes plane into
 	a separate character and attribute plane.

  PDCurses Return Value:
 	This function returns OK upon success otherwise ERR is returned.

  PDCurses Errors:
 	It is an error to pass a NULL WINDOW pointer.
 	It is also an error if the starting x or y coordinate exceeds the
 	passed window boundaries.

  Portability:
 	PDCurses	int	PDC_flexos_split_plane( WINDOW* w,
 					char* chr, char* attr,
 					int sy, int sx,
 					int ey, int ex );

**man-end**********************************************************************/

int	PDC_flexos_split_plane(WINDOW* w,char* chr,char* attr,int sy,int sx,int ey,int ex)
{
	int	l;
	int	c;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_flexos_split_plane() - called\n");
#endif

	if (w == (WINDOW *)NULL)		return( ERR );
	if (sy > w->_maxy)	return( ERR );
	if (sx > w->_maxx)	return( ERR );
	if (ey > w->_maxy)	ey = w->_maxy - 1;
	if (ex > w->_maxx)	ex = w->_maxx - 1;

	for (l = sy; l <= ey; l++)
	{
		for (c = sx; c <= ex; c++)
		{
			*chr  = (char)(w->_y[l][c] & CHR_MSK);
			*attr = (char)(w->_y[l][c] & ATR_MSK) >> 8;
			chr++;
			attr++;
		}
	}
	return( OK );
}
#endif
