/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1993 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 5314
 * QLD 4121
 * Australia
 */

/*
$Header: C:\THE\RCS\command.h 1.4 1993/09/01 16:25:48 MH Interim MH $
*/

struct commands
{
 char *text;
 unsigned short min_len;
 unsigned int funkey;
#ifdef PROTO
 int (*function)(char *);
#else
 int (*function)();
#endif
 bool valid_profile_command;
 bool set_command;
 bool sos_command;
 bool strip_param;
 char *params;
};
typedef struct commands COMMAND;

#include "proto.h"

/*---------------------- *** IMPORTANT *** ----------------------------*/
/* Make sure that there is no chance two or more commands can be       */
/* matched based on number of significant charcters.                   */
/*---------------------- *** IMPORTANT *** ----------------------------*/
/*                                                                  Prof / Set / SOS /strip */
COMMAND command[] =
{
 {(char *)"add",         3,  (-1),            Add,         TRUE, FALSE,FALSE,TRUE, (char *)"1"}, /* comm1.c */
 {(char *)"all",         3,  (-1),            All,         TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm1.c */
 {(char *)"arbchar",     3,  (-1),            Arbchar,     TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
 {(char *)"autosave",    2,  (-1),            Autosave,    TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
 {(char *)"backup",      4,  (-1),            Backup,      TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
 {(char *)"beep",        4,  (-1),            BeepSound,   TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
#if defined(DOS) || defined(OS2)
 {(char *)"backward",    2,  KEY_PGUP,        Backward,    FALSE,FALSE,FALSE,TRUE, (char *)"1"}, /* comm1.c */
#else
 {(char *)"backward",    2,  KEY_PPAGE,       Backward,    FALSE,FALSE,FALSE,TRUE, (char *)"1"}, /* comm1.c */
 {(char *)"backward",    2,  KEY_PrevScrn,    Backward,    FALSE,FALSE,FALSE,TRUE, (char *)"1"}, /* comm1.c */
#endif
 {(char *)"bottom",      3,  (-1),            Bottom,      TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm1.c */
 {(char *)"cancel",      3,  (-1),            Cancel,      TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm1.c */
 {(char *)"case",        4,  (-1),            Case,        TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
 {(char *)"ccancel",     2,  (-1),            Ccancel,     TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm1.c */
 {(char *)"change",      1,  (-1),            Change,      TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm1.c */
 {(char *)"clearscreen", 6,  (-1),            Clearscreen, TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
 {(char *)"clock",       5,  (-1),            Clock,       TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
#if defined(DOS) || defined(OS2)
 {(char *)"cmatch",      0,  KEY_F7,          Cmatch,      FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm1.c */
#else
 {(char *)"cmatch",      0,  KEY_F(7),        Cmatch,      FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm1.c */
#endif
 {(char *)"cmdarrows",   4,  (-1),            Cmdarrows,   TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
 {(char *)"cmdline",     3,  (-1),            Cmdline,     TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
 {(char *)"cmsg",        4,  (-1),            Cmsg,        FALSE,FALSE,FALSE,FALSE,(char *)""},  /* comm1.c */
 {(char *)"command",     7,  (-1),            Command,     TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm1.c */
 {(char *)"colour",      6,  (-1),            Colour,      TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
 {(char *)"color",       5,  (-1),            Colour,      TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
 {(char *)"copy",        4,  (-1),            Copy,        FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm1.c */
#if defined(DOS) || defined(OS2)
 {(char *)"control_char",0,  KEY_F12,         Control_char,FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm1.c */
 {(char *)"copy",        0,  KEY_A_c,         Copy,        FALSE,FALSE,FALSE,TRUE, (char *)"block reset"},  /* comm1.c */
 {(char *)"copy",        0,  KEY_A_k,         Copy,        FALSE,FALSE,FALSE,TRUE, (char *)"block"},  /* comm1.c */
#else
 {(char *)"control_char",0,  KEY_F(6),        Control_char,FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm1.c */
 {(char *)"copy",        0,  ControlC,        Copy,        FALSE,FALSE,FALSE,TRUE, (char *)"block reset"},  /* comm1.c */
 {(char *)"copy",        0,  ControlK,        Copy,        FALSE,FALSE,FALSE,TRUE, (char *)"block"},  /* comm1.c */
#endif
 {(char *)"curline",     4,  (-1),            Curline,     TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
 {(char *)"define",      3,  (-1),            Define,      TRUE, FALSE,FALSE,TRUE, (char *)"1"}, /* comm1.c */
 {(char *)"delete",      3,  (-1),            DeleteLine,  TRUE, FALSE,FALSE,TRUE, (char *)"1"}, /* comm1.c */
#if defined(DOS) || defined(OS2)
 {(char *)"delete",      0,  KEY_A_g,         DeleteLine,  FALSE,FALSE,FALSE,TRUE, (char *)"block"}, /* comm1.c */
#else
 {(char *)"delete",      0,  ControlG,        DeleteLine,  FALSE,FALSE,FALSE,TRUE, (char *)"block"}, /* comm1.c */
#endif
 {(char *)"directory",   3,  (-1),            Directory,   FALSE,FALSE,FALSE,TRUE, (char *)"1"}, /* comm1.c */
 {(char *)"dirinclude",  4,  (-1),            Dirinclude,  TRUE, TRUE, FALSE,TRUE, (char *)"*"}, /* commset1.c */
 {(char *)"ls",          2,  (-1),            Directory,   FALSE,FALSE,FALSE,TRUE, (char *)"1"}, /* comm1.c */
 {(char *)"display",     4,  (-1),            Display,     TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
 {(char *)"down",        1,  (-1),            Next,        TRUE, FALSE,FALSE,TRUE, (char *)"1"}, /* comm3.c */
 {(char *)"duplicate",   3,  (-1),            Duplicate,   TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm2.c */
#if defined(DOS) || defined(OS2)
 {(char *)"down_arrow",  0,  KEY_CURD,        Down_arrow,  FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm1.c */
 {(char *)"duplicate",   0,  KEY_A_d,         Duplicate,   TRUE, FALSE,FALSE,TRUE, (char *)"1 BLOCK"},  /* comm2.c */
#else
 {(char *)"down_arrow",  0,  KEY_DOWN,        Down_arrow,  FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm1.c */
 {(char *)"duplicate",   0,  ControlD,        Duplicate,   TRUE, FALSE,FALSE,TRUE, (char *)"1 BLOCK"},  /* comm2.c */
 {(char *)"enter",       0,  ControlM,        Enter,       FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm2.c */
 {(char *)"enter",       0,  KEY_ENTER,       Enter,       FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm2.c */
#endif
 {(char *)"enter",       0,  KEY_RETURN,      Enter,       FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm2.c */
 {(char *)"emsg",        4,  (-1),            Emsg,        TRUE, FALSE,FALSE,FALSE,(char *)""},  /* comm2.c */
 {(char *)"eolout",      4,  (-1),            Eolout,      TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
 {(char *)"etmode",      6,  (-1),            Etmode,      TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
 {(char *)"expand",      3,  (-1),            Expand,      TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm2.c */
 {(char *)"extract",     3,  (-1),            Extract,     TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm2.c */
 {(char *)"ffile",       2,  (-1),            Ffile,       TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm2.c */
#if defined(DOS) || defined(OS2)
 {(char *)"file",        4,  KEY_F3,          File,        TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm2.c */
 {(char *)"fillbox",     4,  KEY_A_f,         Fillbox,     FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm2.c */
#else
 {(char *)"file",        4,  KEY_F(3),        File,        TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm2.c */
 {(char *)"file",        0,  KEY_PF3,         File,        TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm2.c */
 {(char *)"fillbox",     4,  ControlF,        Fillbox,     FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm2.c */
#endif
#if defined(DOS) || defined(OS2)
 {(char *)"forward",     2,  KEY_PGDN,        Forward,     FALSE,FALSE,FALSE,TRUE, (char *)"1"}, /* comm2.c */
 {(char *)"forward",     2,  KEY_C_PGDN,      Forward,     FALSE,FALSE,FALSE,TRUE, (char *)"*"}, /* comm2.c */
#else
 {(char *)"forward",     2,  KEY_NPAGE,       Forward,     FALSE,FALSE,FALSE,TRUE, (char *)"1"}, /* comm2.c */
 {(char *)"forward",     2,  KEY_NextScrn,    Forward,     FALSE,FALSE,FALSE,TRUE, (char *)"1"}, /* comm2.c */
#endif
 {(char *)"get",         3,  (-1),            Get,         TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm2.c */
#if defined(DOS) || defined(OS2)
 {(char *)"help",        4,  KEY_F1,          Help,        FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm2.c */
#else
 {(char *)"help",        4,  KEY_F(1),        Help,        FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm2.c */
 {(char *)"help",        0,  KEY_PF1,         Help,        FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm2.c */
#endif
 {(char *)"hex",         3,  (-1),            Hex,         TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
 {(char *)"hexdisplay",  7,  (-1),            Hexdisplay,  TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
 {(char *)"impmacro",    5,  (-1),            Impmacro,    TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
 {(char *)"impos",       5,  (-1),            Impos,       TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
 {(char *)"impcmscp",    3,  (-1),            Impos,       TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
 {(char *)"input",       1,  (-1),            Input,       TRUE, FALSE,FALSE,FALSE,(char *)""},  /* comm2.c */
#if defined(DOS) || defined(OS2)
 {(char *)"insertmode",  7,  KEY_INS,         Insertmode,  TRUE, TRUE, FALSE,TRUE, (char *)"toggle"},  /* commset1.c */
 {(char *)"left_arrow",  0,  KEY_CURL,        Left_arrow,  FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm3.c */
 {(char *)"locate",      1,  KEY_S_F1,        Locate,      TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm3.c */
#else
 {(char *)"insertmode",  7,  KEY_IC,          Insertmode,  TRUE, TRUE, FALSE,TRUE, (char *)"toggle"},  /* commset1.c */
 {(char *)"left_arrow",  0,  KEY_LEFT,        Left_arrow,  FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm3.c */
 {(char *)"locate",      1,  KEY_F(11),       Locate,      TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm3.c */
#endif
 {(char *)"linend",      5,  (-1),            Linend,      TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
 {(char *)"lowercase",   3,  (-1),            Lowercase,   TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm3.c */
 {(char *)"macro",       5,  (-1),            Macro,       FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm3.c */
 {(char *)"macroext",    6,  (-1),            Macroext,    TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
 {(char *)"macropath",   6,  (-1),            Macropath,   TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
 {(char *)"margins",     3,  (-1),            Margins,     TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset1.c */
 {(char *)"mark",        4,  (-1),            Mark,        FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm3.c */
 {(char *)"modify",      3,  (-1),            Modify,      FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm3.c */
#if defined(DOS) || defined(OS2)
 {(char *)"mark",        0,  KEY_A_l,         Mark,        FALSE,FALSE,FALSE,TRUE, (char *)"line"},  /* comm3.c */
 {(char *)"mark",        0,  KEY_A_b,         Mark,        FALSE,FALSE,FALSE,TRUE, (char *)"box"},  /* comm3.c */
 {(char *)"move",        4,  KEY_A_m,         Move,        FALSE,FALSE,FALSE,TRUE, (char *)"block"},  /* comm3.c */
 {(char *)"nextwindow",  5,  KEY_F2,          Nextwindow,  FALSE,FALSE,FALSE,TRUE, (char *)""}, /* comm3.c */
 {(char *)"overlaybox",  8,  KEY_A_o,         Overlaybox,  FALSE,FALSE,FALSE,TRUE, (char *)""}, /* comm3.c */
#else
 {(char *)"mark",        0,  ControlL,        Mark,        FALSE,FALSE,FALSE,TRUE, (char *)"line"},  /* comm3.c */
 {(char *)"mark",        0,  ControlB,        Mark,        FALSE,FALSE,FALSE,TRUE, (char *)"box"},  /* comm3.c */
 {(char *)"move",        4,  ControlV,        Move,        FALSE,FALSE,FALSE,TRUE, (char *)"block"},  /* comm3.c */
 {(char *)"nextwindow",  5,  KEY_F(2),        Nextwindow,  FALSE,FALSE,FALSE,TRUE, (char *)""}, /* comm3.c */
 {(char *)"nextwindow",  5,  KEY_PF2,         Nextwindow,  FALSE,FALSE,FALSE,TRUE, (char *)""}, /* comm3.c */
 {(char *)"overlaybox",  8,  ControlO,        Overlaybox,  FALSE,FALSE,FALSE,TRUE, (char *)""}, /* comm3.c */
#endif
 {(char *)"msg",         3,  (-1),            Msg,         TRUE, FALSE,FALSE,FALSE,(char *)""}, /* comm3.c */
 {(char *)"msgmode",     4,  (-1),            Msgmode,     TRUE, TRUE, FALSE,TRUE, (char *)""}, /* commset2.c */
 {(char *)"newlines",    4,  (-1),            Newlines,    TRUE, TRUE, FALSE,TRUE, (char *)""}, /* commset2.c */
 {(char *)"next",        1,  (-1),            Next,        TRUE, FALSE,FALSE,TRUE, (char *)"1"}, /* comm3.c */
 {(char *)"nomsg",       5,  (-1),            Nomsg,       TRUE, FALSE,FALSE,TRUE, (char *)""}, /* comm3.c */
 {(char *)"nondisp",     4,  (-1),            Nondisp,     TRUE, TRUE, FALSE,TRUE, (char *)""}, /* commset1.c */
 {(char *)"nop",         3,  (-1),            Nop,         FALSE,FALSE,FALSE,TRUE, (char *)""}, /* comm3.c */
 {(char *)"number",      3,  (-1),            Number,      TRUE, TRUE, FALSE,TRUE, (char *)""}, /* commset2.c */
 {(char *)"osnowait",    3,  (-1),            Osnowait,    FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm3.c */
 {(char *)"osquiet",     3,  (-1),            Osquiet,     FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm3.c */
 {(char *)"os",          2,  (-1),            Os,          FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm3.c */
 {(char *)"dosnowait",   4,  (-1),            Osnowait,    FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm3.c */
 {(char *)"dosquiet",    4,  (-1),            Osquiet,     FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm3.c */
 {(char *)"dos",         3,  (-1),            Os,          FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm3.c */
 {(char *)"!",           1,  (-1),            Os,          FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm3.c */
 {(char *)"point",       1,  (-1),            Point,       TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset2.c */
 {(char *)"pending",     4,  (-1),            Pending,     TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset2.c */
#if defined(DOS) || defined(OS2)
 {(char *)"point",       0,  KEY_C_F11,       Point,       TRUE, TRUE, FALSE,TRUE, (char *)".a"},  /* commset2.c */
 {(char *)"locate",      0,  KEY_C_F12,       Locate,      TRUE, FALSE,FALSE,TRUE, (char *)".a"},  /* commset2.c */
#else
 {(char *)"point",       0,  KEY_F(31),       Point,       TRUE, TRUE, FALSE,TRUE, (char *)".a"},  /* commset2.c */
 {(char *)"locate",      0,  KEY_F(32),       Locate,      TRUE, FALSE,FALSE,TRUE, (char *)".a"},  /* commset2.c */
#endif
 {(char *)"prefix",      3,  (-1),            Prefix,      TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset2.c */
 {(char *)"printer",     7,  (-1),            Printer,     TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset2.c */
 {(char *)"print",       2,  (-1),            Print,       TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
 {(char *)"put",         3,  (-1),            Put,         TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
 {(char *)"putd",        4,  (-1),            Putd,        TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
#if defined(DOS) || defined(OS2)
 {(char *)"qquit",       2,  KEY_S_F3,        Qquit,       TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
#else
 {(char *)"qquit",       2,  KEY_F(13),       Qquit,       TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
#endif
 {(char *)"quit",        4,  (-1),            Quit,        TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
 {(char *)"query",       1,  (-1),            Query,       FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
#if defined(DOS) || defined(OS2)
 {(char *)"right_arrow", 0,  KEY_CURR,        Right_arrow, FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
 {(char *)"recover",     3,  KEY_F8,          Recover,     FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
 {(char *)"redraw",      6,  KEY_C_r,         Redraw,      FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
#else
 {(char *)"right_arrow", 0,  KEY_RIGHT,       Right_arrow, FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
 {(char *)"recover",     3,  KEY_F(8),        Recover,     FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
 {(char *)"redraw",      6,  ControlR,        Redraw,      FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
#endif
 {(char *)"refresh",     7,  (-1),            Refresh,     FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
 {(char *)"replace",     1,  (-1),            Replace,     TRUE, FALSE,FALSE,FALSE,(char *)""},  /* comm4.c */
 {(char *)"reprofile",   6,  (-1),            Reprofile,   TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset2.c */
 {(char *)"reserved",    5,  (-1),            Reserved,    TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset2.c */
 {(char *)"reset",       3,  (-1),            Reset,       FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
#if defined(DOS) || defined(OS2)
 {(char *)"reset",       0,  KEY_A_u,         Reset,       FALSE,FALSE,FALSE,TRUE, (char *)"block"},  /* comm4.c */
#else
 {(char *)"reset",       0,  ControlU,        Reset,       FALSE,FALSE,FALSE,TRUE, (char *)"block"},  /* comm4.c */
#endif
#if !defined(NOREXX)
 {(char *)"rexxoutput",  7,  (-1),            Rexxoutput,  TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset2.c */
#endif
 {(char *)"=",           1,  (-1),            Reexecute,   TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm5.c */
 {(char *)"?",           1,  (-1),            Retrieve,    FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm5.c */
 {(char *)"save",        4,  (-1),            Save,        TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
 {(char *)"schange",     3,  (-1),            Schange,     FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
 {(char *)"screen",      3,  (-1),            Screen,      FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
 {(char *)"scope",       5,  (-1),            Scope,       TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset2.c */
 {(char *)"select",      3,  (-1),            Select,      TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset2.c */
 {(char *)"set",         3,  (-1),            Set,         TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset2.c */
 {(char *)"shift",       2,  (-1),            Shift,       TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
 {(char *)"showkey",     4,  (-1),            ShowKey,     FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
 {(char *)"sort",        4,  (-1),            Sort,        TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
 {(char *)"sos",         3,  (-1),            Sos,         FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
 {(char *)"execute",     2,  (-1),            Sos_execute, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
#if defined(DOS) || defined(OS2)
 {(char *)"addline",     3,  KEY_F4,          Sos_addline, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"cursoradj",   7,  KEY_C_a,         Sos_cursoradj,FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"delback",     5,  KEY_BKSP,        Sos_delback, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"delchar",     4,  KEY_DEL,         Sos_delchar, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"delend",      4,  KEY_C_END,       Sos_delend,  FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"delline",     4,  KEY_F9,          Sos_delline, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"delword",     4,  KEY_A_w,         Sos_delword, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"doprefix",    5,  KEY_NUMENTER,    Sos_doprefix,FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"edit",        4,  KEY_A_x,         Sos_edit,    FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"endchar",     4,  KEY_END,         Sos_endchar, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"makecurr",    8,  KEY_F5,          Sos_makecurr,FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"tabf",        3,  KEY_TAB,         Sos_tabf,    FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"tabwordb",    8,  KEY_C_CURL,      Sos_tabwordb,FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"tabwordf",    7,  KEY_C_CURR,      Sos_tabwordf,FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"undo",        4,  KEY_ESC,         Sos_undo,    FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"split",       2,  KEY_A_s,         Split,       FALSE,FALSE,FALSE,TRUE, (char *)"aligned"},  /* comm4.c */
 {(char *)"join",        1,  KEY_A_j,         Join,        FALSE,FALSE,FALSE,TRUE, (char *)"aligned"},  /* comm2.c */
 {(char *)"spltjoin",    8,  KEY_F10,         Spltjoin,    FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
#else
 {(char *)"addline",     3,  KEY_F(4),        Sos_addline, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"addline",     3,  KEY_PF4,         Sos_addline, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"cursoradj",   7,  ControlA,        Sos_cursoradj,FALSE,FALSE,TRUE, TRUE,(char *)""},  /* commsos.c */
#ifdef OLD_DELBACK_DELCHAR
 {(char *)"delback",     4,  127,             Sos_delback, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"delchar",     4,  8,               Sos_delchar, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"delchar",     4,  KEY_DC,          Sos_delchar, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
#else
 {(char *)"delback",     4,  BackSpace,       Sos_delback, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"delback",     4,  ControlH,        Sos_delback, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"delback",     4,  8,               Sos_delback, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"delback",     4,  KEY_BACKSPACE,   Sos_delback, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"delchar",     4,  Del,             Sos_delchar, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"delchar",     4,  127,             Sos_delchar, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"delchar",     4,  KEY_DC,          Sos_delchar, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
#endif
 {(char *)"delend",      4,  ControlE,        Sos_delend,  FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"delline",     4,  KEY_F(9),        Sos_delline, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"delword",     4,  ControlW,        Sos_delword, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"doprefix",    5,  ControlP,        Sos_doprefix,FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"edit",        4,  ControlX,        Sos_edit,    FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"endchar",     4,  KEY_F(20),       Sos_endchar, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"makecurr",    8,  KEY_F(5),        Sos_makecurr,FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"tabf",        3,  Tab,             Sos_tabf,    FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"tabwordb",    8,  KEY_F(18),       Sos_tabwordb,FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"tabwordf",    7,  KEY_F(19),       Sos_tabwordf,FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"undo",        4,  ControlQ,        Sos_undo,    FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"split",       2,  ControlS,        Split,       FALSE,FALSE,FALSE,TRUE, (char *)"aligned"},  /* comm4.c */
 {(char *)"join",        1,  ControlJ,        Join,        FALSE,FALSE,FALSE,TRUE, (char *)"aligned"},  /* comm2.c */
 {(char *)"spltjoin",    8,  KEY_F(10),       Spltjoin,    FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
#endif
 {(char *)"lineadd",     5,  (-1),            Sos_addline, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"linedel",     5,  (-1),            Sos_delline, FALSE,FALSE,TRUE, TRUE, (char *)""},  /* commsos.c */
 {(char *)"ssave",       2,  (-1),            Ssave,       TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
 {(char *)"status",      4,  (-1),            Status,      TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
 {(char *)"stay",        4,  (-1),            Stay,        TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset2.c */
#if defined(DOS) || defined(OS2)
 {(char *)"suspend",     4,  KEY_C_z,         Suspend,     FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
 {(char *)"tabcmd",      4,  KEY_HOME,        Tabcmd,      FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm5.c */
 {(char *)"tabpre",      4,  KEY_NUMPLUS,     Tabpre,      FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm5.c */
#else
 {(char *)"suspend",     4,  ControlZ,        Suspend,     FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm4.c */
 {(char *)"tabcmd",      4,  KEY_HOME,        Tabcmd,      FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm5.c */
 {(char *)"tabcmd",      4,  KEY_Do,          Tabcmd,      FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm5.c */
 {(char *)"tabpre",      4,  KEY_F(12),       Tabpre,      FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm5.c */
#endif
 {(char *)"tabkey",      4,  (-1),            Tabkey,      TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset2.c */
 {(char *)"tabs",        4,  (-1),            Tabs,        TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset2.c */
 {(char *)"tabsin",      5,  (-1),            Tabsin,      TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset2.c */
 {(char *)"tabsout",     5,  (-1),            Tabsout,     TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset2.c */
 {(char *)"text",        4,  (-1),            Text,        FALSE,FALSE,FALSE,FALSE,(char *)""},  /* comm5.c */
#if defined(DOS) || defined(OS2)
 {(char *)"top",         3,  KEY_C_PGUP,      Top,         TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm5.c */
#else
 {(char *)"top",         3,  (-1),            Top,         TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm5.c */
#endif
 {(char *)"up",          1,  (-1),            Up,          TRUE, FALSE,FALSE,TRUE, (char *)"1"}, /* comm5.c */
#if defined(DOS) || defined(OS2)
 {(char *)"up_arrow",    0,  KEY_CURU,        Up_arrow,    FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm5.c */
#else
 {(char *)"up_arrow",    0,  KEY_UP,          Up_arrow,    FALSE,FALSE,FALSE,TRUE, (char *)""},  /* comm5.c */
#endif
 {(char *)"uppercase",   3,  (-1),            Uppercase,   TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm5.c */
 {(char *)"wordwrap",    5,  (-1),            Wordwrap,    TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset2.c */
 {(char *)"edit",        1,  (-1),            Xedit,       TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm5.c */
 {(char *)"xedit",       1,  (-1),            Xedit,       TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm5.c */
 {(char *)"the",         3,  (-1),            Xedit,       TRUE, FALSE,FALSE,TRUE, (char *)""},  /* comm5.c */
 {(char *)"verify",      1,  (-1),            Verify,      TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset2.c */
 {(char *)"zone",        1,  (-1),            Zone,        TRUE, TRUE, FALSE,TRUE, (char *)""},  /* commset2.c */
 {NULL,                           0,  (-1),            NULL,        FALSE,FALSE,FALSE,FALSE,(char *)""}   /* commset2.c */
};
