/***********************************************************************/
/* COMMSOS.C - sos commands.                                           */
/* This file contains all commands that can be assigned to function    */
/* keys or typed on the command line.                                  */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1993 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 5314
 * QLD 4121
 * Australia
 */

/*
$Header: C:\THE\RCS\commsos.c 1.4 1993/09/01 16:25:56 MH Interim MH $
*/

#include <stdio.h>

#include "the.h"
#include "proto.h"

/*#define DEBUG 1*/

/*man-start*********************************************************************



========================================================================
SOS COMMAND REFERENCE
========================================================================
**man-end**********************************************************************/

/*-------------------------- external data ----------------------------*/
extern LINE *first_command,*current_command,*last_command;
extern LINE *next_line,*curr_line;
extern VIEW_DETAILS *vd_current,*vd_first;
extern char current_screen;
extern SCREEN_DETAILS screen[MAX_SCREENS];        /* screen structures */
extern char current_file;         /* pointer to current file */
extern WINDOW *foot,*error_window;
extern bool error_on_screen;
extern char *rec;
extern unsigned short rec_len;
extern char *cmd_rec;
extern unsigned short cmd_rec_len;
extern char *pre_rec;
extern unsigned short pre_rec_len;
extern char mode_insert;        /* defines insert mode toggle */
extern char in_profile;    /* indicates if processing profile */
extern unsigned short file_start;

extern char *temp_cmd;
extern char dir_filename[10];
extern char dir_pathname[MAX_FILE_NAME+1];
extern char sp_path[MAX_FILE_NAME+1] ;
extern char sp_fname[MAX_FILE_NAME+1] ;
extern char dir_path[MAX_FILE_NAME+1] ;    /* for dir and ls commands */
extern bool prefix_changed;
/*man-start*********************************************************************
COMMAND
     SOS ADDline - add blank line after focus line
     SOS LINEAdd - add blank line after focus line

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The SOS ADDLINE command inserts a blank line in the file following
     the focus line. The cursor is placed in the column under the first
     non-blank in the focus line.

COMPATIBILITY
     XEDIT: Compatible.
     KEDIT: Compatible.

SEE ALSO
     SOS DELLINE

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Sos_addline(char *params)
#else
int Sos_addline(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 short rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_addline");
#endif
 rc = Add("1");
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     SOS CURSORAdj - move first non-blank character to cursor

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The SOS CURSORADJ command moves text in the focus line so that
     the first non-blank character appears under the cursor position.

COMPATIBILITY
     XEDIT: N/A
     KEDIT: Compatible.

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Sos_cursoradj(char *params)
#else
int Sos_cursoradj(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 short num_cols,first_non_blank_col,col,rc;
 unsigned short x,y;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_cursoradj");
#endif
 getyx(CURRENT_WINDOW,y,x);
 switch (CURRENT_VIEW->current_window)
   {
    case WINDOW_MAIN:
         if (FOCUS_TOF || FOCUS_BOF)
           {
            display_error(38,(char *)"");
#ifdef TRACE
            trace_return();
#endif
            return(RC_INVALID_ENVIRON);
           }
         col = x + CURRENT_VIEW->verify_col - 1;
         first_non_blank_col = strzne(rec,' ');
         if (first_non_blank_col == (-1))
            first_non_blank_col = 0;
         num_cols = first_non_blank_col - col;
         if (num_cols < 0)
            rc = execute_shift_command(FALSE,-num_cols,CURRENT_VIEW->focus_line,1);
         else
            if (num_cols > 0)
               rc = execute_shift_command(TRUE,num_cols,CURRENT_VIEW->focus_line,1);
         break;
    default:
         break;
   }
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     SOS DELBAck - delete the character to the left of the cursor

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The SOS DELBACK command moves the cursor one character to the left
     and deletes the character now under the cursor.

COMPATIBILITY
     XEDIT: N/A
     KEDIT: Compatible.

SEE ALSO
     SOS DELCHAR

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Sos_delback(char *params)
#else
int Sos_delback(params)
char *params;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern bool extended_display_mode;
 extern bool CMDARROWSTABLRx;
/*--------------------------- local data ------------------------------*/
 unsigned short x,y;
 bool save_CMDARROWSTABLRx = CMDARROWSTABLRx;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_delback");
#endif
 getyx(CURRENT_WINDOW,y,x);
 switch (CURRENT_VIEW->current_window)
   {
    case WINDOW_MAIN:
         if (FOCUS_TOF || FOCUS_BOF)
           {
            display_error(38,(char *)"");
#ifdef TRACE
            trace_return();
#endif
            return(RC_INVALID_ENVIRON);
           }
         break;
    case WINDOW_COMMAND:
         if (x == 0)
           {
#ifdef TRACE
            trace_return();
#endif
            return(RC_OK);
           }
         mvwdelch(CURRENT_WINDOW,y,x-1);
         if (x <= cmd_rec_len)
           {
            cmd_rec = (char *)memdelchr((char *)cmd_rec,
                                               x-1,cmd_rec_len,1);
            cmd_rec_len--;
           }
#ifdef TRACE
         trace_return();
#endif
         return(RC_OK);
         break;
    case WINDOW_PREFIX:
         if (x == 0)
           {
#ifdef TRACE
            trace_return();
#endif
            return(RC_OK);
           }
         prefix_changed = TRUE;
         mvwdelch(CURRENT_WINDOW,y,x-1);
         if (x <= pre_rec_len)
           {
            pre_rec = (char *)memdelchr((char *)pre_rec,
                                               x-1,pre_rec_len,1);
            pre_rec_len--;
           }
#ifdef TRACE
            trace_return();
#endif
         return(RC_OK);
         break;
    default:
         break;
   }
/*---------------------------------------------------------------------*/
/* Remainder of processing is only for WINDOW_MAIN.                    */
/*---------------------------------------------------------------------*/
 if (x == 0 && CURRENT_VIEW->verify_start == CURRENT_VIEW->verify_col)
   {
#ifdef TRACE
    trace_return();
#endif
    return(RC_OK);
   }
 CMDARROWSTABLRx = FALSE;
 Left_arrow("");
 CMDARROWSTABLRx = save_CMDARROWSTABLRx;
/*---------------------------------------------------------------------*/
/* If we are after the last character of the line, exit.               */
/*---------------------------------------------------------------------*/
 if (x+CURRENT_VIEW->verify_col-1 > rec_len)
   {
#ifdef TRACE
    trace_return();
#endif
    return(RC_OK);
   }

 getyx(CURRENT_WINDOW,y,x);
 mvwdelch(CURRENT_WINDOW,y,x);

 rec = (char *)memdelchr((char *)rec,CURRENT_VIEW->verify_col-1+x,rec_len,1);
 rec_len--;
/*---------------------------------------------------------------------*/
/* If there is a character off the right edge of the screen, display it*/
/* in the last character of the main window.                           */
/*---------------------------------------------------------------------*/
 if (CURRENT_VIEW->verify_col-1+CURRENT_SCREEN.cols-1 < rec_len)
   {
    wmove(CURRENT_WINDOW,y,CURRENT_SCREEN.cols-1);
    if (extended_display_mode)
       waddch(CURRENT_WINDOW,rec[CURRENT_VIEW->verify_col-1+CURRENT_SCREEN.cols-1]);
    else
       put_char(CURRENT_WINDOW,
             rec[CURRENT_VIEW->verify_col-1+CURRENT_SCREEN.cols-1],ADDCHAR);
    wmove(CURRENT_WINDOW,y,x);
   }
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/*man-start*********************************************************************
COMMAND
     SOS DELChar - delete character under cursor

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The SOS DELCHAR command deletes the character under the cursor.
     Text to the right is shifted to the left.

COMPATIBILITY
     XEDIT: N/A
     KEDIT: Compatible.

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Sos_delchar(char *params)
#else
int Sos_delchar(params)
char *params;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern bool extended_display_mode;
/*--------------------------- local data ------------------------------*/
 unsigned short x,y;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_delchar");
#endif
/*---------------------------------------------------------------------*/
/* Do not allow this command on the top or bottom of file lines.       */
/*---------------------------------------------------------------------*/
 if (CURRENT_VIEW->current_window == WINDOW_MAIN
 &&  (FOCUS_TOF || FOCUS_BOF))
      {
       display_error(38,(char *)"");
#ifdef TRACE
       trace_return();
#endif
       return(RC_INVALID_ENVIRON);
      }
 getyx(CURRENT_WINDOW,y,x);
 wdelch(CURRENT_WINDOW);
 switch (CURRENT_VIEW->current_window)
   {
    case WINDOW_COMMAND:
         if (x < cmd_rec_len)
           {
            cmd_rec = (char *)memdelchr((char *)cmd_rec,
                                               x,cmd_rec_len,1);
            cmd_rec_len--;
           }
#ifdef TRACE
         trace_return();
#endif
         return(RC_OK);
         break;
    case WINDOW_PREFIX:
         if (x < pre_rec_len)
           {
            prefix_changed = TRUE;
            pre_rec = (char *)memdelchr((char *)pre_rec,
                                               x,pre_rec_len,1);
            pre_rec_len--;
           }
#ifdef TRACE
         trace_return();
#endif
         return(RC_OK);
         break;
    default:
         break;
   }

/*---------------------------------------------------------------------*/
/* If we are after the last character of the line, exit.               */
/*---------------------------------------------------------------------*/
 if (x+CURRENT_VIEW->verify_col > rec_len)
   {
#ifdef TRACE
    trace_return();
#endif
    return(RC_OK);
   }

 rec = (char *)memdelchr((char *)rec,CURRENT_VIEW->verify_col-1+x,rec_len,1);
 rec_len--;
/*---------------------------------------------------------------------*/
/* If there is a character off the right edge of the screen, display it*/
/* in the last character of the main window.                           */
/*---------------------------------------------------------------------*/
 if (CURRENT_VIEW->verify_col-1+CURRENT_SCREEN.cols-1 < rec_len)
   {
    wmove(CURRENT_WINDOW,y,CURRENT_SCREEN.cols-1);
    if (extended_display_mode)
       waddch(CURRENT_WINDOW,rec[CURRENT_VIEW->verify_col-1+CURRENT_SCREEN.cols-1]);
    else
       put_char(CURRENT_WINDOW,
             rec[CURRENT_VIEW->verify_col-1+CURRENT_SCREEN.cols-1],ADDCHAR);
    wmove(CURRENT_WINDOW,y,x);
   }
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/*man-start*********************************************************************
COMMAND
     SOS DELEnd - delete to end of line

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The SOS DELEND command deletes all characters from the current
     column to the end of line.

COMPATIBILITY
     XEDIT: N/A
     KEDIT: Compatible.

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Sos_delend(char *params)
#else
int Sos_delend(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 register short i;
 unsigned short col,x,y;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_delend");
#endif
 getyx(CURRENT_WINDOW,y,x);
 switch (CURRENT_VIEW->current_window)
   {
    case WINDOW_MAIN:
         if (FOCUS_TOF || FOCUS_BOF)
           {
            display_error(38,(char *)"");
#ifdef TRACE
            trace_return();
#endif
            return(RC_INVALID_ENVIRON);
           }
         col = x + CURRENT_VIEW->verify_col - 1;
         for (i=col;i<max_line_length;i++)
             rec[i] = ' ';
         if (rec_len > col)
            rec_len = col;
         break;
    case WINDOW_COMMAND:
         for (i=x;i<COLS;i++)
             cmd_rec[i] = ' ';
         if (cmd_rec_len > x)
            cmd_rec_len = x;
         break;
    case WINDOW_PREFIX:
         prefix_changed = TRUE;
         for (i=x;i<PREFIX_WIDTH;i++)
             pre_rec[i] = ' ';
         if (pre_rec_len > x)
            pre_rec_len = x;
         break;
    default:
         break;
   }
 my_wclrtoeol(CURRENT_WINDOW);
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/*man-start*********************************************************************
COMMAND
     SOS DELLine - delete focus line
     SOS LINEDel - delete focus line

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The SOS DELLINE command deletes the focus line.

COMPATIBILITY
     XEDIT: Compatible.
     KEDIT: Compatible.

SEE ALSO
     SOS ADDLINE

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Sos_delline(char *params)
#else
int Sos_delline(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 short rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_delline");
#endif
 rc = DeleteLine("1");
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     SOS DELWord - delete word at or right of cursor

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The SOS DELWORD command deletes the word at or to the right
     of the current cursor position.

COMPATIBILITY
     XEDIT: N/A
     KEDIT: Compatible.

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Sos_delword(char *params)
#else
int Sos_delword(params)
char *params;
#endif
/***********************************************************************/
{
#define FIRST_BLANK  0
#define SECOND_BLANK 1
#define FIRST_WORD   2
#define SECOND_WORD  3
/*--------------------------- local data ------------------------------*/
 register short i;
 short rc;
 int state,cursor_off;
 unsigned short x,y,temp_rec_len;
 short num_cols,col,col_pos,rec_pos,left_col;
 char *temp_rec;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_delword");
#endif
/*---------------------------------------------------------------------*/
/* This function is not applicable to the PREFIX window.               */
/*---------------------------------------------------------------------*/
 getyx(CURRENT_WINDOW,y,x);
 switch(CURRENT_VIEW->current_window)
   {
    case WINDOW_PREFIX:
         display_error(38,(char *)"");
#ifdef TRACE
         trace_return();
#endif
         return(RC_INVALID_ENVIRON);
         break;
    case WINDOW_MAIN:
         temp_rec = rec;
         temp_rec_len = rec_len;
         left_col = CURRENT_VIEW->verify_col-1;
         break;
    case WINDOW_COMMAND:
         temp_rec = cmd_rec;
         temp_rec_len = cmd_rec_len;
         left_col = 0;
         break;
   }
/*---------------------------------------------------------------------*/
/* If we are after the last column of the line, then just ignore the   */
/* command and leave the cursor where it is.                           */
/*---------------------------------------------------------------------*/
 if ((x + left_col) >= temp_rec_len)
   {
#ifdef TRACE
    trace_return();
#endif
    return(RC_OK);
   }
/*---------------------------------------------------------------------*/
/* Determine the end   of the next word, or go to the end of the line  */
/* if already at or past beginning of last word.                       */
/*---------------------------------------------------------------------*/
 cursor_off = num_cols = 0;
 if (*(temp_rec+left_col+x) == ' ')
    state = FIRST_BLANK;
 else
   {
    state = FIRST_WORD;
    for (i=left_col+x;;i--)
      {
       if (*(temp_rec+i) == ' '
       ||  i == -1)
         {
          cursor_off++;
          break;
         }
       cursor_off--;
      }
   }
 for (i=left_col+x+cursor_off;i<temp_rec_len;i++)
   {
    switch(state)
       {
        case FIRST_BLANK:
             if (*(temp_rec+i) != ' ')
                state = FIRST_WORD;
             break;
        case FIRST_WORD:
             if (*(temp_rec+i) == ' ')
                state = SECOND_BLANK;
             break;
        case SECOND_BLANK:
             if (*(temp_rec+i) != ' ')
                state = SECOND_WORD;
             break;
       }
    if (state == SECOND_WORD)
       break;
    num_cols++;
   }
/*---------------------------------------------------------------------*/
/* Delete from the field the number of columns calculated above        */
/* and adjust the appropriate record length.                           */
/*---------------------------------------------------------------------*/
 temp_rec = memdelchr(temp_rec,left_col+x+cursor_off,temp_rec_len,num_cols);
 switch(CURRENT_VIEW->current_window)
   {
    case WINDOW_MAIN:
         rec_len -= num_cols;
/*       post_process_line(CURRENT_VIEW->focus_line);*/
         col_pos = x;
         if ((col_pos+cursor_off) >= 0)
           {
            show_page();
            wmove(CURRENT_WINDOW,y,x+cursor_off);
           }
         else
           {
            rec_pos = left_col + x + cursor_off;
            x = CURRENT_SCREEN.cols / 2;
            CURRENT_VIEW->verify_col = max(1,rec_pos - x + 2);
            rec_pos = (CURRENT_VIEW->verify_col == 1) ? rec_pos : x - 1;
            wmove(CURRENT_WINDOW,y,rec_pos);
            show_page();
           }
         break;
    case WINDOW_COMMAND:
         cmd_rec_len -= num_cols;
         wmove(CURRENT_WINDOW,y,x+cursor_off);
         for (i=0;i<num_cols;i++)
            wdelch(CURRENT_WINDOW);
         break;
   }
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     SOS DOPREfix - execute any pending prefix commands

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The SOS DOPREFIX command executes any pending prefix commands.

COMPATIBILITY
     XEDIT: N/A
     KEDIT: Compatible.

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Sos_doprefix(char *params)
#else
int Sos_doprefix(params)
char *params;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
/*--------------------------- local data ------------------------------*/
 int rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_doprefix");
#endif
/*---------------------------------------------------------------------*/
/*                                                                     */
/*---------------------------------------------------------------------*/
/* post_process_line(CURRENT_VIEW->focus_line);*/
 rc = execute_prefix_commands();
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     SOS EDIT - edit a file from directory list

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The SOS EDIT command allows the user to edit a file, chosen from
     a directory list.(the file DIR.DIR).

COMPATIBILITY
     XEDIT: N/A
     KEDIT: Compatible with default definition for Alt-X key.

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Sos_edit(char *params)
#else
int Sos_edit(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 register short i,j;
 unsigned short col,x,y;
 LINE *curr;
 char edit_fname[MAX_FILE_NAME];
 int rc;
 long true_line;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_edit");
#endif
/*---------------------------------------------------------------------*/
/* If the current file is not the special DIR.DIR file exit.           */
/*---------------------------------------------------------------------*/
 if (CURRENT_FILE->pseudo_file != PSEUDO_DIR)
   {
#ifdef TRACE
    trace_return();
#endif
    return(RC_INVALID_ENVIRON);
   }
/*---------------------------------------------------------------------*/
/* Determine which line contains a vaild file to edit. TOF and EOF are */
/* invalid positions.                                                  */
/*---------------------------------------------------------------------*/
 if (CURRENT_VIEW->current_window == WINDOW_COMMAND)
   {
    if (CURRENT_TOF || CURRENT_BOF)
      {
#ifdef TRACE
       trace_return();
#endif
       return(RC_INVALID_ENVIRON);
      }
    true_line = CURRENT_VIEW->current_line;
   }
 else
   {
    getyx(CURRENT_WINDOW,y,x);
    if (FOCUS_TOF || FOCUS_BOF)
      {
#ifdef TRACE
       trace_return();
#endif
       return(RC_INVALID_ENVIRON);
      }
    true_line = CURRENT_VIEW->focus_line;
   }
/*---------------------------------------------------------------------*/
/* Find the current LINE pointer for the focus_line.                   */
/*---------------------------------------------------------------------*/
#ifdef USE_VOID
 curr = (LINE *)ll_find((void *)CURRENT_FILE->first_line,true_line);
#else
 curr = lll_find(CURRENT_FILE->first_line,true_line);
#endif
/*---------------------------------------------------------------------*/
 post_process_line(CURRENT_VIEW->focus_line);
/*---------------------------------------------------------------------*/
/* Validate that the supplied file is valid.                           */
/*---------------------------------------------------------------------*/
 strcpy(edit_fname,dir_path);
 strcat(edit_fname,curr->line+file_start);
 if ((rc = splitpath(edit_fname)) != RC_OK)
   {
    display_error(10,temp_cmd);
#ifdef TRACE
    trace_return();
#endif
    return(rc);
   }
/*---------------------------------------------------------------------*/
/* Edit the file.                                                      */
/*---------------------------------------------------------------------*/
 strcpy(edit_fname,sp_path);
 strcat(edit_fname,sp_fname);
 rc = Xedit(edit_fname);
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     SOS ENDChar - move cursor to end/start of focus line

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The SOS ENDCHAR command moves the cursor to the first character
     displayed in the current window, if the cursor is after the last
     character displayed in the current window, or to the position after
     the last character displayed in the current window, if the cursor is
     anywhere else.

COMPATIBILITY
     XEDIT: N/A
     KEDIT: Compatible. See below.
     The possible combinations of VERIFY etc. make mimicing KEDIT very
     difficult. The command is, on the surface, compatible.

STATUS
     incomplete-problem determining exactly where the cursor should go
     when a verify end is in place and we are going to the end of line
**man-end**********************************************************************/
#ifdef PROTO
int Sos_endchar(char *params)
#else
int Sos_endchar(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 register short i;
 unsigned short col,x,y,line_col;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_endchar");
#endif
 getyx(CURRENT_WINDOW,y,x);
 switch(CURRENT_VIEW->current_window)
   {
    case WINDOW_PREFIX:
#ifdef TRACE
         trace_return();
#endif
         return(RC_INVALID_ENVIRON);
         break;
    case WINDOW_COMMAND:
         if (x >= cmd_rec_len)
            wmove(CURRENT_WINDOW,y,0);
         else
            wmove(CURRENT_WINDOW,y,cmd_rec_len);
#ifdef TRACE
         trace_return();
#endif
         return(RC_OK);
         break;
    default:
         break;
   }
/*---------------------------------------------------------------------*/
/* Processing from here is for main window only.                       */
/*---------------------------------------------------------------------*/
 line_col = x + CURRENT_VIEW->verify_col;
 if (line_col > min(rec_len,CURRENT_VIEW->verify_end))
   {
    CURRENT_VIEW->verify_col = max(CURRENT_VIEW->verify_start,1);
    show_page();
    wmove(CURRENT_WINDOW,y,0);
   }
 else
   {
    if (rec_len < CURRENT_SCREEN.cols)
      {
       x = min(rec_len-(CURRENT_VIEW->verify_col-1),CURRENT_VIEW->verify_end);
       wmove(CURRENT_WINDOW,y,x);
      }
    else
      {
       x = CURRENT_SCREEN.cols / 2;
       CURRENT_VIEW->verify_col = rec_len-x+1;
       show_page();
       wmove(CURRENT_WINDOW,y,x);
      }
   }
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/*man-start*********************************************************************
COMMAND
     SOS EXecute - move cursor to command line and execute command

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The SOS EXECUTE command moves the cursor to the command line
     and executes any command that is on the command line.

COMPATIBILITY
     XEDIT: N/A
     KEDIT: Compatible

STATUS
     Complete...but because of potential infinite recursion, this function
     has been suspended.
**man-end**********************************************************************/
#ifdef PROTO
int Sos_execute(char *params)
#else
int Sos_execute(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 int rc=RC_OK;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_execute");
#endif

#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);


 if (CURRENT_VIEW->current_window != WINDOW_COMMAND)
    rc = Tabcmd("");
 if (rc == RC_OK)
    rc = Enter("");

#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     SOS MAKECURR - make focus line the current line

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The SOS MAKECURR command set the current line to the current focus
     line.

COMPATIBILITY
     XEDIT: N/A
     KEDIT: Compatible.

SEE ALSO

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Sos_makecurr(char *params)
#else
int Sos_makecurr(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 int rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_makecurr");
#endif
 rc = execute_makecurr(CURRENT_VIEW->focus_line);
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     SOS TABf - move cursor to next tab stop

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The SOS TABF command causes the cursor to move to the next tab column
     as set by the TABS command. (The default is 8).
     If the resulting column is beyond the right hand edge of the main
     window, the window will scroll half a window.

COMPATIBILITY
     XEDIT: Does not allow arguments.
     KEDIT: Compatible. See below.
     Does not line tab to next line if after the right hand tab column.

SEE ALSO
     tabs

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Sos_tabf(char *params)
#else
int Sos_tabf(params)
char *params;
#endif
/***********************************************************************/
{
extern char tabkey_insert,tabkey_overwrite;
/*--------------------------- local data ------------------------------*/
 unsigned short x,y,num_cols,next_tab_col;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_tabf");
#endif
/*---------------------------------------------------------------------*/
/* If the actual tab character is to be display then exit so that      */
/* editor() can process it as a raw key.                               */
/*---------------------------------------------------------------------*/
 if (mode_insert && tabkey_insert == 'C')
   {
#ifdef TRACE
    trace_return();
#endif
    return(RAW_KEY);
   }
 if (!mode_insert && tabkey_overwrite == 'C')
   {
#ifdef TRACE
    trace_return();
#endif
    return(RAW_KEY);
   }

 getyx(CURRENT_WINDOW,y,x);
/*---------------------------------------------------------------------*/
/* First determine the number of characters to move to the right from  */
/* the current column.                                                 */
/*---------------------------------------------------------------------*/
 num_cols = (CURRENT_VIEW->tabs) -
            ((x + CURRENT_VIEW->verify_col) % CURRENT_VIEW->tabs);
 next_tab_col = x + CURRENT_VIEW->verify_col + num_cols;
/*---------------------------------------------------------------------*/
/* Check for going past end of line - max_line_length                  */
/*---------------------------------------------------------------------*/
 if (CURRENT_VIEW->verify_col+x+num_cols > max_line_length)
   {
#ifdef TRACE
    trace_return();
#endif
    return(RC_TRUNCATED);
   }
/*---------------------------------------------------------------------*/
/* For all windows, if the new cursor position does not exceed the     */
/* right edge, move there.                                             */
/*---------------------------------------------------------------------*/
 if (x+num_cols <= CURRENT_SCREEN.cols-1)
   {
    wmove(CURRENT_WINDOW,y,x+num_cols);
#ifdef TRACE
    trace_return();
#endif
    return(RC_OK);
   }
/*---------------------------------------------------------------------*/
/* For MAIN window, if the new cursor position exceeds the right edge  */
/* scroll the window half the width of the main window.                */
/*---------------------------------------------------------------------*/
 if (CURRENT_VIEW->current_window == WINDOW_MAIN)
    if (x+num_cols > CURRENT_SCREEN.cols-1)
      {
       x = CURRENT_SCREEN.cols / 2;
       CURRENT_VIEW->verify_col += x;
       show_page();
       wmove(CURRENT_WINDOW,y,(next_tab_col-CURRENT_VIEW->verify_col));
/*       wmove(CURRENT_WINDOW,y,(x+num_cols)-1);*/
      }
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/*man-start*********************************************************************
COMMAND
     SOS TABWORDB - move cursor to beginning of previous word

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The SOS TABWORDB command causes the cursor to move to the first character
     of the word to the left or to the start of the line if no more
     words precede.
     If the resulting column is beyond the left hand edge of the main
     window, the window will scroll half a window.

COMPATIBILITY
     XEDIT: N/A
     KEDIT: Compatible.

SEE ALSO
     SOS TABWORDF

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Sos_tabwordb(char *params)
#else
int Sos_tabwordb(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 unsigned short x,y,temp_rec_len;
 short start_word_col;
 unsigned short word_break;
 char *temp_rec;
 register short i;
 short num_cols,col_pos,col,left_col;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_tabwordb");
#endif
/*---------------------------------------------------------------------*/
/* This function is not applicable to the PREFIX window.               */
/*---------------------------------------------------------------------*/
 getyx(CURRENT_WINDOW,y,x);
 switch(CURRENT_VIEW->current_window)
   {
    case WINDOW_PREFIX:
         display_error(38,(char *)"");
#ifdef TRACE
         trace_return();
#endif
         return(RC_INVALID_ENVIRON);
         break;
    case WINDOW_MAIN:
         temp_rec = rec;
         temp_rec_len = rec_len;
         left_col = CURRENT_VIEW->verify_col-1;
         break;
    case WINDOW_COMMAND:
         temp_rec = cmd_rec;
         temp_rec_len = cmd_rec_len;
         left_col = 0;
         break;
   }
/*---------------------------------------------------------------------*/
/* Determine the start of the prior word, or go to the start of the    */
/* line if already at or before beginning of prior word.               */
/*---------------------------------------------------------------------*/
 word_break = 0;
 start_word_col = (-1);
 for (i=left_col+x;i>0;i--)
   {
    switch(word_break)
      {
       case 0:  /* still in current word */
            if (*(temp_rec+i) == ' ')
               word_break++;
            break;
       case 1:  /* in first blank space */
            if (*(temp_rec+i) != ' ')
               word_break++;
            break;
       case 2:  /* in previous word */
            if (*(temp_rec+i) == ' ')
              {
               start_word_col = i+1;
               word_break++;
              }
            break;
       default: /* should not get here */
            break;
      }
    if (word_break == 3)
       break;
   }
 if (start_word_col == (-1))
    start_word_col = 0;
 num_cols = (x + left_col) - start_word_col;
/*---------------------------------------------------------------------*/
/* For all windows, if the new cursor position is not less than the    */
/* left edge,  move there.                                             */
/* If in command window, this should always be true.                   */
/*---------------------------------------------------------------------*/
 col_pos = x;
 if (col_pos-num_cols >= 0)
   {
    wmove(CURRENT_WINDOW,y,x-num_cols);
#ifdef TRACE
    trace_return();
#endif
    return(RC_OK);
   }
/*---------------------------------------------------------------------*/
/* For MAIN window, if the new cursor position exceeds the right edge  */
/* scroll the window making the cursor appear in the window.           */
/*---------------------------------------------------------------------*/
 x = CURRENT_SCREEN.cols / 2;
 CURRENT_VIEW->verify_col = max(1,start_word_col - (short)x + 2);
 start_word_col = (CURRENT_VIEW->verify_col == 1) ? start_word_col : x - 1;
 wmove(CURRENT_WINDOW,y,start_word_col);
 show_page();
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/*man-start*********************************************************************
COMMAND
     SOS TABWORDf - move cursor to start of next word

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The SOS TABWORDF command causes the cursor to move to the first character
     of the next word to the right or to the end of the line if no more
     words follow.
     If the resulting column is beyond the right hand edge of the main
     window, the window will scroll half a window.

COMPATIBILITY
     XEDIT: N/A
     KEDIT: Compatible.

SEE ALSO
     SOS TABWORDB

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Sos_tabwordf(char *params)
#else
int Sos_tabwordf(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 unsigned short x,y,temp_rec_len,num_cols;
 short start_word_col,left_col;
 bool word_break;
 char *temp_rec;
 register short i;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_tabwordf");
#endif
/*---------------------------------------------------------------------*/
/* This function is not applicable to the PREFIX window.               */
/*---------------------------------------------------------------------*/
 getyx(CURRENT_WINDOW,y,x);
 switch(CURRENT_VIEW->current_window)
   {
    case WINDOW_PREFIX:
         display_error(38,(char *)"");
#ifdef TRACE
         trace_return();
#endif
         return(RC_INVALID_ENVIRON);
         break;
    case WINDOW_MAIN:
         temp_rec = rec;
         temp_rec_len = rec_len;
         left_col = CURRENT_VIEW->verify_col-1;
         break;
    case WINDOW_COMMAND:
         temp_rec = cmd_rec;
         temp_rec_len = cmd_rec_len;
         left_col = 0;
         break;
   }
/*---------------------------------------------------------------------*/
/* If we are after the last column of the line, then just ignore the   */
/* command and leave the cursor where it is.                           */
/*---------------------------------------------------------------------*/
 if ((x + left_col) > temp_rec_len)
   {
#ifdef TRACE
    trace_return();
#endif
    return(RC_OK);
   }
/*---------------------------------------------------------------------*/
/* Determine the start of the next word, or go to the end of the line  */
/* if already at or past beginning of last word.                       */
/*---------------------------------------------------------------------*/
 word_break = FALSE;
 start_word_col = (-1);
 for (i=left_col+x;i<temp_rec_len;i++)
   {
    if (*(temp_rec+i) == ' ')
       word_break = TRUE;
    else
      {
       if (word_break)
         {
          start_word_col = i;
          break;
         }
      }
   }
 if (start_word_col == (-1))
    start_word_col = temp_rec_len;
 num_cols =  start_word_col - (x + CURRENT_VIEW->verify_col -1);
/*---------------------------------------------------------------------*/
/* For all windows, if the new cursor position does not exceed the     */
/* right edge, move there.                                             */
/* If in command window, this should always be true.                   */
/*---------------------------------------------------------------------*/
 if (x+num_cols <= CURRENT_SCREEN.cols-1
 || CURRENT_VIEW->current_window == WINDOW_COMMAND)
   {
    wmove(CURRENT_WINDOW,y,x+num_cols);
#ifdef TRACE
    trace_return();
#endif
    return(RC_OK);
   }
/*---------------------------------------------------------------------*/
/* For MAIN window, if the new cursor position exceeds the right edge  */
/* scroll the window half the width of the main window.                */
/*---------------------------------------------------------------------*/
 x = CURRENT_SCREEN.cols / 2;
 CURRENT_VIEW->verify_col = max(1,start_word_col - x + 2);
 start_word_col = (CURRENT_VIEW->verify_col == 1) ? start_word_col : x - 1;
 wmove(CURRENT_WINDOW,y,start_word_col);
 show_page();
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/*man-start*********************************************************************
COMMAND
     SOS UNDO - undo changes to the current line

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The SOS UNDO command causes the contents of the focus line (or the
     command line) to be reset to the contents before the cursor was
     positioned there.

COMPATIBILITY
     XEDIT: N/A
     KEDIT: Compatible. See below.
     Basically compatible. Doesn't restore the cursor to the original
     column position.

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Sos_undo(char *params)
#else
int Sos_undo(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 unsigned short x,y,temp_rec_len,num_cols;
 short start_word_col;
 bool word_break;
 char *temp_rec;
 register short i;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_undo");
#endif
 switch (CURRENT_VIEW->current_window)
   {
    case WINDOW_MAIN:
         pre_process_line(CURRENT_VIEW->focus_line);
         show_page();
         break;
    case WINDOW_COMMAND:
         memset(cmd_rec,' ',COLS);
         cmd_rec_len = 0;
         wmove(CURRENT_WINDOW,0,0);
         my_wclrtoeol(CURRENT_WINDOW);
         break;
    case WINDOW_PREFIX:
         prefix_changed = TRUE;
         memset(pre_rec,' ',PREFIX_WIDTH);
         pre_rec_len = 0;
         getyx(CURRENT_WINDOW,y,x);
         wmove(CURRENT_WINDOW,y,0);
         my_wclrtoeol(CURRENT_WINDOW);
         break;
    default:
         break;
   }
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
