/***********************************************************************/
/* EDIT.C - The body of the program.                                   */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1993 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 5314
 * QLD 4121
 * Australia
 */

/*
$Header: C:\THE\RCS\edit.c 1.4 1993/09/01 16:26:15 MH Interim MH $
*/

#include <stdio.h>
#include <time.h>

#include "the.h"
#include "proto.h"

/*#define TRACE*/
 bool prefix_changed=FALSE;
/*-------------------------- external data ----------------------------*/
extern LINE *next_line,*curr_line;
extern VIEW_DETAILS *vd_current,*vd_first,*vd_mark;
extern char current_file;         /* pointer to current file */
extern char number_of_views;                   /* number of open files */
extern char number_of_files;                   /* number of open files */
extern char current_screen;
extern SCREEN_DETAILS screen[MAX_SCREENS];        /* screen structures */
extern WINDOW *foot,*error_window;
extern bool error_on_screen;
extern char file_disposition;
extern short file_start;
extern char *dirfilename;
/***********************************************************************/
#ifdef PROTO
void editor(void)
#else
void editor()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 short key=0;
 unsigned short x,y;
 int rc;
 char string_key[2];
 VIEW_DETAILS *save_vd=vd_current;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("edit.c:    editor");
#endif
/*---------------------------------------------------------------------*/
/* For each view, calculate the current_row value. This has to be done */
/* AFTER initscr() so that the size of the filearea is known.          */
/*---------------------------------------------------------------------*/
 CURRENT_VIEW = vd_first;
 do
   {
    CURRENT_VIEW->current_row = calculate_current_row(CURRENT_VIEW->current_base,
                                                      CURRENT_VIEW->current_off,
                                                      CURRENT_SCREEN.rows);
    CURRENT_VIEW = NEXT_VIEW;
   }
 while(CURRENT_VIEW);
 CURRENT_VIEW = save_vd;
/*---------------------------------------------------------------------*/
/* Display the current view(s)...                                      */
/*---------------------------------------------------------------------*/
 show_page();
 show_heading();
 show_footing();
 if (CURRENT_VIEW->prefix)
    wnoutrefresh(CURRENT_WINDOW_PREFIX);
/*---------------------------------------------------------------------*/
/* Put the cursor into the column between file time and file name for  */
/* the special DIR.DIR file.                                           */
/*---------------------------------------------------------------------*/
 if (strcmp(CURRENT_FILE->fname,dirfilename) == 0)
    wmove(CURRENT_WINDOW_MAIN,CURRENT_VIEW->current_row,file_start-1);
 else
    wmove(CURRENT_WINDOW_MAIN,CURRENT_VIEW->current_row,0);

 touchwin(CURRENT_WINDOW_ARROW);
 wnoutrefresh(CURRENT_WINDOW_ARROW);
 wmove(CURRENT_WINDOW_COMMAND,0,0);
 wnoutrefresh(CURRENT_WINDOW_COMMAND);
 if (file_disposition != FILE_NORMAL)
   {
    switch(file_disposition)
      {
       case FILE_NEW:
                          display_error(0,(char *)"New File...");
                          break;
       case FILE_READONLY:
                          display_error(0,(char *)"File is read-only...");
                          break;
       default:
                          break;
      }
    touchwin(error_window);
    wnoutrefresh(error_window);
    wrefresh(CURRENT_WINDOW);
   }
/*---------------------------------------------------------------------*/
/* The following line has been added to fix an inconsistancy in the AIX*/
/* version of curses. Without this the screen would be erased by the   */
/* doupdate().                                                         */
/*---------------------------------------------------------------------*/
 clearok(stdscr,FALSE);

 doupdate();

 while (1)
  {
   key = my_getch(CURRENT_WINDOW);
   if (error_on_screen)
      {
       error_on_screen = FALSE;
       touchwin(foot);
      }
   rc = function_key(key);
   if (number_of_files == 0)
       break;
   if (rc >= RAW_KEY)
     {
      if (rc > RAW_KEY)
        key = rc - (RAW_KEY*2);
      if (key < 256 && key >= 0)
        {
         string_key[0] = (char)key;
         string_key[1] = '\0';
         (void)Text(string_key);
        }
     }
   if (MARK_VIEW != (VIEW_DETAILS *)NULL
   &&  MARK_VIEW == CURRENT_VIEW)
     {
      getyx(CURRENT_WINDOW_MAIN,y,x);
      show_marked_block();
      wmove(CURRENT_WINDOW_MAIN,y,x);
     }
   wnoutrefresh(CURRENT_WINDOW_MAIN);
   if (CURRENT_VIEW->prefix)
      wnoutrefresh(CURRENT_WINDOW_PREFIX);
   wnoutrefresh(CURRENT_WINDOW_COMMAND);
   show_heading();
   show_footing();

   touchwin(CURRENT_WINDOW_ARROW);
   wnoutrefresh(CURRENT_WINDOW_ARROW);
   wnoutrefresh(CURRENT_WINDOW);
   if (error_on_screen)
     {
      getyx(CURRENT_WINDOW,y,x);
      touchwin(error_window);
      wnoutrefresh(error_window);
      wmove(CURRENT_WINDOW,y,x);
      wnoutrefresh(CURRENT_WINDOW);
     }
   doupdate();
 }
#ifdef TRACE
 trace_return();
#endif
 return;
}
