/***********************************************************************/
/* ERROR.C - Function to display error messages.                       */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1993 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 5314
 * QLD 4121
 * Australia
 */

/*
$Header: C:\THE\RCS\error.c 1.4 1993/09/01 16:26:19 MH Interim MH $
*/

#include <stdio.h>

#include "the.h"
#include "proto.h"

/*-------------------------- global   data ----------------------------*/

char last_message[160]="";  /* contents of last error message */

/*-------------------------- external data ----------------------------*/
extern VIEW_DETAILS *vd_current,*vd_first;
extern char current_file;                   /* pointer to current file */
extern WINDOW *foot,*error_window;
extern bool error_on_screen;
extern char in_profile;    /* indicates if processing profile */
/***********************************************************************/
#ifdef PROTO
void display_error(unsigned short err_num,char *mess)
#else
void display_error(err_num,mess)
unsigned short err_num;
char *mess;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern bool extended_display_mode;
 extern bool BEEPx;
 extern char number_of_files;
/*--------------------------- local data ------------------------------*/

static char *error_message[] =
{
 "",
 "Error 0001: Invalid operand:",
 "Error 0002: Too many operands",
 "Error 0003: Too few operands",
 "Error 0004: Invalid number:",
 "Error 0005: Numeric operand too small",
 "Error 0006: Numeric operand too large",
 "Error 0007: Length of operand > 10",
 "Error 0008: Invalid or protected file",
 "Error 0009: File not found",
 "Error 0010: Path not found",
 "Error 0011: File not found in THE_MACRO_PATH:",
 "Error 0012: Margins settings are inconsistant",
 "Error 0013: Invalid key name:",
 "Error 0014: ",
 "Error 0015: ",
 "Error 0016: ",
 "Error 0017: Target not found",
 "Error 0018: Invalid line name",
 "Error 0019: ",
 "Error 0020: ",
 "Error 0021: Invalid command:",
 "Error 0022: File has been changed - use QQUIT to really quit",
 "Error 0023: Help file not found:",
 "Error 0024: Invalid profile command:",
 "Error 0025: Error accessing REXX variable",
 "Error 0026: ",
 "Error 0027: ",
 "Error 0028: ",
 "Error 0029: Cannot edit -",
 "Error 0030: Memory shortage",
 "Error 0031: File already exists - use FFILE/SSAVE",
 "Error 0032: Invalid hexadecimal or decimal value",
 "Error 0033: ",
 "Error 0034: ",
 "Error 0035: ",
 "Error 0036: No lines changed",
 "Error 0037: Operand too long:",
 "Error 0038: Improper cursor position",
 "Error 0039: No remembered operand available",
 "Error 0040: /bin/sh cannot suspend this process",
 "Error 0041: Invalid SOS command:",
 "Error 0042: Invalid SET command:",
 "Error 0043: ",
 "Error 0044: No marked block",
 "Error 0045: Marked block not in current file",
 "Error 0046: ",
 "Error 0047: Operation invalid for line blocks",
 "Error 0048: Operation invalid for box blocks",
 "Error 0049: ",
 "Error 0050: Invalid move location",
 "Error 0051: ",
 "Error 0052: ",
 "Error 0053: Valid only when issued from a REXX macro",
 "Error 0054: REXX interpreter returned an error",
 "Error 0055: No lines sorted",
 "Error 0056: ",
 "Error 0057: Disk full error",
 "Error 0058: ",
 "Error 0059: ",
 "Error 0060: Line name not found:",
 "Error 0061: Colour support not available:",
 "Error 0062: ",
 "Error 0063: ",
 "Error 0064: ",
 "Error 0065: ",
 "Error 0066: Invalid match position",
 "Error 0067: Invalid match character",
 "Error 0068: Matching character not found",
 "Error 0069: Invalid character"
};
unsigned short error_location;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("error.c:   display_error");
#endif
 sprintf(last_message,"%s %s",error_message[err_num],mess);
 if (in_profile)
   {
    if (!error_on_screen)
      {
       if (number_of_files == 0)
          fprintf(stderr,"*** Messages from profile file  ***\n");
       else
          fprintf(stderr,"*** Messages from profile file for %s%s ***\n",
                         CURRENT_FILE->fpath,CURRENT_FILE->fname);
      }
    error_on_screen = TRUE;
    fprintf(stderr,"%s\n",last_message);
#ifdef TRACE
    trace_return();
#endif
    return;
   }
/*---------------------------------------------------------------------*/
/* If msgmode is off, don't display any errors.                        */
/*---------------------------------------------------------------------*/
 if (!CURRENT_VIEW->message_mode)
    return;

 error_on_screen = TRUE;
 wmove(error_window,0,0);
 my_wclrtoeol(error_window);
 if (extended_display_mode)
    mvwaddstr(error_window,0,0,last_message);
 else
    put_string(error_window,0,0,last_message,strlen(last_message));
#if !defined(BSD)
 if (BEEPx)
    beep();
#endif
 wnoutrefresh(error_window);
#ifdef TRACE
 trace_return();
#endif
 return;
}
