/***********************************************************************/
/* EXTCURS.C -                                                         */
/* This file contains pseudo SystemV functions that are missing in AIX */
/* Extended Curses.                                                    */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1993 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 5314
 * QLD 4121
 * Australia
 */

/*
$Header: C:\THE\RCS\extcurs.c 1.4 1993/09/01 16:25:31 MH Interim MH $
*/

#include "the.h"

chtype color_pair[COLOR_PAIRS];
static chtype fore_color[8];
static chtype back_color[8];
extern VIEW_DETAILS *vd_current,*vd_first,*vd_mark;
/***********************************************************************/
#ifdef PROTO
int has_colors(void)
#else
int has_colors()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
 return(TRUE);
}
/***********************************************************************/
#ifdef PROTO
int start_color(void)
#else
int start_color()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 register int i;
/*--------------------------- processing ------------------------------*/
 for (i=0;i<COLOR_PAIRS;i++)
   color_pair[i] = NORMAL;
 fore_color[COLOR_BLACK  ] = F_BLACK  ;
 fore_color[COLOR_BLUE   ] = F_BLUE   ;
 fore_color[COLOR_GREEN  ] = F_GREEN  ;
 fore_color[COLOR_CYAN   ] = F_CYAN   ;
 fore_color[COLOR_RED    ] = F_RED    ;
 fore_color[COLOR_MAGENTA] = F_MAGENTA;
 fore_color[COLOR_YELLOW ] = F_BROWN  ;
 fore_color[COLOR_WHITE  ] = F_WHITE  ;
 back_color[COLOR_BLACK  ] = B_BLACK  ;
 back_color[COLOR_BLUE   ] = B_BLUE   ;
 back_color[COLOR_GREEN  ] = B_GREEN  ;
 back_color[COLOR_CYAN   ] = B_CYAN   ;
 back_color[COLOR_RED    ] = B_RED    ;
 back_color[COLOR_MAGENTA] = B_MAGENTA;
 back_color[COLOR_YELLOW ] = B_BROWN  ;
 back_color[COLOR_WHITE  ] = B_WHITE  ;
 return(0);
}
/***********************************************************************/
#ifdef PROTO
int init_pair(int pairnum,chtype fore,chtype back)
#else
int init_pair(pairnum,fore,back)
int pairnum;
chtype fore,back;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 register int i;
/*--------------------------- processing ------------------------------*/
 color_pair[pairnum] = fore_color[fore] | back_color[back];
 return(0);
}
/***********************************************************************/
#ifdef PROTO
int doupdate(void)
#else
int doupdate()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 short y,x;
/*--------------------------- processing ------------------------------*/
 getyx(CURRENT_WINDOW,y,x);
 wrefresh(CURRENT_WINDOW);
 refresh();
 wmove(CURRENT_WINDOW,y,x);
 return(0);
}
