/***********************************************************************/
/* SHOW.C - Functions involving displaying the data.                   */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1993 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 5314
 * QLD 4121
 * Australia
 */

/*
$Header: C:\THE\RCS\show.c 1.4 1993/09/01 16:27:15 MH Interim MH $
*/

#include <stdio.h>
#include <time.h>

#include "the.h"
#include "proto.h"

/*#define TRACEE*/
/*-------------------------- external data ----------------------------*/
extern LINE *next_line,*curr_line;
extern VIEW_DETAILS *vd_current,*vd_first,*vd_mark;
extern char current_screen;
extern SCREEN_DETAILS screen[MAX_SCREENS];        /* screen structures */
extern char current_file;         /* pointer to current file */
extern char number_of_views;                        /* number of views */
extern char number_of_files;                   /* number of open files */
extern char display_screens;                      /* number of screens */
extern bool horizontal;
extern WINDOW *foot,*error_window;
extern bool error_on_screen;
extern char mode_insert;        /* defines insert mode toggle */
extern char in_profile;    /* indicates if processing profile */
extern char file_disposition;
/*------------------------ function definitions -----------------------*/
#ifdef PROTO
static void show_line(int direction,LINE *curr,
                         short rows,short start_row);
#else
static void show_line();
#endif
/***********************************************************************/
#ifdef PROTO
void show_heading(void)
#else
void show_heading()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 short y,x,fpath_len,fname_len,max_name;
 char buffer[60];
 char display_path[MAX_FILE_NAME+1];
 char *fpath = display_path;
 register int i;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("show.c:    show_heading");
#endif
/*---------------------------------------------------------------------*/
/* Reset idline to blank.                                              */
/*---------------------------------------------------------------------*/
 wmove(CURRENT_WINDOW_IDLINE,0,0);
 my_wclrtoeol(CURRENT_WINDOW_IDLINE);
/*---------------------------------------------------------------------*/
/* Calculate line,col values.                                          */
/*---------------------------------------------------------------------*/
 getyx(CURRENT_WINDOW,y,x);
 if (CURRENT_VIEW->current_window == WINDOW_COMMAND)
   {
    y = (short)CURRENT_VIEW->current_line;
    x++;
   }
 else
   {
    y = (short)CURRENT_VIEW->focus_line;
    x += CURRENT_VIEW->verify_col;
   }
/*---------------------------------------------------------------------*/
/* Set up buffer for line,col,size and alt values for vertical screens.*/
/*---------------------------------------------------------------------*/
 if (display_screens != 1 && !horizontal)
   {
    sprintf(buffer,"L=%-.1d C=%-.1d S=%-.1d A=%d,%d",
                    y,x,
                    CURRENT_FILE->number_lines,
                    CURRENT_FILE->autosave_alt,
                    CURRENT_FILE->save_alt);
    max_name = (CURRENT_SCREEN.screen_cols-1) - strlen(buffer);
   }
 else
    max_name = (CURRENT_SCREEN.screen_cols-48);
/*---------------------------------------------------------------------*/
/* Determine which portion of filename can be displayed.               */
/*---------------------------------------------------------------------*/
 strcpy(display_path,CURRENT_FILE->fpath);
 fpath = strtrans(display_path,ISLASH,ESLASH);
 fpath_len = strlen(fpath);
 fname_len = strlen(CURRENT_FILE->fname);
 if (fpath_len + fname_len > max_name)
   {
    fpath_len = (fpath_len + fname_len + 3) - max_name;
    wmove(CURRENT_WINDOW_IDLINE,0,0);
    wprintw(CURRENT_WINDOW_IDLINE,"...%s%s",fpath+fpath_len,CURRENT_FILE->fname);
   }
 else
  {
   wmove(CURRENT_WINDOW_IDLINE,0,0);
   wprintw(CURRENT_WINDOW_IDLINE,"%s%s",fpath,CURRENT_FILE->fname);
  }
 if (display_screens != 1 && !horizontal)
   {
    wmove(CURRENT_WINDOW_IDLINE,0,max_name+1);
    wprintw(CURRENT_WINDOW_IDLINE,"%-s",buffer);
   }
 else
   {
/*  wmove(CURRENT_WINDOW_IDLINE,0,34);*/
    wmove(CURRENT_WINDOW_IDLINE,0,CURRENT_SCREEN.screen_cols-46);
    wprintw(CURRENT_WINDOW_IDLINE,"Line=%-6.1d Col=%-5.1d",y,x);
/*  wmove(CURRENT_WINDOW_IDLINE,0,54);*/
    wmove(CURRENT_WINDOW_IDLINE,0,CURRENT_SCREEN.screen_cols-46+20);
    wprintw(CURRENT_WINDOW_IDLINE,"Size=%-6.1d",CURRENT_FILE->number_lines);
/*  wmove(CURRENT_WINDOW_IDLINE,0,66);*/
    wmove(CURRENT_WINDOW_IDLINE,0,CURRENT_SCREEN.screen_cols-46+32);
    wprintw(CURRENT_WINDOW_IDLINE,"Alt=          ");
/*  wmove(CURRENT_WINDOW_IDLINE,0,70);*/
    wmove(CURRENT_WINDOW_IDLINE,0,CURRENT_SCREEN.screen_cols-46+36);
    wprintw(CURRENT_WINDOW_IDLINE,"%d,%d",CURRENT_FILE->autosave_alt,
                             CURRENT_FILE->save_alt);
   }
 wnoutrefresh(CURRENT_WINDOW_IDLINE);
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
void show_footing(void)
#else
void show_footing()
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern char *rec;
 extern char *cmd_rec;
 extern char *pre_rec;
 extern bool extended_display_mode;
 extern bool colour_support;
 extern char pending_prefix_command[PREFIX_WIDTH+1];
 extern char *the_version;
 extern bool CLOCKx;
 extern bool HEXDISPLAYx;
/*--------------------------- local data ------------------------------*/
 short y,x;
 int key;
 WINDOW *w;
 time_t timer;
 struct tm *tblock;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("show.c:    show_footing");
#endif
 w = CURRENT_WINDOW;
/*---------------------------------------------------------------------*/
/* Display THE version.                                                */
/*---------------------------------------------------------------------*/
 mvwaddstr(foot,0,0,"THE");
 mvwaddstr(foot,0,4,the_version);
/*---------------------------------------------------------------------*/
/* Display number of files.                                            */
/*---------------------------------------------------------------------*/
 wmove(foot,0,11);
 wprintw(foot,"Files=%d ",number_of_files);
/*---------------------------------------------------------------------*/
/* Display any pending prefix command warning                          */
/*---------------------------------------------------------------------*/
 wmove(foot,0,20);
 if (strcmp(pending_prefix_command,""))
    wprintw(foot,"'%s' pending...",pending_prefix_command);
 else
    wprintw(foot,"                 ");
/*---------------------------------------------------------------------*/
/* Display CLOCK.                                                      */
/*---------------------------------------------------------------------*/
 if (CLOCKx)
   {
    timer = time(NULL);
    tblock = localtime(&timer);
    wmove(foot,0,53);
   
    wprintw(foot,"%2d:%02.2d%s",
           (tblock->tm_hour > 12) ? (tblock->tm_hour-12) : (tblock->tm_hour),
            tblock->tm_min,
           (tblock->tm_hour >= 12) ? ("pm") : ("am"));
   }
/*---------------------------------------------------------------------*/
/* Display HEXDISPLAY.                                                 */
/*---------------------------------------------------------------------*/
 if (HEXDISPLAYx)
   {
    getyx(CURRENT_WINDOW,y,x);
    switch(CURRENT_VIEW->current_window)
      {
       case WINDOW_MAIN:
            key = (int)(*(rec+CURRENT_VIEW->verify_col-1+x) & A_CHARTEXT);
            break;
       case WINDOW_COMMAND:
            key = (int)(*(cmd_rec+x) & A_CHARTEXT);
            break;
       case WINDOW_PREFIX:
            key = (int)(*(pre_rec+x) & A_CHARTEXT);
            break;
      }
    wmove(foot,0,61);
    if (key == '\0')
       wprintw(foot,"' '=00/000 ");
    else
      {
       if (extended_display_mode)
          wprintw(foot,"'%1.1c'=%2.2X/%3.3d ",key,key,key);
       else
#ifdef USE_EXTCURSES
          wprintw(foot,"'%1.1c'=%2.2X/%3.3d ",key,key,key);
#else
          wprintw(foot,"'%s'=%2.2X/%3.3d ",(key >127) ? " " : unctrl(key),key,key);
#endif
      }
   }
/*---------------------------------------------------------------------*/
/* Display colour setting.                                             */
/*---------------------------------------------------------------------*/
 wmove(foot,0,73);
#ifdef A_COLOR
 if (colour_support)
    waddch(foot,'C');
 else
    waddch(foot,'c');
#else
 waddch(foot,'M');
#endif
/*---------------------------------------------------------------------*/
/* Display REXX support character.                                     */
/*---------------------------------------------------------------------*/
 wmove(foot,0,74);
#if defined(NOREXX)
 waddch(foot,' ');
#else
 waddch(foot,'R');
#endif
/*---------------------------------------------------------------------*/
/* Display INSERTMODE toggle.                                          */
/*---------------------------------------------------------------------*/
 wmove(foot,0,76);
 if (mode_insert)
    waddstr(foot,"Ins");
 else
    waddstr(foot,"   ");
/*---------------------------------------------------------------------*/
/* Refresh the STATUS LINE.                                            */
/*---------------------------------------------------------------------*/
 wnoutrefresh(foot);
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
void clear_footing(void)
#else
void clear_footing()
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("show.c:    clear_footing");
#endif
 wmove(foot,0,0);
 my_wclrtoeol(foot);
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
void show_page(void)
#else
void show_page()
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
extern char in_macro;
/*--------------------------- local data ------------------------------*/
 register int i,row;
 LINE *curr,*save_curr;
 short crow = CURRENT_VIEW->current_row;
 unsigned long cline = CURRENT_VIEW->current_line;
 unsigned short x,y;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("show.c:    show_page");
#endif
 if (in_profile || in_macro)
   {
#ifdef TRACE
    trace_return();
#endif
    return;
   }
/*---------------------------------------------------------------------*/
/* First thing, turn off the cursor.                                   */
/*---------------------------------------------------------------------*/
 draw_cursor(OFF);

#ifdef USE_VOID
 save_curr = curr = (LINE *)ll_find((void *)CURRENT_FILE->first_line,cline);
#else
 save_curr = curr = lll_find(CURRENT_FILE->first_line,cline);
#endif
 if (curr->display < CURRENT_VIEW->display_low
 &&  curr->display > CURRENT_VIEW->display_high)
   {
    save_curr = curr = CURRENT_FILE->first_line;
    CURRENT_VIEW->current_line = 0L;
   }

 getyx(CURRENT_WINDOW,y,x);
/*---------------------------------------------------------------------*/
/* Display the file contents from the current line to the bottom of the*/
/* window.                                                             */
/*---------------------------------------------------------------------*/
 show_line(DIRECTION_FORWARD,curr,CURRENT_SCREEN.rows-crow,crow);
/*---------------------------------------------------------------------*/
/* Display the file contents from the current line to the top of the   */
/* window.                                                             */
/*---------------------------------------------------------------------*/
 curr = save_curr->prev;
 show_line(DIRECTION_BACKWARD,curr,crow,crow-1);
/*---------------------------------------------------------------------*/
/* Highlight the current line. If the current line is inside the marked*/
/* LINE block, use a different colour. If the current line is the top  */
/* or bottom lines, use another colour again.                          */
/*---------------------------------------------------------------------*/
 if (CURRENT_VIEW->current_line == 0L
 ||  CURRENT_VIEW->current_line == CURRENT_FILE->number_lines + 1L)
    highlight_line(CURRENT_VIEW->current_row,colour[ATTR_CTOFEOF],colour[ATTR_CTOFEOF]);
 else
    highlight_line(CURRENT_VIEW->current_row,colour[ATTR_CURLINE],colour[ATTR_CURLINE]);
/*---------------------------------------------------------------------*/
/* Display any lines in the marked block if any.                       */
/*---------------------------------------------------------------------*/
 if (MARK_VIEW != (VIEW_DETAILS *)NULL
 &&  MARK_VIEW == CURRENT_VIEW)
    show_marked_block();

 if (CURRENT_VIEW->prefix)
     wnoutrefresh(CURRENT_WINDOW_PREFIX);
 wrefresh(CURRENT_WINDOW_MAIN);

/*---------------------------------------------------------------------*/
/* Lastly, turn the cursor back on again.                              */
/*---------------------------------------------------------------------*/
 draw_cursor(ON);

 wmove(CURRENT_WINDOW,y,x);
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
static void show_line(int direction,LINE *curr,
                         short rows,short start_row)
#else
static void show_line(direction,curr,rows,start_row)
int direction;
LINE *curr;
short rows,start_row;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
 extern char *rec;
 extern unsigned short rec_len;
 extern bool extended_display_mode;
/*--------------------------- local data ------------------------------*/
 long cline = CURRENT_VIEW->current_line;
 short y;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("show.c:    show_line");
#endif
/*---------------------------------------------------------------------*/
/* Determine the row that is the focus line.                           */
/*---------------------------------------------------------------------*/
 if (direction == DIRECTION_BACKWARD)
    cline--;
 y = get_row_for_focus_line(CURRENT_VIEW->current_row,
                            CURRENT_VIEW->focus_line,
                            CURRENT_VIEW->current_line);

 while(rows)
   {
    if (curr == NULL)
      {
       wmove(CURRENT_WINDOW_MAIN,start_row,0);
       my_wclrtoeol(CURRENT_WINDOW_MAIN);
       if (CURRENT_VIEW->prefix) /* display prefix if on */
         {
          wattrset(CURRENT_WINDOW_PREFIX,colour[ATTR_PREFIX]);
          wmove(CURRENT_WINDOW_PREFIX,start_row,0);
          my_wclrtoeol(CURRENT_WINDOW_PREFIX);
          wattrset(CURRENT_WINDOW_PREFIX,colour[ATTR_PENDING]);
         }
       start_row += direction;
       rows--;
      }
    else
      {
       if (curr->next == NULL      /* Bottom of file */
       ||  curr->prev == NULL      /* Top of file */
       || (curr->display >= CURRENT_VIEW->display_low
          &&  curr->display <= CURRENT_VIEW->display_high))
         {
/*---------------------------------------------------------------------*/
/* If the current row to be displayed is the focus line, display       */
/* the working area, rec and rec_len instead of the entry in the LL.   */
/*---------------------------------------------------------------------*/
          if (start_row == y)
             show_one_row(rec,rec_len,start_row,curr);
          else
             show_one_row(curr->line,curr->length,start_row,curr);
/*---------------------------------------------------------------------*/
/* If the prefix area is ON display it.                                */
/*---------------------------------------------------------------------*/
          if (CURRENT_VIEW->prefix)
            {
             wmove(CURRENT_WINDOW_PREFIX,start_row,0);
             my_wclrtoeol(CURRENT_WINDOW_PREFIX);
             if (curr->pre != (-1))          /* prefix command pending */
               {
                if (extended_display_mode)
                   waddstr(CURRENT_WINDOW_PREFIX,CURRENT_VIEW->ppc[curr->pre].ppc_command);
                else
                   put_string(CURRENT_WINDOW_PREFIX,start_row,0,
                              CURRENT_VIEW->ppc[curr->pre].ppc_command,
                              strlen(CURRENT_VIEW->ppc[curr->pre].ppc_command));
               }
             else                    /* no prefix command on this line */
               {
                wattrset(CURRENT_WINDOW_PREFIX,colour[ATTR_PREFIX]);
                if (CURRENT_VIEW->number)
                   wprintw(CURRENT_WINDOW_PREFIX,"%6.6d",cline);
                else
                   waddstr(CURRENT_WINDOW_PREFIX,"======");
               }
             wattrset(CURRENT_WINDOW_PREFIX,colour[ATTR_PENDING]);
            }
          start_row += direction;
          rows--;
         }
        cline += (long)direction;
        if (direction == DIRECTION_FORWARD)
           curr = curr->next;
        else
           curr = curr->prev;
       }
   }
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
void show_one_row(char *line,unsigned short length,
                  unsigned short row,LINE *curr)
#else
void show_one_row(line,length,row,curr)
char *line;
unsigned short length,row;
LINE *curr;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern bool extended_display_mode;
/*--------------------------- local data ------------------------------*/
 short col1,col2;
 register int i;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("show.c:    show_one_row");
#endif
 col1 = CURRENT_VIEW->verify_col - 1;
 col2 = min(length-1,CURRENT_VIEW->verify_end-1);
/*---------------------------------------------------------------------*/
/* If we are displaying the top or bottom line marker, then force the  */
/* function to display the beginning of the line and to display the    */
/* whole line when VERIFY is in effect.                                */
/*---------------------------------------------------------------------*/
 if (curr->prev == NULL || curr->next == NULL)
   {
    col1 = 0;
    col2 = curr->length-1;
    wattrset(CURRENT_WINDOW_MAIN,colour[ATTR_TOFEOF]);
   }
/*---------------------------------------------------------------------*/
/* If the first column to be displayed is after the length of the line */
/* then just clear to end of line and exit.                            */
/*---------------------------------------------------------------------*/
 if (col1 >= length)
   {
     wmove(CURRENT_WINDOW_MAIN,row,0);
     my_wclrtoeol(CURRENT_WINDOW_MAIN);
     wattrset(CURRENT_WINDOW_MAIN,colour[ATTR_FILEAREA]);
#ifdef TRACE
     trace_return();
#endif
     return;
   }
 for (i=0;i<CURRENT_SCREEN.cols;i++)
     {
      if (i+col1 > col2)
        {
         wmove(CURRENT_WINDOW_MAIN,row,i);
         my_wclrtoeol(CURRENT_WINDOW_MAIN);
         break;
        }
      else
        {
         wmove(CURRENT_WINDOW_MAIN,row,i);
         if (extended_display_mode)
            waddch(CURRENT_WINDOW_MAIN,*(line+i+col1));
         else
            put_char(CURRENT_WINDOW_MAIN,*(line+i+col1),ADDCHAR);
        }
     }
 wattrset(CURRENT_WINDOW_MAIN,colour[ATTR_FILEAREA]);
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
void highlight_line(char line,chtype normal,chtype block)
#else
void highlight_line(line,normal,block)
char line;
chtype normal;
chtype block;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern bool extended_display_mode;
/*--------------------------- local data ------------------------------*/
 register int i;
 WINDOW *w;
 chtype ch;
 short real_col;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("show.c:    highlight_line");
#endif
 for (i=0;i<CURRENT_SCREEN.cols;i++)
    {
     w = CURRENT_WINDOW_MAIN;
     real_col = i + CURRENT_VIEW->verify_col;
     wmove(CURRENT_WINDOW_MAIN,line,i);
     ch = winch(w) & A_CHARTEXT;
     if ((real_col >= CURRENT_VIEW->mark_start_col && real_col <= CURRENT_VIEW->mark_end_col)
     ||  (CURRENT_VIEW->mark_start_col == (-1) && CURRENT_VIEW->mark_end_col == (-1)))
       {
        if (extended_display_mode)
           waddch(CURRENT_WINDOW_MAIN,ch | block);
        else
           put_char(CURRENT_WINDOW_MAIN,ch | block,ADDCHAR);
       }
     else
       {
        if (extended_display_mode)
           waddch(CURRENT_WINDOW_MAIN,ch | normal);
        else
           put_char(CURRENT_WINDOW_MAIN,ch | normal,ADDCHAR);
       }
    }
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
void show_marked_block(void)
#else
void show_marked_block()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 register int i;
 short num_rows,top_row;
 long top_line,bottom_line,temp;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("show.c:    show_marked_block");
#endif
 top_line = max(CURRENT_VIEW->mark_start_line,
                CURRENT_VIEW->current_line-(long)CURRENT_VIEW->current_row);
 temp = CURRENT_VIEW->current_line-(long)CURRENT_VIEW->current_row+(long)CURRENT_SCREEN.rows;
 if (top_line >= CURRENT_VIEW->current_line-(long)CURRENT_VIEW->current_row+(long)CURRENT_SCREEN.rows)
   {
#ifdef TRACE
    trace_return();
#endif
    return;
   }

 bottom_line = min(CURRENT_VIEW->mark_end_line,
                   CURRENT_VIEW->current_line-(long)CURRENT_VIEW->current_row+(long)CURRENT_SCREEN.rows);
 top_row = get_row_for_focus_line(CURRENT_VIEW->current_row,
                                  top_line,
                                  CURRENT_VIEW->current_line);
 num_rows = (short)(bottom_line - top_line + 1);
 for (i=0;i<num_rows;i++)
    {
     if (CURRENT_VIEW->current_row == i+top_row)
        highlight_line((char)(i+top_row),colour[ATTR_CURLINE],colour[ATTR_CBLOCK]);
     else
        highlight_line((char)(i+top_row),colour[ATTR_FILEAREA],colour[ATTR_BLOCK]);
    }
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
void redraw_window(WINDOW *win)
#else
void redraw_window(win)
WINDOW *win;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern bool extended_display_mode;
/*--------------------------- local data ------------------------------*/
 register int i,j;
 int key;
 short y,x;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("show.c:    redraw_window");
#endif
 getyx(win,y,x);
 for (i=0;i<getmaxx(win);i++)
     for (j=0;j<getmaxy(win);j++)
        {
         wmove(win,j,i);
         key = (int)(winch(win) & A_CHARTEXT);
         if (extended_display_mode)
            waddch(win,key);
         else
            put_char(win,key,ADDCHAR);
        }
 wmove(win,y,x);
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
void repaint_screen(void)
#else
void repaint_screen()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 short y,x;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("show.c:    repaint_screen");
#endif

 getyx(CURRENT_WINDOW,y,x);
 y = get_row_for_focus_line(CURRENT_VIEW->current_row,
                            CURRENT_VIEW->focus_line,
                            CURRENT_VIEW->current_line);
 if (x > CURRENT_SCREEN.cols)
    x = 0;
 pre_process_line(CURRENT_VIEW->focus_line);
 show_page();
 cleanup_command_line();
 show_heading();
 wmove(CURRENT_WINDOW,y,x);

#ifdef TRACE
 trace_return();
#endif
 return;
}
