(define disp-index 0)
(define scrn-index 1)
(define root-index 2)
(define bpix-index 3)
(define wpix-index 4)
(define conn-index 5)

;;; Hello, World example from Oliver Jones' book in Gambit Scheme.

(define (hello-world)
    (let* ((hello "Hello, World")
	   (hi "Hi!")
	   (win-vect (make-unscanned-vector 1))
	   (dpy-vector (let ((v (make-unscanned-vector 6)))
			 (x-open-display "" v)
			 (x-default-screen v)
			 (x-black-pixel v)
			 (x-white-pixel v)
			 (x-default-root-window v)
			 (x-create-simple-window
			  v		; Display vector.
			  v root-index	; Root window vector and index.
			  200 300	; X and Y
			  350 250	; Width and height
			  5		; Border width
			  v bpix-index	; Foreground pixel (black) and index.
			  v wpix-index  ; Background pixel (white) and index.
			  win-vect 0)	; New window vector and index.
			 v))
	   (regionv (let ((v (make-unscanned-vector 1)))
		      (x-create-region v 0)
		      (x-union-rect-with-region v 0
						 40 40 50 50)
		      v))
	   (gcvalues-vect (let ((v (make-unscanned-vector 1)))
			    (make-x-gc-values v 0)
			    v))
	   (gc (let ((v (make-unscanned-vector 1)))
		 (x-create-gc dpy-vector
			      win-vect 0
			      gcvalues-vect 0
			      0		; Mask.
			      v 0)
		 (x-set-region dpy-vector
			       v 0
			       regionv 0)
		 v))
	   (event (let ((v (make-unscanned-vector 1)))
		    (make-x-event v 0)
		    v)))

      ;;................

      (x-store-name dpy-vector 
		    win-vect 0
		    "Hello, World in Gambit Scheme using X11's Xlib.")
      (x-set-icon-name dpy-vector
		       win-vect 0
		       "Hello/Gambit")
      (x-set-background dpy-vector
			gc 0
			dpy-vector wpix-index)
      (x-set-foreground dpy-vector
			gc 0
			dpy-vector bpix-index)
      (x-select-input dpy-vector
		      win-vect 0
		      (+ x-button-press-mask
			 x-key-press-mask
			 x-exposure-mask))
      (x-map-raised dpy-vector win-vect 0)

      ;; ................ EVENT LOOP ................

      (let event-loop ()
	(x-next-event dpy-vector
		      event 0)
	(let ((type (x-event-type event 0)))
	  (cond ((eq? type x-expose)
		 (x-draw-image-string dpy-vector
				      win-vect 0
				      gc 0
				      50 50
				      hello
				      0 (string-length hello))
		 (event-loop))

		;;................

		((eq? type x-mapping-notify)
		 (x-refresh-keyboard-mapping event 0)
		 (event-loop))

		;;................

		((eq? type x-button-press)

		 (x-draw-rectangle dpy-vector
				   win-vect 0
				   gc 0
				   (x-button-event-x event 0)
				   (x-button-event-y event 0)
				   50 50)
		 (x-draw-line dpy-vector
			      win-vect 0
			      gc 0
			      (x-button-event-x event 0)
			      (x-button-event-y event 0)
			      50 50)

;		 (x-draw-image-string dpy-vector
;				      win-vect 0
;				      gc 0
;				      (x-button-event-x event 0)
;				      (x-button-event-y event 0)
;				      hi
;				      0 (string-length hi))
		 (event-loop))

		;;................

		((eq? type x-key-press)
		 (x-destroy-region regionv 0)
		 (x-free-gc dpy-vector
			    gc 0)
		 (x-destroy-window dpy-vector
				   win-vect 0)
		 (x-close-display dpy-vector))

		;;................

		(else (event-loop)))))))
