(load"x")(load"xlib")(load"xatom") (load"unscanned")

(define (make-window x y w h name icon-name refresh)

  (define disp-index 0)
  (define scrn-index 1)
  (define root-index 2)
  (define bpix-index 3)
  (define wpix-index 4)
  (define conn-index 5)

  (let* ((win-vect (make-unscanned-vector 1))
         (dpy-vector (let ((v (make-unscanned-vector 6)))
		       (x-open-display "" v)
		       (x-default-screen v)
		       (x-black-pixel v)
		       (x-white-pixel v)
		       (x-default-root-window v)
		       (x-create-simple-window
			 v		; Display vector.
			 v root-index	; Root window vector and index.
			 x y		; X and Y
			 w h		; Width and height
			 5		; Border width
			 v bpix-index	; Foreground pixel (black) and index.
			 v wpix-index	; Background pixel (white) and index.
			 win-vect 0)	; New window vector and index.
			 v))
	 (gcvalues-vect (let ((v (make-unscanned-vector 1)))
			  (make-x-gc-values v 0)
			  v))
	 (gc (let ((v (make-unscanned-vector 1)))
	       (x-create-gc dpy-vector
			    win-vect 0
			    gcvalues-vect 0
			    0		; Mask.
			    v 0)
	       v))
	 (event (let ((v (make-unscanned-vector 1)))
		  (make-x-event v 0)
		  v))
	 (line
	  (lambda (x1 y1 x2 y2)
	    (x-draw-line dpy-vector
			 win-vect 0
			 gc 0
			 x1 y1 x2 y2))))

    (x-store-name dpy-vector 
		  win-vect 0
		  name)

    (x-set-icon-name dpy-vector
		     win-vect 0
		     icon-name)
    (x-set-background dpy-vector
		      gc 0
		      dpy-vector wpix-index)
    (x-set-foreground dpy-vector
		      gc 0
		      dpy-vector bpix-index)
    (x-select-input dpy-vector
		    win-vect 0
		    (+ x-key-press-mask
		       x-exposure-mask))
    (x-map-raised dpy-vector win-vect 0)


      (let event-loop ()
	(x-next-event dpy-vector
		      event 0)
	(let ((type (x-event-type event 0)))
	  (cond ((eq? type x-expose)
		 (refresh line)
		 (event-loop))

		((eq? type x-key-press)
		 (x-free-gc dpy-vector
			    gc 0)
		 (x-destroy-window dpy-vector
				   win-vect 0)
		 (x-close-display dpy-vector))

		(else (event-loop)))))

    #f))



(define (sierpinsky n)

  (define h 2)
  (define border 20)
  (define size 512)

  (define (refresh line)

    (define (sierp j)

      (let* ((h (/ (/ size 4) (expt 2 j)))
             (current-x (+ border (* h 2)))
             (current-y (+ border h)))

        (define (draw d l)
          (let ((inc-x (case d ((0 1 7) l) ((3 4 5) (- l)) (else 0)))
                (inc-y (case d ((1 2 3) l) ((5 6 7) (- l)) (else 0))))
            (line current-x current-y
                  (+ current-x inc-x) (- current-y inc-y))
           (set! current-x (+ current-x inc-x))
            (set! current-y (- current-y inc-y))
            #f))

        (define (s k i)
          (if (> k 0)
            (let ((k (- k 1)))
              (s k (modulo i       8)) (draw (modulo (- i 1) 8) h)
              (s k (modulo (+ i 6) 8)) (draw (modulo i       8) (* h 2))
              (s k (modulo (+ i 2) 8)) (draw (modulo (+ i 1) 8) h)
              (s k (modulo i       8)))))

        (define (ss k)
          (s k 0) (draw 7 h)
          (s k 6) (draw 5 h)
          (s k 4) (draw 3 h)
          (s k 2) (draw 1 h))

        (ss j)))

    (let loop ((j 0))
      (if (<= j n)
        (begin
          (sierp j)
          (loop (+ j 1))))))

  (make-window 50 20 (+ size (* border 2)) (+ size (* border 2))
	       (string-append "Sierpinsky of " (number->string n))
               "Sierpinsky"
	       refresh))



(sierpinsky 5)
