#| -*-Scheme-*-

$Header: ttyin.scm,v 14.11 90/11/29 21:42:27 GMT cph Rel $

Copyright (c) 1988, 1990 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

;;;; Console Input Port
;;; package: (runtime console-input)

(declare (usual-integrations))

(define (initialize-package!)
  (set! hook/read-start default/read-start)
  (set! hook/read-finish default/read-finish)
  (set! console-input-port
	(make-input-port `((BUFFER-SIZE ,operation/buffer-size)
			   (BUFFERED-CHARS ,operation/buffered-chars)
			   (CHANNEL ,operation/channel)
			   (CHAR-READY? ,operation/char-ready?)
			   (DISCARD-CHAR ,operation/read-char)
			   (PEEK-CHAR ,operation/peek-char)
			   (PRINT-SELF ,operation/print-self)
			   (READ-CHAR ,operation/read-char)
			   (READ-FINISH! ,operation/read-finish!)
			   (READ-START! ,operation/read-start!)
			   (SET-BUFFER-SIZE ,operation/set-buffer-size))
			 false))
  (reset-console-input)
  (add-event-receiver! event:after-restore reset-console-input)
  (add-event-receiver! event:before-exit save-console-input))

(define-primitives
  (reload-save-string 1)
  (reload-retrieve-string 0))

(define (save-console-input)
  (if (implemented-primitive-procedure? reload-save-string)
      (reload-save-string
       (input-buffer/buffer-contents (input-port/buffer console-input-port)))))

(define (reset-console-input)
  (set-input-port/state!
   console-input-port
   (let ((channel (tty-input-channel)))
     (let ((buffer (make-input-buffer channel buffer-size)))
       (let ((contents
	      (and (implemented-primitive-procedure? reload-retrieve-string)
		   (reload-retrieve-string))))
	 (if contents
	     (input-buffer/set-buffer-contents buffer contents)))
       (make-input-port-state buffer (channel-type=file? channel))))))

(define buffer-size 512)
(define console-input-port)

(define-structure (input-port-state
		   (type vector)
		   (conc-name input-port-state/))
  ;; Buffer must come first, so we can use operations from generic
  ;; input port implementation.
  (buffer false read-only true)
  (echo? false read-only true))

(define-integrable (input-port/buffer port)
  (input-port-state/buffer (input-port/state port)))

(define-integrable (input-port/echo? port)
  (input-port-state/echo? (input-port/state port)))

(define (operation/peek-char port)
  (let ((char (input-buffer/peek-char (input-port/buffer port))))
    (if (eof-object? char)
	(signal-end-of-input))
    char))

(define (operation/read-char port)
  (let ((char (input-buffer/read-char (input-port/buffer port))))
    (if (eof-object? char)
	(signal-end-of-input))
    (if char
	(cond ((input-port/echo? port)
	       (output-port/write-char console-output-port char)
	       (output-port/flush-output console-output-port))
	      (transcript-port
	       (output-port/write-char transcript-port char)
	       (output-port/flush-output transcript-port))))
    char))

(define (signal-end-of-input)
  (write-string "\nEnd of input stream reached" console-output-port)
  (%exit))

(define (operation/print-self state port)
  port
  (unparse-string state "from console"))

(define (operation/read-start! port)
  port
  (hook/read-start))

(define hook/read-start)
(define (default/read-start) false)

(define (operation/read-finish! port)
  (let ((buffer (input-port/buffer port)))
    (let loop ()
      (if (input-buffer/char-ready? buffer 0)
	  (let ((char (input-buffer/peek-char buffer)))
	    (if (char-whitespace? char)
		(begin
		  (operation/read-char port)
		  (loop)))))))
  (hook/read-finish))

(define hook/read-finish)
(define (default/read-finish) false)