#| -*-Scheme-*-

$Id: ffimacro.scm,v 1.2 1993/11/17 22:50:41 adams Exp $

Copyright (c) 1993 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

#|
WINDOWS PROCEDURE TYPE SYSTEM

Each type TYPE has 4 procedures associated with it.  The association is by
the following naming scheme:

  (TYPE:CHECK x)    a predicate.  Returns #t if its argument is acceptable
  (TYPE:CONVERT x)  converts an argument into a form suitable for the foreign
                    function.
  (TYPE:RETURN-CONVERT x)  converts from the C retrun values to a scheme object
  (TYPE:REVERT x xcvt) This is for mirriring changes to variables passed by
                       reference.  X is the original argument, XCVT is the
                       result of (TYPE:CONVERT X) which has already been passed
                       to the foreign function.  The idea is that TYPE:REVERT
                       updates X to reflect the changes in XCVT.

Additionally, there is another derived procedure, (TYPE:CHECK&CONVERT x)
which checks the argument and then does conversion.


DEFINE-WINDOWS-TYPE and DEFINE-SIMILAR-WINDOWS-TYPE macros

(DEFINE-WINDOWS-TYPE <name> <check> <convert> <return> <revert>)

This defines <name> to be a type according to the above scheme.  <name> is a
symbol.  The other components are either functions, or #f for the default
operation (which is do nothing).

Thus we could define the type char as follows:

  (define-windows-type char
     char?          ; <check>
     char->integer  ;
     integer->char  ;
     #f)            ; no reversion


(DEFINE-SIMILAR-WINDOWS-TYPE <name> <model>
        #!optional  <check> <convert> <return> <revert>)

This defines a type as above, but the defaults are taken from the type <model>
rather than defaulting to null operations.


WINDOWS-PROCEDURE macro

(WINDOWS-PROCEDURE (foo (argname type) ...)  module entry-name)
(WINDOWS-PROCEDURE (foo (argname type) ...)  module entry-name WITH-REVERSIONS)
(WINDOWS-PROCEDURE (foo (argname type) ...)  module entry-name EXPAND)
(WINDOWS-PROCEDURE (foo (argname type) ...)  module entry-name <CODE>)

The first form generates a slower but more compact version, based on a generic
n-place higher order procedure parameterized with the check&convert functions.
No reversion code is inserted.  If any of the argument types has a reversion
procedure then the first form should not be used.

The other versions generate faster code by using macro expansion to insert the
type handling functions.  As the type handling functions generated by DEFINE-WINDOWS-TYPE
are declared integrable and are often simple or trivial, this removes the cost of a
general function call to convert each parameter.  EXPAND and WITH-REVERSIONS have the
same effect, but allow the user to `document' the reason for using the expanded form.

The final form also generates an expanded form, and inserts <CODE> after the type
checking but before the type conversion.  This allows extra consistency checks to be
placed, especially checks that several arguments are mutualy consistent (e.g. an index
into a buffer indexes to inside a string that is being used as the buffer).

|#


(let ()

  (define ffi-module-entry-variable  (string->symbol "[ffi entry]"))
  (define ffi-result-variable (string->symbol "[ffi result]"))


  (define (type->checker type)
    (string->symbol (string-append (symbol-name type) ":check")))

  (define (type->converter type)
    (string->symbol (string-append (symbol-name type) ":convert")))

  (define (type->check&converter type)
    (string->symbol (string-append (symbol-name type) ":check&convert")))

  (define (type->return-converter type)
    (string->symbol (string-append (symbol-name type) ":return-convert")))

  (define (type->reverter type)
    (string->symbol (string-append (symbol-name type) ":revert")))


  (define  (expand/windows-procedure args return-type module entry-name
				     . additional-specifications)

    (define (make-converted-name sym)
      (string->symbol (string-append "[converted " (symbol-name sym) "]")))
    
    (define (make-check type arg)
      `(if (not (,(type->checker type) ,arg))
	   (windows-procedure-argument-type-check-error ',type ,arg)))
    
    (define (make-conversion type arg)
      `(,(type->converter type) ,arg))
    
    (define (make-reversion type sym representation)
      `(,(type->reverter type) ,sym ,representation))
    
    (define (make-return-conversion type expr)
      `(,(type->return-converter type) ,expr))

    (if  additional-specifications
	;; expanded version:
	(let* ((procedure-name (car args))
	       (arg-names    (map car (cdr args)))
	       (arg-types    (map cadr (cdr args)))
	       (cvt-names    (map make-converted-name arg-names))
	       (checks       (map make-check arg-types arg-names))
	       (conversions  (map (lambda (cvt-name arg-type arg-name)
				    `(,cvt-name
				      ,(make-conversion arg-type arg-name)))
				  cvt-names arg-types arg-names))
	       (reversions   (map make-reversion arg-types arg-names cvt-names))
	       (additional-checks (if (and (pair? additional-specifications)
					   (symbol? (car additional-specifications)))
				      (cdr additional-specifications)
				      additional-specifications))
	       )

	  `((access parameterize-with-module-entry ())
	     (lambda (,ffi-module-entry-variable)
	       (named-lambda (,procedure-name . ,arg-names)
		 ,@checks
		 ,@additional-checks
		 (let ,conversions
		     (let ((,ffi-result-variable
			    (%call-foreign-function
			     (module-entry/machine-address
			      ,ffi-module-entry-variable)
			      . ,cvt-names)))
		       ,@reversions
		       ,(make-return-conversion return-type
						ffi-result-variable)))))
	     ,module ,entry-name))

	;; closure version:
	(let* ((arg-types     (map cadr (cdr args))))
	  `(make-windows-procedure ,module ,entry-name
	      ,(type->return-converter return-type)
	      ,@(map type->check&converter arg-types)))))


  (define (expand/define-windows-type  name
				       #!optional check convert return revert)
    (let ((check    (if (default-object? check)   #f check))
	  (convert  (if (default-object? convert) #f convert))
	  (return   (if (default-object? return)  #f return))
	  (revert   (if (default-object? revert)  #f revert)))
      (let ((check    (or check   '(lambda (x) x #t)))
	    (convert  (or convert '(lambda (x) x)))
	    (return   (or return  '(lambda (x) x)))
	    (revert   (or revert  '(lambda (x y) x y unspecific))))
	`(begin 
	   (define-integrable (,(type->checker name) x)          (,check x))
	   (define-integrable (,(type->converter name) x)        (,convert x))
	   (define-integrable (,(type->check&converter name) x)
	     (if (,(type->checker name) x)
		 (,(type->converter name) x)
		 (windows-procedure-argument-type-check-error ',name x)))
	   (define-integrable (,(type->return-converter name) x) (,return x))
	   (define-integrable (,(type->reverter name) x y)       (,revert x y))))))


  (define (expand/define-similar-windows-type
	   name model
	   #!optional check convert return revert)
    (let ((check    (if (default-object? check)   #f check))
	  (convert  (if (default-object? convert) #f convert))
	  (return   (if (default-object? return)  #f return))
	  (revert   (if (default-object? revert)  #f revert)))
      ;; eta conversion below are deliberate to persuade integration to chain
      (let ((check    (or check   (type->checker model)))
	    (convert  (or convert (type->converter model)))
	    (return   (or return  (type->return-converter model)))
	    (revert   (or revert  (type->reverter model))))
	`(begin
	   (define-integrable (,(type->checker name) x)          (,check x))
	   (define-integrable (,(type->converter name) x)        (,convert x))
	   (define-integrable (,(type->check&converter name) x)
	     (if (,(type->checker name) x)
		 (,(type->converter name) x)
		 (windows-procedure-argument-type-check-error ',name x)))
	   (define-integrable (,(type->return-converter name) x) (,return x))
	   (define-integrable (,(type->reverter name) x y)       (,revert x y))))))

  (syntax-table-define system-global-syntax-table 'WINDOWS-PROCEDURE
    expand/windows-procedure)

  (syntax-table-define system-global-syntax-table 'DEFINE-WINDOWS-TYPE
    expand/define-windows-type)

  (syntax-table-define system-global-syntax-table 'DEFINE-SIMILAR-WINDOWS-TYPE
    expand/define-similar-windows-type)
)
