(define-syntax (+ . l)
  (case (length l)
    ((0) '0)
    ((1) (car l))
    ((2) `(fx+ ,(car l) ,(cadr l)))
    (else `(fx+ ,(car l) (+ ,@(cdr l))))))

(define-syntax (* . l)
  (case (length l)
    ((0) '1)
    ((1) (car l))
    ((2) `(fx* ,(car l) ,(cadr l)))
    (else `(fx* ,(car l) (* ,@(cdr l))))))

(define-syntax (- . l)
  (case (length l)
    ((1) `(fx- 0 ,(car l)))
    ((2) `(fx- ,(car l) ,(cadr l)))
    (else `(fx- ,(car l) (- ,@(cdr l))))))

(define-syntax (quotient x y)
  `(fx/ ,x ,y))

(define-syntax (remainder x y)
  `(fixnum-remainder ,x ,y))

(define-syntax (=  x y) `(eq? ,x ,y))
(define-syntax (<  x y) `(fx< ,x ,y))
(define-syntax (>  x y) `(fx< ,y ,x))
(define-syntax (<= x y) `(not (fx< ,y ,x)))
(define-syntax (>= x y) `(not (fx< ,x ,y)))
