/* Macintosh specific extensions */

/* This file is intended to be used for the addition of Scheme procedures */
/* to access machine specific features (such as Toolbox routines).        */

#include "os.h"
#include "mem.h"


/*---------------------------------------------------------------------------*/

/* Add a few procedures to do graphics */


void pascal_str( str, pstr ) /* utility to convert to Pascal string */
SCM_obj str;
char *pstr;
{ long i, len = SCM_length( str );
  if (len > 255) len = 255; /* truncate if too long */
  pstr[0] = len;
  for (i=0; i<len; i++) pstr[i+1] = SCM_obj_to_str(str)[i];
}



SCM_obj mac_newwindow( bounds, title, goaway ) /* simplified version of NewWindow */
SCM_obj bounds, title, goaway;
{ WindowPtr w;
  Str255 ptitle;
  pascal_str( title, ptitle );
  w = NewWindow( NULL, SCM_obj_to_str(bounds), ptitle, TRUE,
                 noGrowDocProc, -1L, (goaway != SCM_false), 0L );
  return (long)SCM_int_to_obj((long)w);
  /* Note: The pointer to the window is returned as a fixnum.  This should */
  /* be fine assuming the Mac returns a pointer with the upper 4 bits of   */
  /* the pointer at 0.  This is reasonable but surely not standard.        */
}


SCM_obj mac_disposewindow( w )  /* window pointer is a fixnum */
SCM_obj w;
{ DisposeWindow( (WindowPtr)SCM_obj_to_int(w) );
  return (long)SCM_false;
}


SCM_obj mac_setport( w )  /* window pointer is a fixnum */
SCM_obj w;
{ SetPort( (WindowPtr)SCM_obj_to_int(w) );
  return (long)SCM_false;
}


SCM_obj mac_moveto( h, v )
SCM_obj h, v;
{ MoveTo( (int)SCM_obj_to_int(h), (int)SCM_obj_to_int(v) );
  return (long)SCM_false;
}


SCM_obj mac_move( dh, dv )
SCM_obj dh, dv;
{ Move( (int)SCM_obj_to_int(dh), (int)SCM_obj_to_int(dv) );
  return (long)SCM_false;
}


SCM_obj mac_lineto( h, v )
SCM_obj h, v;
{ LineTo( (int)SCM_obj_to_int(h), (int)SCM_obj_to_int(v) );
  return (long)SCM_false;
}


SCM_obj mac_line( dh, dv )
SCM_obj dh, dv;
{ Line( (int)SCM_obj_to_int(dh), (int)SCM_obj_to_int(dv) );
  return (long)SCM_false;
}


SCM_obj mac_drawchar( ch ) /* ch is a Scheme character (a fixnum will also do!) */
SCM_obj ch;
{ DrawChar( (char)SCM_obj_to_int(ch) );
  return (long)SCM_false;
}


SCM_obj mac_drawstring( s ) /* s is a Scheme string */
SCM_obj s;
{ Str255 str;
  pascal_str( s, str );
  DrawString( str );
  return (long)SCM_false;
}


SCM_obj mac_framerect( r ) /* r is a byte vector created with ##make-vector16 */
SCM_obj r;
{ FrameRect( SCM_obj_to_str(r) );
}


SCM_obj mac_paintrect( r )
SCM_obj r;
{ PaintRect( SCM_obj_to_str(r) );
}


SCM_obj mac_eraserect( r )
SCM_obj r;
{ EraseRect( SCM_obj_to_str(r) );
}


void ext_init()
{ DEFINE_C_PROC(mac_newwindow);
  DEFINE_C_PROC(mac_disposewindow);
  DEFINE_C_PROC(mac_setport);
  DEFINE_C_PROC(mac_moveto);
  DEFINE_C_PROC(mac_move);
  DEFINE_C_PROC(mac_lineto);
  DEFINE_C_PROC(mac_line);
  DEFINE_C_PROC(mac_drawchar);
  DEFINE_C_PROC(mac_drawstring);
  DEFINE_C_PROC(mac_framerect);
  DEFINE_C_PROC(mac_paintrect);
  DEFINE_C_PROC(mac_eraserect);
}


/*---------------------------------------------------------------------------*/
