(##declare
  (extended-bindings)
  (not safe)
  (not autotouch)
  (block)
  (fixnum))

;------------------------------------------------------------------------------

(let ((v ##argv))
  (let ((n (##vector-length v)))
    (if (##fixnum.= n 1)

      (begin
        (##display "Gambit (with X11 support)" ##stdout #f)
        (##newline ##stdout)
        (let ((init (##open-input-file ".init.scm")))
          (if init (begin (##close-port init) (load ".init.scm"))
            (let ((init (##open-input-file "~/.init.scm")))
              (if init (begin (##close-port init) (load "~/.init.scm"))))))
        (##read-eval-print))

      (let loop1 ((i 1))
        (if (##fixnum.< i n)
          (let ((port (##open-input-string (##vector-ref v i))))
            (let loop2 ()
              (let ((expr (##read port)))
                (if (##not (##eof-object? expr))
                  (let ((val (##eval-global expr)))
                    (##write val ##stdout #t)
                    (##newline ##stdout)
                    (loop2)))))
            (##close-port port)
            (loop1 (##fixnum.+ i 1))))))))

;------------------------------------------------------------------------------
