/* filetimes.c  - get file times
 * 24sep
 * 18feb        remove curtime,timestring to minilibz
 * 3dec.  successful sysV port
 */

#include <theusual.h>

#if !Eunix
: error unix version
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>



Ztime_t Zfilemodtime(path)
  char *path;
{
  struct stat buf;
  if (stat(path,&buf) < 0) return 0;
  return( (long)buf.st_mtime );
}


Ztime_t Zfileacctime(path)
  char *path;
{
  struct stat buf;
  if (stat(path,&buf) < 0) return 0;
  return( (Ztime_t)buf.st_atime );
}

proc Zfilesettimes(path, acc,mod)
	char *path;
	Ztime_t acc,mod;
{
	struct timeval tv[2];

	tv[0].tv_sec = acc;
	tv[1].tv_sec = mod;
	tv[0].tv_usec = tv[1].tv_usec = 0;
	if (utimes(path, tv) < 0) {
		fprintf(stderr, "filesettimes: can't set time on %s: ", path);
		perror("");
	}
}


#ifdef TESTIT
main(ac,av)
 int ac;
 char *av[];
{
  Einit();
  printf("%s\n",Ztimestring(Zfilemodtime(av[1])));
  exit(0);
}
#endif

