/* varerrors.c - error routines using varargs/stdarg
 */

#include <theusual.h>

#if Evarargs
# include <varargs.h>
#endif
#if Estdarg
# include <stdarg.h>
#endif


#if (Emac&&Empw)
#define _Zquit_def_ 1
Zquit(int code,char *msg,...)
{
    va_list ap;
	char str[128];

    fflush(stdout);
    va_start(ap,msg);
    vsprintf(str,msg,ap);
    va_end(ap);
    MstdAlert(str);
    exit(code);
}
#endif


#if (Estdarg&&Evprintf && !_Zquit_def_)
#define _Zquit_def_ 1
proc Zquit(int code,char *msg,...)
{
    va_list ap;

    fflush(stdout);
    va_start(ap,msg);
    vfprintf(stderr,msg,ap);
    putc('\n',stderr);
    va_end(ap);
    exit(code);
}
#endif

#if (Evarargs&&Evprintf)
#define _Zquit_def_ 1
Zquit(va_alist)
 va_dcl
{
    va_list ap;
    int code;
    char *format;

	fflush(stdout);
    va_start(ap);
    code = va_arg(ap,int);
    format = va_arg(ap,char *);
    vfprintf(stderr,format,ap);
    putc('\n',stderr);
    va_end(ap);
    exit(code);
}
#endif

#if !_Zquit_def_
Zquit(code,msg)
  int code;
  char *msg;
{
    fflush(stdout);
	fprintf(stderr,"%s\n",msg);
    exit(code);
}
#endif
#undef _Zquit_def_



#if (Estdarg&&Evprintf)
#define _error_def_
proc Zerror(char *msg,...)
{
    va_list ap;

    fflush(stdout);
    va_start(ap,msg);
    vfprintf(stderr,msg,ap);
    putc('\n',stderr);
    va_end(ap);
    exit(1);
}
#endif


#if (Evarargs&&Evprintf)
#define _error_def_
Zerror(va_alist)
 va_dcl
{
    va_list ap;
    
    fflush(stdout);
    va_start(ap);
    vfprintf(stderr,"ERROR: %s\n",ap);
    putc('\n',stderr);
    va_end(ap);
    exit(1);
}
#endif


#ifndef _error_def_
Zerror(msg)
  char *msg;
{
    fflush(stdout);
	fprintf(stderr,"ERROR: %s\n",msg);
    exit(1);
}
#endif
#undef _error_def_




#if (Emac&&Empw)
#define _Zwarning_def_ 1
proc Zwarning(char *msg,...)
{
  va_list ap;
  char str[128],str2[128];
  
  fflush(stdout);
  va_start(ap,msg);
  vsprintf(str,msg,ap);
  sprintf(str2,"Zwarning: %s",str);
  va_end(ap);
  MstdAlert(str2);
}
#endif

#if (Estdarg&&Evprintf && !_Zwarning_def_)
#define _Zwarning_def_ 1
proc Zwarning(char *msg,...)
{
  va_list ap;
  char c;
  
  fflush(stdout);
  va_start(ap,msg);
  fprintf(stderr,"Zwarning: ");
  vfprintf(stderr,msg,ap);
  fprintf(stderr," hit return to continue\n");
  va_end(ap);
  read(0,&c,1);
}
#endif

#if (Evarargs&&Evprintf && !_Zwarning_def_)
#define _Zwarning_def_ 1
proc Zwarning(va_alist)
 va_dcl
{
  va_list ap;
  char c;
  char *msg;
  
  fflush(stdout);
  va_start(ap);
  msg = va_arg(ap,char *);
  fprintf(stderr,"Zwarning: ");
  vfprintf(stderr,msg,ap);
  fprintf(stderr,"hit return to continue\n");
  va_end(ap);
  read(0,&c,1);
}
#endif

#ifndef _Zwarning_def_
proc Zwarning(msg)
  char *msg;
{
  fflush(stdout);
  fprintf(stderr,"Zwarning: %s, hit return to continue\n",msg);
  read(0,&c,1);
}
#endif
#undef _Zwarning_def_

