/* @(#)cont.h	1.4 1/16/90 */

/* execution parameters */
typedef struct contState_s {
    Obj	cvec,		/* codevec */
	*base,		/* stack base */
	parent,		/* parent continuation */
	prim;		/* set to current prim */
    List alist;		/* activation list */
    int size,		/* size of stack */
	argc;		/* argc for prim */
} contState_t;

/* continuation status flags */
#define DUP	BIT(6)	/* continuation has been duplication */

/* continuation instance */
typedef struct contInst_s {
    procInst_t inherit;
    struct contState_s *state;
} contInst_t, *contInst;

extern basicClass_t protoCont;
#define Continuation ((Class)&protoCont)

extern Obj curCont;		/* current continuation */
extern contState_t *ccState;	/* state of current continuation */
extern Mem stateAlloc;		/* continuation state allocator */

#ifdef __STDC__

/* create a new continuation */
extern Obj newCont(F_OBJ alloc, Obj cvec, Obj frame, Obj par);

/* set up a top-level continuation for codeExec()
 *
 * cvec and frame are the codevec and frame to codeExec
 * cb is for a callback to free the continuation in case of
 * and error */
extern void codeBegin(Callback_t *cb, Obj cvec, Obj frame);

/* end the top-level continuation created by codeBegin()
 *
 * cb is the Callback_t of the corresponding codeBegin()
 * The continuation in effect before codeBegin() is restored. */
extern void codeEnd(Callback_t *cb);

/* resume continuation cont */
extern void contResume(Obj cont);

/* start a child continuation of the current continuation
 *
 * the new continuation will initially have the current continuation
 * pushed on its stack */
extern void contStart(void);

/* resume the parent continuation of the current continuation
 *
 * When the current continuation completes the parent continuation is
 * resumed with the result of the current continuation.
 * If the current continuation is a top-level continuation, then
 * its result is returned. */
extern Obj contContinue(void);

/* display the stacks of the current continuation and its parents */
extern void stackDump();

#else

extern Obj newCont();
extern void codeBegin();
extern void codeEnd();
extern void contResume();
extern void contStart();
extern Obj contContinue();
extern void stackDump();

#endif /* __STDC__ */
