/* global objects */

/*
 * Copyright 1989 Jonathan Lee.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */

#include "fools.h"

#ifndef lint
static char SccsId[] = "@(#)globals.c	1.11 2/12/90";
#endif

/* keywords and other miscellaneous symbols */
Obj QuoteSymb, QuasiSymb, UnquoteSymb, SpliceSymb, ListSymb,
    AppendSymb, LambdaSymb, TheEnvSymb, DefineSymb, SeqSymb,
    EvalSymb, VectorSymb, ApplySymb, ListStarSymb;

/* unique objects */
Obj NilSymb, TrueSymb, FalseSymb, EOFSymb;

/* global frame and current package */
Obj GlobalEnv, CurrentPackage;

/* standard input and output files */
Obj InFile, OutFile;

#ifdef DEBUG
/* debugging flags */
Boolean	debugTrace = FALSE,	/* trace opcode execution */
	debugGC = FALSE,	/* dump local GC stats */
	debugDestroy = FALSE,	/* dump obj destruction */
	debugMacro = FALSE,	/* dump after macro expansion */
	debugCode = FALSE,	/* dump codevectors */
	debugCont = FALSE;	/* trace continuations */
#endif

void globalsInit()
{
    /* symbols */
    QuoteSymb	=	objIntern("quote", STATIC);
    QuasiSymb	=	objIntern("quasiquote", STATIC);
    UnquoteSymb	=	objIntern("unquote", STATIC);
    SpliceSymb	=	objIntern("unquote-splicing", STATIC);
    ListSymb	=	objIntern("list", STATIC);
    AppendSymb	=	objIntern("append", STATIC);
    LambdaSymb	=	objIntern("lambda", STATIC);
    TheEnvSymb	=	objIntern("the-environment", STATIC);
    DefineSymb	=	objIntern("define", STATIC);
    SeqSymb	=	objIntern("sequence", STATIC);
    EvalSymb	=	objIntern("eval", STATIC);
    VectorSymb	=	objIntern("vector", STATIC);
    ApplySymb	=	objIntern("apply", STATIC);
    ListStarSymb =	objIntern("list*", STATIC);

    /* unique objects (used to be symbols) */
    NilSymb	=	newUnique(NilClass, "()");
    TrueSymb	=	newUnique(TrueClass, "#t");

#ifdef UNIQUEFALSE
    FalseSymb	=	newUnique(FalseClass, "#f");
#else
    FalseSymb	=	NilSymb;
#endif /* UNIQUEFALSE */

    EOFSymb	=	newUnique(EOFClass, "#!eof");

    /* environments */
    GlobalEnv = newFrame(gcNew, (Obj)NULL);
    CurrentPackage = GlobalEnv;
    objLink(GlobalEnv);

    InFile	= newFile(gcNew, stdin, FALSE);
    OutFile	= newFile(gcNew, stdout, TRUE);
    objLink(InFile);
    objLink(OutFile);

    /* definitions */
    objPut(objIntern("nil", STATIC), NilSymb, GlobalEnv);
    objPut(objIntern("t", STATIC), TrueSymb, GlobalEnv);
    objPut(objIntern("#!eof", STATIC), EOFSymb, GlobalEnv);
    objPut(objIntern("*stdin*", STATIC), InFile, GlobalEnv);
    objPut(objIntern("*stdout*", STATIC), OutFile, GlobalEnv);
}
