/* @(#)memory.h	1.2 1/29/90 */

#ifndef _MEMORY_H
#define _MEMORY_H

#include <sys/types.h>
#include "stuff.h"

typedef struct blocklist_s {
    Ptr buf;
    struct blocklist_s *next;
} blocklist_t;

typedef struct mem_s {
    size_t blksize, heapsize, total;
    Ptr flist;
    blocklist_t *blocks;

#ifdef DEBUG
    unsigned long count;
#endif /* DEBUG */

} *Mem, Mem_t;

#ifndef ABOUND
#ifdef mips
#define ABOUND 8L
#else
#define ABOUND 4L
#endif
#endif /* ABOUND */

/* find a size that can be aligned to a specific byte boundary */
#define ALIGNSIZE(size) \
	(((int)(size)/ABOUND)*ABOUND + ((int)(size)%ABOUND ? ABOUND : 0))

#ifdef __STDC__

/* add more memory to the memory block */
extern void memExtend(Mem mem);

/* make a memory block of initsize chunks of blocksize bytes */
extern Mem memNew(int blocksize, int initsize);

/* memBlock returns an unitialized block of size blocksize, while
 * memCleanBlock returns the block initialized to 0s.  When no free blocks
 * remain, mem is extended. */
extern Ptr memBlock(Mem mem), memCleanBlock(Mem mem);

/* like memBlock and memCleanBlock but returns NULL if mem's free list
 * is empty */
extern Ptr _memBlock(Mem mem), _memCleanBlock(Mem mem);

/* free a block */
extern void memFreeBlock(Ptr block, Mem mem);

/* apply f to all blocks, allocated and free (typecasted to (Ptr)) */
extern void memApplyAll(Mem mem, F_VOID f);

/* apply f to all free blocks */
extern void memApplyUnused(Mem mem, F_VOID f);

#else

extern Mem memNew();
extern Ptr memBlock();
extern Ptr _memBlock();
extern Ptr memCleanBlock();
extern Ptr _memCleanBlock();
extern void memFreeBlock();
extern void memApplyAll();
extern void memApplyUnused();

#endif /* defined(__STDC__) */

#endif /* defined(_MEMORY_H) */
