/* @(#)mtrees.h	1.2 1/16/90 */

#include "stuff.h"
#include "memory.h"

typedef enum balance_e {
    LH, EQ, RH,
} balance_t;

typedef struct treenode_s {
    Ptr node;
    struct treenode_s *left;
    struct treenode_s *right;
    balance_t bal;
} **Tree, *TreeNode;

#define treeEmpty(bt) (((bt) == (Tree)NULL) || ((*bt) == (TreeNode)NULL))
#define treeRoot(bt) ((*(bt))->node)
#define treeRight(bt) ((*bt)->right)
#define treeLeft(bt) ((*bt)->left)
#define treeBal(bt) ((*bt)->bal)

/* tree node allocator */
extern Mem treeAlloc;

#ifdef __STDC__

/* initialize tree memory allocator to malloc in blocks of num treenodes */
extern void treeInit(int num);

/* return an empty binary tree */
extern Tree treeNew(void);

/* insert stuff into tree
 *
 * test is a function of two args and orders the tree.  It should
 * return a positive, negative, or zero value depending on whether its
 * first argument is greater than, less than, or equal to its second
 * argument.
 *
 * If insert is not NULL then it is used to deterimine what to place in
 * the node.  The result of insert(stuff, previous contents) is stored
 * in the node and returned by treeInsert.  If the node is empty, the
 * previous contents parameter is NULL.
 *
 * If insert is NULL then stuff is inserted into the tree only if it is
 * not already in the tree. */
extern Ptr treeInsert(Ptr stuff, Tree tree, F_INT test, F_PTR insert);

/* return a subtree of tree containing stuff in the root node
 *
 * If stuff is not in the tree NULL is returned.
 * test is the same function used to insert items. */
extern Tree treeFind(Ptr stuff, Tree tree, F_INT test);

/* visit the node of the tree in order (left, node, right)
 *
 * At each node, the call fcn(item at node, arg) is made. */
extern void treeInOrder(Tree tree, F_VOID fcn, Ptr arg);
/* in post-order */
extern void treePostOrder(Tree tree, F_VOID fcn, Ptr arg);
/* in pre-order */
extern void treePreOrder(Tree tree, F_VOID fcn, Ptr arg);

/* free tree and each item in tree with fitem (unless fitem is NULL) */
extern void treeFree(Tree tree, F_VOID fitem);

/* like treeFree, except tree is only emptied. */
extern void treeClear(Tree tree, F_VOID fitem);

#else

extern void treeInit();
extern Tree treeNew();
extern Ptr treeInsert();
extern Tree treeFind();
extern void treeInOrder();
extern void treePostOrder();
extern void treePreOrder();
extern void treeFree();
extern void treeClear();

#endif /* defined(__STDC__) */
