/* @(#)opcodes.h	1.9 1/16/90 */

/*
 * Copyright 1989 Jonathan Lee.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */

#ifndef _OPCODES_
#define _OPCODES_

/* opcode type */
typedef enum opcode_e {
    code_term = 0,

#define OPCODE(name, nops) name,
#include "opcodes.i"

} opcode;

/* byte code */
typedef union bcode_u {
    opcode op;
    int num;
    F_OBJ fcn;
    Obj obj;
    Ptr ptr;
} bcode;

extern struct opcode_info_s {
    int nops; /* number of operands */
    char *name; /* name of opcode */
#ifdef DEBUG
    int count; /* number of times op is executed */
#endif /* DEBUG */
} opcodeInfo[];

/* stack frames (stored in the activation list) */
typedef struct stack_frame_s {
    Obj frame, proc;
    bcode *vec;
} stackFrame_t;

/* make and free stack frames */
#define NEW_FRAME() ((stackFrame_t *)memBlock(treeAlloc))
#define FREE_FRAME(frame) memFreeBlock((Ptr)(frame), treeAlloc)

extern Stack argStack;

#ifdef DEBUG

/* opcode counts */

extern void opcodeCount();

#endif /* DEBUG */

#define opcodeNops(code) (opcodeInfo[(int)(code)].nops)
#define opcodeName(code) (opcodeInfo[(int)(code)].name)

#define codeNext(vec) (*((vec)++))

#ifdef __STDC__

/* initialize opcode module */
extern void opcodeInit(void);

/* Execute byte codes from cvec within the scope defined by frame. */
extern Obj codeExec(Obj cvec, Obj frame);

#else

extern void opcodeInit();
extern Obj codeExec();

#endif /* __STDC__ */

#endif /* _OPCODES_ */
