; -*- Mode: Lisp; Syntax: Common-Lisp; Package: (SCHEME-INTERNAL :USE (LISP)); -*-
; File loadit.lisp / Copyright (c) 1989 Jonathan Rees / See file COPYING

;;;; Load script

; Will not run in:
;  Symbolics versions older than Rel 7.1
;  VAX LISP versions older than V2.2
;  Explorer versions older than 3.0

(lisp:in-package "SCHEME-INTERNAL"
		 :use '("LISP")
		 :nicknames '("SCHI"))

(export '(loadit))

(defvar *pseudoscheme-directory* nil)

(defun loadit (&optional dir)
  (setq *pseudoscheme-directory*
	(let ((dir (pathname (or dir
				 *pseudoscheme-directory*
				 *default-pathname-defaults*))))
	  (make-pathname :name nil
			 :type nil
			 :directory (pathname-directory dir)
			 :device    (pathname-device dir)
			 :host	    (pathname-host dir))))
  (load-hacks)
  (load-runtime)
  (load-translated-translator)
  (initialize-for-evaluation)
  (initialize-scheme-user-env))

; ----- Load low-level hacks

(defvar hacks-package)

(defun load-hacks ()
  (let ((*package* (or (find-package "SCHEME-HACKS")
		       (make-package "SCHEME-HACKS"
				     :use '("LISP")
				     :nicknames '("SCHH")))))
    (setq hacks-package *package*)
    (load (pseudo-pathname "CLEVER")
	  :verbose nil)			;Get clever file loader
    ;; Don't intern the symbol CLEVER-LOAD in the wrong package!
    (funcall (hack-symbol "CLEVER-LOAD")
	     (pseudo-pathname "HACKS")
	     :compile-if-necessary t)
    ;; Create the scheme-internal package
    (funcall (hack-symbol "CLEVER-LOAD")
	     (pseudo-pathname "SCHI"))))

(defun hack-symbol (name)
  (intern name hacks-package))

(defun pseudo-pathname (name)
  (make-pathname :name (preferred-case name)
		 :defaults *pseudoscheme-directory*))

(defun preferred-case (name)
  #+unix (string-downcase name)
  #-unix name
  )

; ----- Load runtime system

(defparameter revised^3-scheme-env     nil)
(defparameter revised^3-scheme-context nil)

(defun load-runtime ()
  (let ((package (or (find-package "SCHEME")
		     (make-package "SCHEME" :use '()))))
    (funcall (hack-symbol "FIX-SCHEME-PACKAGE-IF-NECESSARY") package)
    #+Symbolics
    (pushnew package si:*reasonable-packages*))

  (mapc #'load-runtime-file
	'("READTABLE"
	  "CORE"			;for STRING->SYMBOL
	  ;; REP loop and related things
	  "EVAL"
	  #+Lispm "CUSTOM"
	  ))

  ;; Load Revised^3 stuff
  (let ((id (intern "REVISED^3-SCHEME" scheme-package)))
    (setq revised^3-scheme-env (make-environment id))
    (setq revised^3-scheme-context (make-context id revised^3-scheme-env)))
  (load-translated "CLOSED" revised^3-scheme-context)
  (let ((path (pseudo-pathname "RTS")))
    (scheme-load path revised^3-scheme-context
		 :compile-if-necessary t
		 ;; KLUDGE... how to fix this?
		 :source-type (funcall (intern "SOURCE-FILE-TYPE"
					       (find-package "SCHEME-HACKS"))
				       path))
    'done))

(defvar this-package *package*)

(defun load-runtime-file (filespec)
  (let ((*package* this-package))
    (funcall (hack-symbol "CLEVER-LOAD")
      (pseudo-pathname (if (consp filespec) (car filespec) filespec))
      :compile-if-necessary (not (consp filespec)))))

(defun load-translated (file context &key (source-type *translated-file-type*))
  ;; PSO stands for Pseudo-Scheme Object file
  (scheme-load (pseudo-pathname file)
	       context
	       :source-type source-type
	       :compile-if-necessary t))

; ----- Load translator

(defparameter scheme-translator-env     nil)
(defparameter scheme-translator-context nil)

(defun load-translated-translator ()
  (let ((id (intern "SCHEME-TRANSLATOR" scheme-package)))
    (setq scheme-translator-env (make-environment id))
    (let ((package (environment-package scheme-translator-env)))
      (use-package (environment-package revised^3-scheme-env)
		   package)
      (setq scheme-translator-context
	    (make-context id scheme-translator-env)))

    (let ((*package* this-package))
      (funcall (hack-symbol "CLEVER-LOAD")
	       (pseudo-pathname "FILES")
	       #+LispM :package #+LispM this-package))
    (mapc #'(lambda (file)
	      (load-translated file scheme-translator-context))
	  translator-files)
    'done))
