; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SCHEME-INTERNAL; -*-
; File schi.lisp / Copyright (c) 1991 Jonathan Rees / See file COPYING

;;;; The SCHEME-INTERNAL package

(lisp:in-package "SCHI"
		 :nicknames '("SCHEME-INTERNAL")
		 :use '(#-:DEC "LISP" #+:DEC "COMMON-LISP"))

(export '(;; Auxiliaries for core constructs
	  set!-aux
	  set-function-from-value
	  set-value-from-function
	  set-forwarding-function
	  unspecified
	  unassigned
	  true				; #t
	  false				; #f
	  true?				; CL boolean -> Scheme boolean
	  truep				; Scheme boolean -> CL boolean
	  sand sor			; mumble
	  begin-translated-file		;prelude
	  at-top-level  		;kludge for symbolics lossage
	  ;; Additional auxiliaries for Revised^4 builtins
	  scheme-package		;for STRING->SYMBOL
	  procedurep			;for PROCEDURE?
	  scheme-symbol-p		;for SYMBOL?
	  scheme-equal-p		;for MEMBER, ASSOC, EQUAL?
	  booleanp
	  char-whitespace-p
	  input-port-p
	  output-port-p
	  realp
	  ;; Additional auxiliaries for Revised^4 non-builtins
	  scheme-load			;forward reference from RTS to EVAL
	  scheme-readtable		;for READ
	  eof-object			;for READ, READ-CHAR
	  ;; Random
	  scheme-error
	  ))
