;;; Flags for open(2) and fcntl(2).
;;; Copyright (c) 1993 by Olin Shivers.

(define-syntax define-open-flags
  (syntax-rules ()
    ((define-errnos form ...)
     (begin (define-enum-constant "open" . form) ...))))

(define-open-flags
  (read			0)
  (write		1)
  (read+write		2)
  (append		8)
  (create		#o00400)
  (exclusive		#o02000)
  (no-control-tty	#o04000)
  (nonblocking		#o00100)
  (truncate		#o01000)

;;; Not POSIX.
  (no-delay	#o0004)
  (sync		#o0020))

(define open/access-mask
  (bitwise-ior open/read
	       (bitwise-ior open/write open/read+write)))
