(MODULE XWS10)
(INCLUDE "xlibTYPES.sch")
(DEFINE-C-EXTERNAL (XLOOKUPKEYSYM* POINTER INT) UNSIGNED "XLookupKeysym")
(DEFINE
  (XLOOKUPKEYSYM EVENT COL)
  (LET*
    ((EVENT (CHK-XEVENTP EVENT))
      (COL COL)
      (RETURN-VALUE (XLOOKUPKEYSYM* EVENT COL)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XREFRESHKEYBOARDMAPPING* POINTER)
  VOID
  "XRefreshKeyboardMapping")
(DEFINE
  (XREFRESHKEYBOARDMAPPING EVENT)
  (LET*
    ((EVENT (CHK-XEVENTP EVENT))
      (RETURN-VALUE (BEGIN (XREFRESHKEYBOARDMAPPING* EVENT) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XLOOKUPSTRING* POINTER POINTER INT POINTER POINTER)
  INT
  "XLookupString")
(DEFINE
  (XLOOKUPSTRING EVENT BUFFER BYTES_BUFFER STATUS)
  (LET*
    ((EVENT (CHK-XEVENTP EVENT))
      (BUFFER (CHK-CHARAP BUFFER))
      (BYTES_BUFFER BYTES_BUFFER)
      (KEYSYM_RETURN (MAKE-STRING 4))
      (STATUS (CHK-XCOMPOSESTATUSP STATUS))
      (RETURN-VALUE
        (XLOOKUPSTRING* EVENT BUFFER BYTES_BUFFER KEYSYM_RETURN STATUS)))
    (LIST RETURN-VALUE (C-UNSIGNED-REF KEYSYM_RETURN 0))))
(DEFINE-C-EXTERNAL
  (XREBINDKEYSYM* POINTER UNSIGNED POINTER INT POINTER INT)
  VOID
  "XRebindKeysym")
(DEFINE
  (XREBINDKEYSYM DPY KEYSYM MLIST NM STR NBYTES)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (KEYSYM KEYSYM)
      (MLIST (CHK-UNSIGNEDAP MLIST))
      (NM NM)
      (STR
        (IF
          (STRING? STR)
          STR
          (ERROR 'CHK-STRING "Argument is incorrect type: ~s" STR)))
      (NBYTES NBYTES)
      (RETURN-VALUE (BEGIN (XREBINDKEYSYM* DPY KEYSYM MLIST NM STR NBYTES) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XSTRINGTOKEYSYM* POINTER) UNSIGNED "XStringToKeysym")
(DEFINE
  (XSTRINGTOKEYSYM S)
  (LET*
    ((S
       (IF
         (STRING? S)
         S
         (ERROR 'CHK-STRING "Argument is incorrect type: ~s" S)))
      (RETURN-VALUE (XSTRINGTOKEYSYM* S)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XKEYSYMTOSTRING* UNSIGNED) POINTER "XKeysymToString")
(DEFINE
  (XKEYSYMTOSTRING KS)
  (LET*
    ((KS KS) (RETURN-VALUE (C-STRING->STRING (XKEYSYMTOSTRING* KS))))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XKEYCODETOKEYSYM* POINTER CHAR INT)
  UNSIGNED
  "XKeycodeToKeysym")
(DEFINE
  (XKEYCODETOKEYSYM DPY KC COL)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (KC KC)
      (COL COL)
      (RETURN-VALUE (XKEYCODETOKEYSYM* DPY KC COL)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XKEYSYMTOKEYCODE* POINTER UNSIGNED) CHAR "XKeysymToKeycode")
(DEFINE
  (XKEYSYMTOKEYCODE DPY KS)
  (LET*
    ((DPY (CHK-DISPLAYP DPY)) (KS KS) (RETURN-VALUE (XKEYSYMTOKEYCODE* DPY KS)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XGETDEFAULT* POINTER POINTER POINTER) POINTER "XGetDefault")
(DEFINE
  (XGETDEFAULT DPY PROG NAME)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (PROG
        (IF
          (STRING? PROG)
          PROG
          (ERROR 'CHK-STRING "Argument is incorrect type: ~s" PROG)))
      (NAME
        (IF
          (STRING? NAME)
          NAME
          (ERROR 'CHK-STRING "Argument is incorrect type: ~s" NAME)))
      (RETURN-VALUE (C-STRING->STRING (XGETDEFAULT* DPY PROG NAME))))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XRESOURCEMANAGERSTRING* POINTER)
  POINTER
  "XResourceManagerString")
(DEFINE
  (XRESOURCEMANAGERSTRING DPY)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (RETURN-VALUE (C-STRING->STRING (XRESOURCEMANAGERSTRING* DPY))))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XPARSEGEOMETRY* POINTER POINTER POINTER POINTER POINTER)
  INT
  "XParseGeometry")
(DEFINE
  (XPARSEGEOMETRY STRING)
  (LET*
    ((STRING
       (IF
         (STRING? STRING)
         STRING
         (ERROR 'CHK-STRING "Argument is incorrect type: ~s" STRING)))
      (X (MAKE-STRING 4))
      (Y (MAKE-STRING 4))
      (WIDTH (MAKE-STRING 4))
      (HEIGHT (MAKE-STRING 4))
      (RETURN-VALUE (XPARSEGEOMETRY* STRING X Y WIDTH HEIGHT)))
    (LIST
      RETURN-VALUE
      (C-INT-REF X 0)
      (C-INT-REF Y 0)
      (C-UNSIGNED-REF WIDTH 0)
      (C-UNSIGNED-REF HEIGHT 0))))
(DEFINE-C-EXTERNAL
  (XGEOMETRY*
    POINTER
    INT
    POINTER
    POINTER
    UNSIGNED
    UNSIGNED
    UNSIGNED
    INT
    INT
    POINTER
    POINTER
    POINTER
    POINTER)
  INT
  "XGeometry")
(DEFINE
  (XGEOMETRY DPY SCREEN POS DEF BWIDTH FWIDTH FHEIGHT XADD YADD)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (SCREEN SCREEN)
      (POS
        (IF
          (STRING? POS)
          POS
          (ERROR 'CHK-STRING "Argument is incorrect type: ~s" POS)))
      (DEF
        (IF
          (STRING? DEF)
          DEF
          (ERROR 'CHK-STRING "Argument is incorrect type: ~s" DEF)))
      (BWIDTH BWIDTH)
      (FWIDTH FWIDTH)
      (FHEIGHT FHEIGHT)
      (XADD XADD)
      (YADD YADD)
      (X (MAKE-STRING 4))
      (Y (MAKE-STRING 4))
      (WIDTH (MAKE-STRING 4))
      (HEIGHT (MAKE-STRING 4))
      (RETURN-VALUE
        (XGEOMETRY*
          DPY
          SCREEN
          POS
          DEF
          BWIDTH
          FWIDTH
          FHEIGHT
          XADD
          YADD
          X
          Y
          WIDTH
          HEIGHT)))
    (LIST
      RETURN-VALUE
      (C-INT-REF X 0)
      (C-INT-REF Y 0)
      (C-INT-REF WIDTH 0)
      (C-INT-REF HEIGHT 0))))
(DEFINE-C-EXTERNAL
  (XPARSECOLOR* POINTER UNSIGNED POINTER POINTER)
  INT
  "XParseColor")
(DEFINE
  (XPARSECOLOR DPY CMAP SPEC)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (CMAP CMAP)
      (SPEC
        (IF
          (STRING? SPEC)
          SPEC
          (ERROR 'CHK-STRING "Argument is incorrect type: ~s" SPEC)))
      (DEF (MAKE-STRING 12))
      (RETURN-VALUE (XPARSECOLOR* DPY CMAP SPEC DEF)))
    (LIST RETURN-VALUE (CONS 'XCOLORP DEF))))
(DEFINE-C-EXTERNAL (XPOLYGONREGION* POINTER INT INT) POINTER "XPolygonRegion")
(DEFINE
  (XPOLYGONREGION PTS COUNT RULE)
  (LET*
    ((PTS (CHK-XPOINTAP PTS))
      (COUNT COUNT)
      (RULE RULE)
      (RETURN-VALUE (CONS 'REGION (XPOLYGONREGION* PTS COUNT RULE))))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XCLIPBOX* POINTER POINTER) VOID "XClipBox")
(DEFINE
  (XCLIPBOX R)
  (LET*
    ((R (CHK-REGION R))
      (RECT (MAKE-STRING 8))
      (RETURN-VALUE (BEGIN (XCLIPBOX* R RECT) #F)))
    (CONS 'XRECTANGLEP RECT)))
(DEFINE-C-EXTERNAL (XCREATEREGION*) POINTER "XCreateRegion")
(DEFINE
  (XCREATEREGION)
  (LET* ((RETURN-VALUE (CONS 'REGION (XCREATEREGION*)))) RETURN-VALUE))
(DEFINE-C-EXTERNAL (XSETREGION* POINTER POINTER POINTER) VOID "XSetRegion")
(DEFINE
  (XSETREGION DPY GC R)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (GC (CHK-GC GC))
      (R (CHK-REGION R))
      (RETURN-VALUE (BEGIN (XSETREGION* DPY GC R) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XDESTROYREGION* POINTER) VOID "XDestroyRegion")
(DEFINE
  (XDESTROYREGION R)
  (LET*
    ((R (CHK-REGION R)) (RETURN-VALUE (BEGIN (XDESTROYREGION* R) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XOFFSETREGION* POINTER INT INT) VOID "XOffsetRegion")
(DEFINE
  (XOFFSETREGION PREGION X Y)
  (LET*
    ((PREGION (CHK-REGION PREGION))
      (X X)
      (Y Y)
      (RETURN-VALUE (BEGIN (XOFFSETREGION* PREGION X Y) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XSHRINKREGION* POINTER INT INT) VOID "XShrinkRegion")
(DEFINE
  (XSHRINKREGION R DX DY)
  (LET*
    ((R (CHK-REGION R))
      (DX DX)
      (DY DY)
      (RETURN-VALUE (BEGIN (XSHRINKREGION* R DX DY) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XINTERSECTREGION* POINTER POINTER POINTER)
  VOID
  "XIntersectRegion")
(DEFINE
  (XINTERSECTREGION REG1 REG2)
  (LET*
    ((REG1 (CHK-REGION REG1))
      (REG2 (CHK-REGION REG2))
      (NEWREG (MAKE-STRING 4))
      (RETURN-VALUE (BEGIN (XINTERSECTREGION* REG1 REG2 NEWREG) #F)))
    (CONS 'REGION (C-UNSIGNED-REF NEWREG 0))))
(DEFINE-C-EXTERNAL (XUNIONREGION* POINTER POINTER POINTER) VOID "XUnionRegion")
(DEFINE
  (XUNIONREGION REG1 REG2)
  (LET*
    ((REG1 (CHK-REGION REG1))
      (REG2 (CHK-REGION REG2))
      (NEWREG (MAKE-STRING 4))
      (RETURN-VALUE (BEGIN (XUNIONREGION* REG1 REG2 NEWREG) #F)))
    (CONS 'REGION (C-UNSIGNED-REF NEWREG 0))))
(DEFINE-C-EXTERNAL
  (XUNIONRECTWITHREGION* POINTER POINTER POINTER)
  VOID
  "XUnionRectWithRegion")
(DEFINE
  (XUNIONRECTWITHREGION RECT SOURCE)
  (LET*
    ((RECT (CHK-XRECTANGLEP RECT))
      (SOURCE (CHK-REGION SOURCE))
      (DEST (MAKE-STRING 4))
      (RETURN-VALUE (BEGIN (XUNIONRECTWITHREGION* RECT SOURCE DEST) #F)))
    (CONS 'REGION (C-UNSIGNED-REF DEST 0))))
(DEFINE-C-EXTERNAL
  (XSUBTRACTREGION* POINTER POINTER POINTER)
  VOID
  "XSubtractRegion")
(DEFINE
  (XSUBTRACTREGION REGM REGS)
  (LET*
    ((REGM (CHK-REGION REGM))
      (REGS (CHK-REGION REGS))
      (REGD (MAKE-STRING 4))
      (RETURN-VALUE (BEGIN (XSUBTRACTREGION* REGM REGS REGD) #F)))
    (CONS 'REGION (C-UNSIGNED-REF REGD 0))))
(DEFINE-C-EXTERNAL (XXORREGION* POINTER POINTER POINTER) VOID "XXorRegion")
(DEFINE
  (XXORREGION SRA SRB)
  (LET*
    ((SRA (CHK-REGION SRA))
      (SRB (CHK-REGION SRB))
      (DR (MAKE-STRING 4))
      (RETURN-VALUE (BEGIN (XXORREGION* SRA SRB DR) #F)))
    (CONS 'REGION (C-UNSIGNED-REF DR 0))))
(DEFINE-C-EXTERNAL (XEMPTYREGION* POINTER) INT "XEmptyRegion")
(DEFINE
  (XEMPTYREGION R)
  (LET* ((R (CHK-REGION R)) (RETURN-VALUE (XEMPTYREGION* R))) RETURN-VALUE))
(DEFINE-C-EXTERNAL (XEQUALREGION* POINTER POINTER) INT "XEqualRegion")
(DEFINE
  (XEQUALREGION R1 R2)
  (LET*
    ((R1 (CHK-REGION R1))
      (R2 (CHK-REGION R2))
      (RETURN-VALUE (XEQUALREGION* R1 R2)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XPOINTINREGION* POINTER INT INT) INT "XPointInRegion")
(DEFINE
  (XPOINTINREGION PREGION X Y)
  (LET*
    ((PREGION (CHK-REGION PREGION))
      (X X)
      (Y Y)
      (RETURN-VALUE (XPOINTINREGION* PREGION X Y)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XRECTINREGION* POINTER INT INT UNSIGNED UNSIGNED)
  INT
  "XRectInRegion")
(DEFINE
  (XRECTINREGION REGION RX RY RWIDTH RHEIGHT)
  (LET*
    ((REGION (CHK-REGION REGION))
      (RX RX)
      (RY RY)
      (RWIDTH RWIDTH)
      (RHEIGHT RHEIGHT)
      (RETURN-VALUE (XRECTINREGION* REGION RX RY RWIDTH RHEIGHT)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XSTOREBYTES* POINTER POINTER INT) VOID "XStoreBytes")
(DEFINE
  (XSTOREBYTES DPY BYTES NBYTES)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (BYTES (CHK-CHARAP BYTES))
      (NBYTES NBYTES)
      (RETURN-VALUE (BEGIN (XSTOREBYTES* DPY BYTES NBYTES) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XSTOREBUFFER* POINTER POINTER INT INT) VOID "XStoreBuffer")
(DEFINE
  (XSTOREBUFFER DPY BYTES NBYTES BUFFER)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (BYTES (CHK-CHARAP BYTES))
      (NBYTES NBYTES)
      (BUFFER BUFFER)
      (RETURN-VALUE (BEGIN (XSTOREBUFFER* DPY BYTES NBYTES BUFFER) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XFETCHBYTES* POINTER POINTER) POINTER "XFetchBytes")
(DEFINE
  (XFETCHBYTES DPY)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (NBYTES (MAKE-STRING 4))
      (RETURN-VALUE (CONS 'CHARAP (XFETCHBYTES* DPY NBYTES))))
    (LIST RETURN-VALUE (C-INT-REF NBYTES 0))))
(DEFINE-C-EXTERNAL (XFETCHBUFFER* POINTER POINTER INT) POINTER "XFetchBuffer")
(DEFINE
  (XFETCHBUFFER DPY BUFFER)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (NBYTES (MAKE-STRING 4))
      (BUFFER BUFFER)
      (RETURN-VALUE (CONS 'CHARAP (XFETCHBUFFER* DPY NBYTES BUFFER))))
    (LIST RETURN-VALUE (C-INT-REF NBYTES 0))))
(DEFINE-C-EXTERNAL (XROTATEBUFFERS* POINTER INT) VOID "XRotateBuffers")
(DEFINE
  (XROTATEBUFFERS DPY ROTATE)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (ROTATE ROTATE)
      (RETURN-VALUE (BEGIN (XROTATEBUFFERS* DPY ROTATE) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XGETVISUALINFO* POINTER INT POINTER POINTER)
  POINTER
  "XGetVisualInfo")
(DEFINE
  (XGETVISUALINFO DPY VISUAL_INFO_MASK VISUAL_INFO_TEMPLATE)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (VISUAL_INFO_MASK VISUAL_INFO_MASK)
      (VISUAL_INFO_TEMPLATE (CHK-XVISUALINFOP VISUAL_INFO_TEMPLATE))
      (NITEMS (MAKE-STRING 4))
      (RETURN-VALUE
        (CONS
          'XVISUALINFOP
          (XGETVISUALINFO* DPY VISUAL_INFO_MASK VISUAL_INFO_TEMPLATE NITEMS))))
    (LIST RETURN-VALUE (C-INT-REF NITEMS 0))))
(DEFINE-C-EXTERNAL
  (XMATCHVISUALINFO* POINTER INT INT INT POINTER)
  INT
  "XMatchVisualInfo")
(DEFINE
  (XMATCHVISUALINFO DPY SCREEN DEPTH CLASS)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (SCREEN SCREEN)
      (DEPTH DEPTH)
      (CLASS CLASS)
      (VISUAL_INFO (MAKE-STRING 40))
      (RETURN-VALUE (XMATCHVISUALINFO* DPY SCREEN DEPTH CLASS VISUAL_INFO)))
    (LIST RETURN-VALUE (CONS 'XVISUALINFOP VISUAL_INFO))))
(DEFINE-C-EXTERNAL
  (XCREATEIMAGE*
    POINTER
    POINTER
    UNSIGNED
    INT
    INT
    POINTER
    UNSIGNED
    UNSIGNED
    INT
    INT)
  POINTER
  "XCreateImage")
(DEFINE
  (XCREATEIMAGE
    DPY
    VISUAL
    DEPTH
    FORMAT
    OFFSET
    DATA
    WIDTH
    HEIGHT
    XPAD
    IMAGE_BYTES_PER_LINE)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (VISUAL (CHK-VISUALP VISUAL))
      (DEPTH DEPTH)
      (FORMAT FORMAT)
      (OFFSET OFFSET)
      (DATA (CHK-CHARP DATA))
      (WIDTH WIDTH)
      (HEIGHT HEIGHT)
      (XPAD XPAD)
      (IMAGE_BYTES_PER_LINE IMAGE_BYTES_PER_LINE)
      (RETURN-VALUE
        (CONS
          'XIMAGEP
          (XCREATEIMAGE*
            DPY
            VISUAL
            DEPTH
            FORMAT
            OFFSET
            DATA
            WIDTH
            HEIGHT
            XPAD
            IMAGE_BYTES_PER_LINE))))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XGETPIXEL* POINTER INT INT) INT "XGetPixel")
(DEFINE
  (XGETPIXEL XIMAGE X Y)
  (LET*
    ((XIMAGE (CHK-XIMAGEP XIMAGE))
      (X X)
      (Y Y)
      (RETURN-VALUE (XGETPIXEL* XIMAGE X Y)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XPUTPIXEL* POINTER INT INT UNSIGNED) INT "XPutPixel")
(DEFINE
  (XPUTPIXEL XIMAGE X Y PIXEL)
  (LET*
    ((XIMAGE (CHK-XIMAGEP XIMAGE))
      (X X)
      (Y Y)
      (PIXEL PIXEL)
      (RETURN-VALUE (XPUTPIXEL* XIMAGE X Y PIXEL)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XSUBIMAGE* POINTER INT INT UNSIGNED UNSIGNED)
  POINTER
  "XSubImage")
(DEFINE
  (XSUBIMAGE XIMAGE X Y WIDTH HEIGHT)
  (LET*
    ((XIMAGE (CHK-XIMAGEP XIMAGE))
      (X X)
      (Y Y)
      (WIDTH WIDTH)
      (HEIGHT HEIGHT)
      (RETURN-VALUE (CONS 'XIMAGEP (XSUBIMAGE* XIMAGE X Y WIDTH HEIGHT))))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XADDPIXEL* POINTER UNSIGNED) VOID "XAddPixel")
(DEFINE
  (XADDPIXEL XIMAGE VALUE)
  (LET*
    ((XIMAGE (CHK-XIMAGEP XIMAGE))
      (VALUE VALUE)
      (RETURN-VALUE (BEGIN (XADDPIXEL* XIMAGE VALUE) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XDESTROYIMAGE* POINTER) INT "XDestroyImage")
(DEFINE
  (XDESTROYIMAGE XIMAGE)
  (LET*
    ((XIMAGE (CHK-XIMAGEP XIMAGE)) (RETURN-VALUE (XDESTROYIMAGE* XIMAGE)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XREADBITMAPFILE*
    POINTER
    UNSIGNED
    POINTER
    POINTER
    POINTER
    POINTER
    POINTER
    POINTER)
  INT
  "XReadBitmapFile")
(DEFINE
  (XREADBITMAPFILE DISPLAY D FILENAME)
  (LET*
    ((DISPLAY (CHK-DISPLAYP DISPLAY))
      (D D)
      (FILENAME
        (IF
          (STRING? FILENAME)
          FILENAME
          (ERROR 'CHK-STRING "Argument is incorrect type: ~s" FILENAME)))
      (WIDTH (MAKE-STRING 4))
      (HEIGHT (MAKE-STRING 4))
      (PIXMAP (MAKE-STRING 4))
      (X_HOT (MAKE-STRING 4))
      (Y_HOT (MAKE-STRING 4))
      (RETURN-VALUE
        (XREADBITMAPFILE* DISPLAY D FILENAME WIDTH HEIGHT PIXMAP X_HOT Y_HOT)))
    (LIST
      RETURN-VALUE
      (C-UNSIGNED-REF WIDTH 0)
      (C-UNSIGNED-REF HEIGHT 0)
      (C-UNSIGNED-REF PIXMAP 0)
      (C-INT-REF X_HOT 0)
      (C-INT-REF Y_HOT 0))))
(DEFINE-C-EXTERNAL
  (XWRITEBITMAPFILE* POINTER POINTER UNSIGNED UNSIGNED UNSIGNED INT INT)
  INT
  "XWriteBitmapFile")
(DEFINE
  (XWRITEBITMAPFILE DISPLAY FILENAME BITMAP WIDTH HEIGHT X_HOT Y_HOT)
  (LET*
    ((DISPLAY (CHK-DISPLAYP DISPLAY))
      (FILENAME
        (IF
          (STRING? FILENAME)
          FILENAME
          (ERROR 'CHK-STRING "Argument is incorrect type: ~s" FILENAME)))
      (BITMAP BITMAP)
      (WIDTH WIDTH)
      (HEIGHT HEIGHT)
      (X_HOT X_HOT)
      (Y_HOT Y_HOT)
      (RETURN-VALUE
        (XWRITEBITMAPFILE* DISPLAY FILENAME BITMAP WIDTH HEIGHT X_HOT Y_HOT)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XCREATEPIXMAPFROMBITMAPDATA*
    POINTER
    UNSIGNED
    POINTER
    UNSIGNED
    UNSIGNED
    UNSIGNED
    UNSIGNED
    UNSIGNED)
  UNSIGNED
  "XCreatePixmapFromBitmapData")
(DEFINE
  (XCREATEPIXMAPFROMBITMAPDATA DISPLAY D DATA WIDTH HEIGHT FG BG DEPTH)
  (LET*
    ((DISPLAY (CHK-DISPLAYP DISPLAY))
      (D D)
      (DATA (CHK-CHARP DATA))
      (WIDTH WIDTH)
      (HEIGHT HEIGHT)
      (FG FG)
      (BG BG)
      (DEPTH DEPTH)
      (RETURN-VALUE
        (XCREATEPIXMAPFROMBITMAPDATA* DISPLAY D DATA WIDTH HEIGHT FG BG DEPTH)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XCREATEBITMAPFROMDATA* POINTER UNSIGNED POINTER UNSIGNED UNSIGNED)
  UNSIGNED
  "XCreateBitmapFromData")
(DEFINE
  (XCREATEBITMAPFROMDATA DISPLAY D DATA WIDTH HEIGHT)
  (LET*
    ((DISPLAY (CHK-DISPLAYP DISPLAY))
      (D D)
      (DATA (CHK-CHARP DATA))
      (WIDTH WIDTH)
      (HEIGHT HEIGHT)
      (RETURN-VALUE (XCREATEBITMAPFROMDATA* DISPLAY D DATA WIDTH HEIGHT)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XRMINITIALIZE*) VOID "XrmInitialize")
(DEFINE
  (XRMINITIALIZE)
  (LET* ((RETURN-VALUE (BEGIN (XRMINITIALIZE*) #F))) RETURN-VALUE))
(DEFINE-C-EXTERNAL (XRMUNIQUEQUARK*) INT "XrmUniqueQuark")
(DEFINE (XRMUNIQUEQUARK) (LET* ((RETURN-VALUE (XRMUNIQUEQUARK*))) RETURN-VALUE))
(DEFINE-C-EXTERNAL (XPERMALLOC* UNSIGNED) POINTER "Xpermalloc")
(DEFINE
  (XPERMALLOC LENGTH)
  (LET*
    ((LENGTH LENGTH) (RETURN-VALUE (CONS 'CHARP (XPERMALLOC* LENGTH))))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XRMSTRINGTOQUARK* POINTER) INT "XrmStringToQuark")
(DEFINE
  (XRMSTRINGTOQUARK NAME)
  (LET*
    ((NAME (CHK-CHARAP NAME)) (RETURN-VALUE (XRMSTRINGTOQUARK* NAME)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XRMQUARKTOSTRING* INT) POINTER "XrmQuarkToString")
(DEFINE
  (XRMQUARKTOSTRING QUARK)
  (LET*
    ((QUARK QUARK)
      (RETURN-VALUE (CONS 'CHARAP (XRMQUARKTOSTRING* QUARK))))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XRMSTRINGTOQUARKLIST* POINTER POINTER)
  VOID
  "XrmStringToQuarkList")
(DEFINE
  (XRMSTRINGTOQUARKLIST NAME)
  (LET*
    ((NAME
       (IF
         (STRING? NAME)
         NAME
         (ERROR 'CHK-STRING "Argument is incorrect type: ~s" NAME)))
      (QUARKS (MAKE-STRING 4))
      (RETURN-VALUE (BEGIN (XRMSTRINGTOQUARKLIST* NAME QUARKS) #F)))
    (CONS 'INTAP (C-UNSIGNED-REF QUARKS 0))))
(DEFINE-C-EXTERNAL
  (XRMSTRINGTOBINDINGQUARKLIST* POINTER POINTER POINTER)
  VOID
  "XrmStringToBindingQuarkList")
(DEFINE
  (XRMSTRINGTOBINDINGQUARKLIST NAME)
  (LET*
    ((NAME
       (IF
         (STRING? NAME)
         NAME
         (ERROR 'CHK-STRING "Argument is incorrect type: ~s" NAME)))
      (BINDINGS (MAKE-STRING 4))
      (QUARKS (MAKE-STRING 4))
      (RETURN-VALUE
        (BEGIN (XRMSTRINGTOBINDINGQUARKLIST* NAME BINDINGS QUARKS) #F)))
    (LIST
      (CONS 'INTAP (C-UNSIGNED-REF BINDINGS 0))
      (CONS 'INTAP (C-UNSIGNED-REF QUARKS 0)))))
(DEFINE-C-EXTERNAL
  (XRMPUTRESOURCE* POINTER POINTER POINTER POINTER)
  VOID
  "XrmPutResource")
(DEFINE
  (XRMPUTRESOURCE PDB SPECIFIER TYPE VALUE)
  (LET*
    ((PDB (CHK-XRMDATABASEP PDB))
      (SPECIFIER
        (IF
          (STRING? SPECIFIER)
          SPECIFIER
          (ERROR 'CHK-STRING "Argument is incorrect type: ~s" SPECIFIER)))
      (TYPE
        (IF
          (STRING? TYPE)
          TYPE
          (ERROR 'CHK-STRING "Argument is incorrect type: ~s" TYPE)))
      (VALUE (CHK-XRMVALUEPTR VALUE))
      (RETURN-VALUE (BEGIN (XRMPUTRESOURCE* PDB SPECIFIER TYPE VALUE) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XRMQPUTRESOURCE* POINTER POINTER POINTER INT POINTER)
  VOID
  "XrmQPutResource")
(DEFINE
  (XRMQPUTRESOURCE PDB BINDINGS QUARKS TYPE VALUE)
  (LET*
    ((PDB (CHK-XRMDATABASEP PDB))
      (BINDINGS (CHK-INTAP BINDINGS))
      (QUARKS (CHK-INTAP QUARKS))
      (TYPE TYPE)
      (VALUE (CHK-XRMVALUEPTR VALUE))
      (RETURN-VALUE
        (BEGIN (XRMQPUTRESOURCE* PDB BINDINGS QUARKS TYPE VALUE) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XRMPUTSTRINGRESOURCE* POINTER POINTER POINTER)
  VOID
  "XrmPutStringResource")
(DEFINE
  (XRMPUTSTRINGRESOURCE PDB SPECIFIER STR)
  (LET*
    ((PDB (CHK-XRMDATABASEP PDB))
      (SPECIFIER
        (IF
          (STRING? SPECIFIER)
          SPECIFIER
          (ERROR 'CHK-STRING "Argument is incorrect type: ~s" SPECIFIER)))
      (STR
        (IF
          (STRING? STR)
          STR
          (ERROR 'CHK-STRING "Argument is incorrect type: ~s" STR)))
      (RETURN-VALUE (BEGIN (XRMPUTSTRINGRESOURCE* PDB SPECIFIER STR) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XRMQPUTSTRINGRESOURCE* POINTER POINTER POINTER POINTER)
  VOID
  "XrmQPutStringResource")
(DEFINE
  (XRMQPUTSTRINGRESOURCE PDB BINDINGS QUARKS STR)
  (LET*
    ((PDB (CHK-XRMDATABASEP PDB))
      (BINDINGS (CHK-INTAP BINDINGS))
      (QUARKS (CHK-INTAP QUARKS))
      (STR
        (IF
          (STRING? STR)
          STR
          (ERROR 'CHK-STRING "Argument is incorrect type: ~s" STR)))
      (RETURN-VALUE (BEGIN (XRMQPUTSTRINGRESOURCE* PDB BINDINGS QUARKS STR) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XRMPUTLINERESOURCE* POINTER POINTER)
  VOID
  "XrmPutLineResource")
(DEFINE
  (XRMPUTLINERESOURCE PDB LINE)
  (LET*
    ((PDB (CHK-XRMDATABASEP PDB))
      (LINE
        (IF
          (STRING? LINE)
          LINE
          (ERROR 'CHK-STRING "Argument is incorrect type: ~s" LINE)))
      (RETURN-VALUE (BEGIN (XRMPUTLINERESOURCE* PDB LINE) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XRMGETRESOURCE* POINTER POINTER POINTER POINTER POINTER)
  INT
  "XrmGetResource")
(DEFINE
  (XRMGETRESOURCE DB NAME_STR CLASS_STR)
  (LET*
    ((DB (CHK-XRMHASHBUCKET DB))
      (NAME_STR (CHK-CHARAP NAME_STR))
      (CLASS_STR (CHK-CHARAP CLASS_STR))
      (PTYPE_STR (MAKE-STRING 4))
      (PVALUE (MAKE-STRING 4))
      (RETURN-VALUE (XRMGETRESOURCE* DB NAME_STR CLASS_STR PTYPE_STR PVALUE)))
    (LIST
      RETURN-VALUE
      (CONS 'CHARAP (C-UNSIGNED-REF PTYPE_STR 0))
      (CONS 'XRMVALUEPTR (C-UNSIGNED-REF PVALUE 0)))))
(DEFINE-C-EXTERNAL
  (XRMQGETRESOURCE* POINTER POINTER POINTER POINTER POINTER)
  INT
  "XrmQGetResource")
(DEFINE
  (XRMQGETRESOURCE DB NAMES CLASSES)
  (LET*
    ((DB (CHK-XRMHASHBUCKET DB))
      (NAMES (CHK-INTAP NAMES))
      (CLASSES (CHK-INTAP CLASSES))
      (PTYPE (MAKE-STRING 4))
      (PVALUE (MAKE-STRING 4))
      (RETURN-VALUE (XRMQGETRESOURCE* DB NAMES CLASSES PTYPE PVALUE)))
    (LIST
      RETURN-VALUE
      (C-INT-REF PTYPE 0)
      (CONS 'XRMVALUEPTR (C-UNSIGNED-REF PVALUE 0)))))
(DEFINE-C-EXTERNAL
  (XRMQGETSEARCHLIST* POINTER POINTER POINTER INT INT)
  INT
  "XrmQGetSearchList")
(DEFINE
  (XRMQGETSEARCHLIST DB NAMES CLASSES SEARCHLIST LISTLENGTH)
  (LET*
    ((DB (CHK-XRMHASHBUCKET DB))
      (NAMES (CHK-INTAP NAMES))
      (CLASSES (CHK-INTAP CLASSES))
      (SEARCHLIST SEARCHLIST)
      (LISTLENGTH LISTLENGTH)
      (RETURN-VALUE (XRMQGETSEARCHLIST* DB NAMES CLASSES SEARCHLIST LISTLENGTH)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XRMQGETSEARCHRESOURCE* INT INT INT POINTER POINTER)
  INT
  "XrmQGetSearchResource")
(DEFINE
  (XRMQGETSEARCHRESOURCE SEARCHLIST NAME CLASS)
  (LET*
    ((SEARCHLIST SEARCHLIST)
      (NAME NAME)
      (CLASS CLASS)
      (PTYPE (MAKE-STRING 4))
      (PVAL (MAKE-STRING 8))
      (RETURN-VALUE (XRMQGETSEARCHRESOURCE* SEARCHLIST NAME CLASS PTYPE PVAL)))
    (LIST RETURN-VALUE (C-INT-REF PTYPE 0) (CONS 'XRMVALUEPTR PVAL))))
(DEFINE-C-EXTERNAL
  (XRMMERGEDATABASES* POINTER POINTER)
  VOID
  "XrmMergeDatabases")
(DEFINE
  (XRMMERGEDATABASES NEW INTO)
  (LET*
    ((NEW (CHK-XRMDATABASE NEW))
      (INTO (CHK-XRMDATABASEP INTO))
      (RETURN-VALUE (BEGIN (XRMMERGEDATABASES* NEW INTO) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XRMGETFILEDATABASE* POINTER) POINTER "XrmGetFileDatabase")
(DEFINE
  (XRMGETFILEDATABASE FILENAME)
  (LET*
    ((FILENAME
       (IF
         (STRING? FILENAME)
         FILENAME
         (ERROR 'CHK-STRING "Argument is incorrect type: ~s" FILENAME)))
      (RETURN-VALUE (CONS 'XRMDATABASE (XRMGETFILEDATABASE* FILENAME))))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XRMPUTFILEDATABASE* POINTER POINTER)
  VOID
  "XrmPutFileDatabase")
(DEFINE
  (XRMPUTFILEDATABASE DB FILENAME)
  (LET*
    ((DB (CHK-XRMDATABASE DB))
      (FILENAME
        (IF
          (STRING? FILENAME)
          FILENAME
          (ERROR 'CHK-STRING "Argument is incorrect type: ~s" FILENAME)))
      (RETURN-VALUE (BEGIN (XRMPUTFILEDATABASE* DB FILENAME) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XRMGETSTRINGDATABASE* POINTER)
  POINTER
  "XrmGetStringDatabase")
(DEFINE
  (XRMGETSTRINGDATABASE DATA)
  (LET*
    ((DATA
       (IF
         (STRING? DATA)
         DATA
         (ERROR 'CHK-STRING "Argument is incorrect type: ~s" DATA)))
      (RETURN-VALUE (CONS 'XRMDATABASE (XRMGETSTRINGDATABASE* DATA))))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XRMPARSECOMMAND* POINTER POINTER INT POINTER POINTER POINTER)
  VOID
  "XrmParseCommand")
(DEFINE
  (XRMPARSECOMMAND PDB OPTIONS NUM_OPTIONS PREFIX ARGC ARGV)
  (LET*
    ((PDB (CHK-XRMDATABASEP PDB))
      (OPTIONS (CHK-XRMOPTIONDESCLIST OPTIONS))
      (NUM_OPTIONS NUM_OPTIONS)
      (PREFIX
        (IF
          (STRING? PREFIX)
          PREFIX
          (ERROR 'CHK-STRING "Argument is incorrect type: ~s" PREFIX)))
      (ARGC (CHK-INTP ARGC))
      (ARGV (CHK-CHARPAP ARGV))
      (RETURN-VALUE
        (BEGIN (XRMPARSECOMMAND* PDB OPTIONS NUM_OPTIONS PREFIX ARGC ARGV) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XSAVECONTEXT* POINTER UNSIGNED INT POINTER)
  INT
  "XSaveContext")
(DEFINE
  (XSAVECONTEXT DISPLAY WINDOW CONTEXT DATA)
  (LET*
    ((DISPLAY (CHK-DISPLAYP DISPLAY))
      (WINDOW WINDOW)
      (CONTEXT CONTEXT)
      (DATA (CHK-CHARAP DATA))
      (RETURN-VALUE (XSAVECONTEXT* DISPLAY WINDOW CONTEXT DATA)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XFINDCONTEXT* POINTER UNSIGNED INT POINTER)
  INT
  "XFindContext")
(DEFINE
  (XFINDCONTEXT DISPLAY WINDOW CONTEXT)
  (LET*
    ((DISPLAY (CHK-DISPLAYP DISPLAY))
      (WINDOW WINDOW)
      (CONTEXT CONTEXT)
      (DATA (MAKE-STRING 4))
      (RETURN-VALUE (XFINDCONTEXT* DISPLAY WINDOW CONTEXT DATA)))
    (LIST RETURN-VALUE (CONS 'CHARAP (C-UNSIGNED-REF DATA 0)))))
(DEFINE-C-EXTERNAL (XDELETECONTEXT* POINTER UNSIGNED INT) INT "XDeleteContext")
(DEFINE
  (XDELETECONTEXT DISPLAY WINDOW CONTEXT)
  (LET*
    ((DISPLAY (CHK-DISPLAYP DISPLAY))
      (WINDOW WINDOW)
      (CONTEXT CONTEXT)
      (RETURN-VALUE (XDELETECONTEXT* DISPLAY WINDOW CONTEXT)))
    RETURN-VALUE))
