/* SCHEME->C */

/*              Copyright 1989 Digital Equipment Corporation
 *                         All Rights Reserved
 *
 * Permission to use, copy, and modify this software and its documentation is
 * hereby granted only under the following terms and conditions.  Both the
 * above copyright notice and this permission notice must appear in all copies
 * of the software, derivative works or modified versions, and any portions
 * thereof, and both notices must appear in supporting documentation.
 *
 * Users of this software agree to the terms and conditions set forth herein,
 * and hereby grant back to Digital a non-exclusive, unrestricted, royalty-free
 * right and license under any changes, enhancements or extensions made to the
 * core functions of the software, including but not limited to those affording
 * compatibility with other hardware or software environments, but excluding
 * applications which incorporate this software.  Users further agree to use
 * their best efforts to return to Digital any such changes, enhancements or
 * extensions that they make and inform Digital of noteworthy uses of this
 * software.  Correspondence should be provided to Digital at:
 * 
 *                       Director of Licensing
 *                       Western Research Laboratory
 *                       Digital Equipment Corporation
 *                       100 Hamilton Avenue
 *                       Palo Alto, California  94301  
 * 
 * This software may be distributed (but not offered for sale or transferred
 * for compensation) to third parties, provided such third parties agree to
 * abide by the terms and conditions of this notice.  
 * 
 * THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL EQUIPMENT
 * CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
*/

/* This module supplies functions to access C Library I/O macros. */

#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include "objects.h"

int  sc_libc_eof = EOF;

/*  feof(stream)  */

int sc_feof( stream )
	FILE *stream;
{
	return( feof( stream ) );
}

/*  ferror(stream)  */

int sc_ferror( stream )
	FILE *stream;
{
	return( ferror( stream ) );
}

/*  clearerr(stream)  */

sc_clearerr( stream )
	FILE *stream;
{
	clearerr( stream );
}

/*  fileno(stream)  */

int sc_fileno( stream )
	FILE *stream;
{
	return( fileno( stream ) );
}

/* The following function is a boolean which returns 1 when there are
   input characters ready, and 0 when none are available.
*/

int sc_inputchars( stream )
	FILE *stream;
{
	int  readfds, nfound;
	struct  timeval  timeout;
	
	if  (((stream)->_cnt) <= 0)  {
	   readfds = 1<<(fileno( stream ));
	   timeout.tv_sec = 0;
	   timeout.tv_usec = 0;
	   nfound = select( fileno( stream )+1, &readfds, 0, 0, &timeout );
	   if  (nfound == 0)  return( 0 );
	}
	return( 1 );
}

/* The following boolean returns 1 if there are characters buffered for the
   stream, 0 otherwise.
*/

int  sc_bufferedchars( stream )
	FILE *stream;
{
	if  (((stream)->_cnt) > 0)
	   return( 1 );
	else
	   return( 0 );
}
