(module XLIBTYPES)

(DEFINE
  (CHK-UNSIGNEDAP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'UNSIGNEDAP))
    (CDR X)
    (ERROR 'CHK-UNSIGNEDAP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-UNSIGNEDAP? X) (AND (PAIR? X) (EQ? (CAR X) 'UNSIGNEDAP)))
(DEFINE (UNSIGNEDA-LENGTH X) (QUOTIENT (STRING-LENGTH (CHK-UNSIGNEDAP X)) 4))
(DEFINE
  (UNSIGNEDA X I)
  ((LAMBDA (X Y I) (C-UNSIGNED-REF X (+ Y (* 4 I)))) (CHK-UNSIGNEDAP X) 0 I))
(DEFINE
  (UNSIGNEDA->UNSIGNED-LIST X)
  (LET
    LOOP
    ((I 0) (COUNT (UNSIGNEDA-LENGTH X)))
    (IF (EQ? I COUNT) '() (CONS (UNSIGNEDA X I) (LOOP (+ I 1) COUNT)))))
(DEFINE
  (UNSIGNED-LIST->UNSIGNEDA L)
  (LET
    LOOP
    ((L L) (I 0) (A (MAKE-UNSIGNEDA (LENGTH L))))
    (IF L (BEGIN (UNSIGNEDA! A I (CAR L)) (LOOP (CDR L) (+ I 1) A)) A)))
(DEFINE
  (UNSIGNEDA! X I Z)
  ((LAMBDA (X Y I Z) (C-UNSIGNED-SET! X (+ Y (* 4 I)) ((LAMBDA (X) X) Z)))
    (CHK-UNSIGNEDAP X)
    0
    I
    Z))
(DEFINE
  (MAKE-UNSIGNEDA X)
  (CONS 'UNSIGNEDAP (MAKE-STRING (* 4 X) (INTEGER->CHAR 0))))
(DEFINE
  (CHK-UNSIGNEDPROC X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'UNSIGNEDPROC))
    (CDR X)
    (ERROR 'CHK-UNSIGNEDPROC "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-UNSIGNEDPROC? X)
  (AND (PAIR? X) (EQ? (CAR X) 'UNSIGNEDPROC)))
(DEFINE
  (CHK-CHARP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'CHARP))
    (CDR X)
    (ERROR 'CHK-CHARP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-CHARP? X) (AND (PAIR? X) (EQ? (CAR X) 'CHARP)))
(DEFINE
  (CHK-CHARAP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'CHARAP))
    (CDR X)
    (ERROR 'CHK-CHARAP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-CHARAP? X) (AND (PAIR? X) (EQ? (CAR X) 'CHARAP)))
(DEFINE (CHARA-LENGTH X) (QUOTIENT (STRING-LENGTH (CHK-CHARAP X)) 1))
(DEFINE
  (CHARA X I)
  ((LAMBDA (X Y I) (C-BYTE-REF X (+ Y (* 1 I)))) (CHK-CHARAP X) 0 I))
(DEFINE
  (CHARA->CHAR-LIST X)
  (LET
    LOOP
    ((I 0) (COUNT (CHARA-LENGTH X)))
    (IF (EQ? I COUNT) '() (CONS (CHARA X I) (LOOP (+ I 1) COUNT)))))
(DEFINE
  (CHAR-LIST->CHARA L)
  (LET
    LOOP
    ((L L) (I 0) (A (MAKE-CHARA (LENGTH L))))
    (IF L (BEGIN (CHARA! A I (CAR L)) (LOOP (CDR L) (+ I 1) A)) A)))
(DEFINE
  (CHARA! X I Z)
  ((LAMBDA (X Y I Z) (C-BYTE-SET! X (+ Y (* 1 I)) ((LAMBDA (X) X) Z)))
    (CHK-CHARAP X)
    0
    I
    Z))
(DEFINE
  (MAKE-CHARA X)
  (CONS 'CHARAP (MAKE-STRING (* 1 X) (INTEGER->CHAR 0))))
(DEFINE
  (CHK-CHARPAP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'CHARPAP))
    (CDR X)
    (ERROR 'CHK-CHARPAP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-CHARPAP? X) (AND (PAIR? X) (EQ? (CAR X) 'CHARPAP)))
(DEFINE (CHARPA-LENGTH X) (QUOTIENT (STRING-LENGTH (CHK-CHARPAP X)) 4))
(DEFINE
  (CHARPA X I)
  ((LAMBDA
     (X Y I)
     ((LAMBDA (X Y) (CONS 'CHARP (C-UNSIGNED-REF X Y))) X (+ Y (* 4 I))))
    (CHK-CHARPAP X)
    0
    I))
(DEFINE
  (CHARPA->CHARP-LIST X)
  (LET
    LOOP
    ((I 0) (COUNT (CHARPA-LENGTH X)))
    (IF (EQ? I COUNT) '() (CONS (CHARPA X I) (LOOP (+ I 1) COUNT)))))
(DEFINE
  (CHARP-LIST->CHARPA L)
  (LET
    LOOP
    ((L L) (I 0) (A (MAKE-CHARPA (LENGTH L))))
    (IF L (BEGIN (CHARPA! A I (CAR L)) (LOOP (CDR L) (+ I 1) A)) A)))
(DEFINE
  (CHARPA! X I Z)
  ((LAMBDA
     (X Y I Z)
     ((LAMBDA (X Y Z) (C-UNSIGNED-SET! X Y (CHK-CHARP Z)))
       X
       (+ Y (* 4 I))
       (CHK-CHARP Z)))
    (CHK-CHARPAP X)
    0
    I
    Z))
(DEFINE
  (MAKE-CHARPA X)
  (CONS 'CHARPAP (MAKE-STRING (* 4 X) (INTEGER->CHAR 0))))
(DEFINE
  (CHK-INTPROC X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'INTPROC))
    (CDR X)
    (ERROR 'CHK-INTPROC "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-INTPROC? X) (AND (PAIR? X) (EQ? (CAR X) 'INTPROC)))
(DEFINE
  (CHK-INTP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'INTP))
    (CDR X)
    (ERROR 'CHK-INTP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-INTP? X) (AND (PAIR? X) (EQ? (CAR X) 'INTP)))
(DEFINE
  (CHK-INTAP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'INTAP))
    (CDR X)
    (ERROR 'CHK-INTAP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-INTAP? X) (AND (PAIR? X) (EQ? (CAR X) 'INTAP)))
(DEFINE (INTA-LENGTH X) (QUOTIENT (STRING-LENGTH (CHK-INTAP X)) 4))
(DEFINE
  (INTA X I)
  ((LAMBDA (X Y I) (C-INT-REF X (+ Y (* 4 I)))) (CHK-INTAP X) 0 I))
(DEFINE
  (INTA->INT-LIST X)
  (LET
    LOOP
    ((I 0) (COUNT (INTA-LENGTH X)))
    (IF (EQ? I COUNT) '() (CONS (INTA X I) (LOOP (+ I 1) COUNT)))))
(DEFINE
  (INT-LIST->INTA L)
  (LET
    LOOP
    ((L L) (I 0) (A (MAKE-INTA (LENGTH L))))
    (IF L (BEGIN (INTA! A I (CAR L)) (LOOP (CDR L) (+ I 1) A)) A)))
(DEFINE
  (INTA! X I Z)
  ((LAMBDA (X Y I Z) (C-INT-SET! X (+ Y (* 4 I)) ((LAMBDA (X) X) Z)))
    (CHK-INTAP X)
    0
    I
    Z))
(DEFINE
  (MAKE-INTA X)
  (CONS 'INTAP (MAKE-STRING (* 4 X) (INTEGER->CHAR 0))))
(DEFINE
  (CHK-BOOLPROC X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'BOOLPROC))
    (CDR X)
    (ERROR 'CHK-BOOLPROC "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-BOOLPROC? X) (AND (PAIR? X) (EQ? (CAR X) 'BOOLPROC)))
(DEFINE
  (CHK-XEXTDATAP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XEXTDATAP))
    (CDR X)
    (ERROR 'CHK-XEXTDATAP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XEXTDATAP? X) (AND (PAIR? X) (EQ? (CAR X) 'XEXTDATAP)))
(DEFINE
  (CHK-XGCVALUESP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XGCVALUESP))
    (CDR X)
    (ERROR 'CHK-XGCVALUESP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XGCVALUESP? X) (AND (PAIR? X) (EQ? (CAR X) 'XGCVALUESP)))
(DEFINE
  (CHK-GC X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'GC))
    (CDR X)
    (ERROR 'CHK-GC "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-GC? X) (AND (PAIR? X) (EQ? (CAR X) 'GC)))
(DEFINE
  (CHK-VISUALP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'VISUALP))
    (CDR X)
    (ERROR 'CHK-VISUALP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-VISUALP? X) (AND (PAIR? X) (EQ? (CAR X) 'VISUALP)))
(DEFINE
  (CHK-DEPTHP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'DEPTHP))
    (CDR X)
    (ERROR 'CHK-DEPTHP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-DEPTHP? X) (AND (PAIR? X) (EQ? (CAR X) 'DEPTHP)))
(DEFINE
  (CHK-SCREENP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'SCREENP))
    (CDR X)
    (ERROR 'CHK-SCREENP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-SCREENP? X) (AND (PAIR? X) (EQ? (CAR X) 'SCREENP)))
(DEFINE
  (CHK-XSETWINDOWATTRIBUTESP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XSETWINDOWATTRIBUTESP))
    (CDR X)
    (ERROR 'CHK-XSETWINDOWATTRIBUTESP "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-XSETWINDOWATTRIBUTESP? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XSETWINDOWATTRIBUTESP)))
(DEFINE
  (CHK-XWINDOWATTRIBUTESP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XWINDOWATTRIBUTESP))
    (CDR X)
    (ERROR 'CHK-XWINDOWATTRIBUTESP "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-XWINDOWATTRIBUTESP? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XWINDOWATTRIBUTESP)))
(DEFINE
  (CHK-XHOSTADDRESSP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XHOSTADDRESSP))
    (CDR X)
    (ERROR 'CHK-XHOSTADDRESSP "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-XHOSTADDRESSP? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XHOSTADDRESSP)))
(DEFINE
  (CHK-XHOSTADDRESSAP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XHOSTADDRESSAP))
    (CDR X)
    (ERROR 'CHK-XHOSTADDRESSAP "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-XHOSTADDRESSAP? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XHOSTADDRESSAP)))
(DEFINE
  (XHOSTADDRESSA-LENGTH X)
  (QUOTIENT (STRING-LENGTH (CHK-XHOSTADDRESSAP X)) 12))
(DEFINE
  (XHOSTADDRESSA->XHOSTADDRESS-LIST X)
  (LET*
    ((ARRAY (CHK-XHOSTADDRESSAP X)) (ASIZE (STRING-LENGTH ARRAY)) (ESIZE 12))
    (LET
      LOOP
      ((X 0))
      (IF
        (EQ? X ASIZE)
        '()
        (CONS
          (CONS 'XHOSTADDRESSP (SUBSTRING ARRAY X (+ X ESIZE)))
          (LOOP (+ X ESIZE)))))))
(DEFINE
  (XHOSTADDRESS-LIST->XHOSTADDRESSA X)
  (CONS 'XHOSTADDRESSAP (APPLY STRING-APPEND (MAP CHK-XHOSTADDRESSP X))))
(DEFINE
  (CHK-XIMAGEP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XIMAGEP))
    (CDR X)
    (ERROR 'CHK-XIMAGEP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XIMAGEP? X) (AND (PAIR? X) (EQ? (CAR X) 'XIMAGEP)))
(DEFINE
  (CHK-XIMAGEPROC X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XIMAGEPROC))
    (CDR X)
    (ERROR 'CHK-XIMAGEPROC "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XIMAGEPROC? X) (AND (PAIR? X) (EQ? (CAR X) 'XIMAGEPROC)))
(DEFINE
  (CHK-XWINDOWCHANGESP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XWINDOWCHANGESP))
    (CDR X)
    (ERROR 'CHK-XWINDOWCHANGESP "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-XWINDOWCHANGESP? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XWINDOWCHANGESP)))
(DEFINE
  (CHK-XCOLORP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XCOLORP))
    (CDR X)
    (ERROR 'CHK-XCOLORP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XCOLORP? X) (AND (PAIR? X) (EQ? (CAR X) 'XCOLORP)))
(DEFINE
  (CHK-XCOLORAP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XCOLORAP))
    (CDR X)
    (ERROR 'CHK-XCOLORAP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XCOLORAP? X) (AND (PAIR? X) (EQ? (CAR X) 'XCOLORAP)))
(DEFINE (XCOLORA-LENGTH X) (QUOTIENT (STRING-LENGTH (CHK-XCOLORAP X)) 12))
(DEFINE
  (XCOLORA->XCOLOR-LIST X)
  (LET*
    ((ARRAY (CHK-XCOLORAP X)) (ASIZE (STRING-LENGTH ARRAY)) (ESIZE 12))
    (LET
      LOOP
      ((X 0))
      (IF
        (EQ? X ASIZE)
        '()
        (CONS
          (CONS 'XCOLORP (SUBSTRING ARRAY X (+ X ESIZE)))
          (LOOP (+ X ESIZE)))))))
(DEFINE
  (XCOLOR-LIST->XCOLORA X)
  (CONS 'XCOLORAP (APPLY STRING-APPEND (MAP CHK-XCOLORP X))))
(DEFINE
  (CHK-XSEGMENTP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XSEGMENTP))
    (CDR X)
    (ERROR 'CHK-XSEGMENTP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XSEGMENTP? X) (AND (PAIR? X) (EQ? (CAR X) 'XSEGMENTP)))
(DEFINE
  (CHK-XSEGMENTAP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XSEGMENTAP))
    (CDR X)
    (ERROR 'CHK-XSEGMENTAP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XSEGMENTAP? X) (AND (PAIR? X) (EQ? (CAR X) 'XSEGMENTAP)))
(DEFINE (XSEGMENTA-LENGTH X) (QUOTIENT (STRING-LENGTH (CHK-XSEGMENTAP X)) 8))
(DEFINE
  (XSEGMENTA->XSEGMENT-LIST X)
  (LET*
    ((ARRAY (CHK-XSEGMENTAP X)) (ASIZE (STRING-LENGTH ARRAY)) (ESIZE 8))
    (LET
      LOOP
      ((X 0))
      (IF
        (EQ? X ASIZE)
        '()
        (CONS
          (CONS 'XSEGMENTP (SUBSTRING ARRAY X (+ X ESIZE)))
          (LOOP (+ X ESIZE)))))))
(DEFINE
  (XSEGMENT-LIST->XSEGMENTA X)
  (CONS 'XSEGMENTAP (APPLY STRING-APPEND (MAP CHK-XSEGMENTP X))))
(DEFINE
  (CHK-XPOINTP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XPOINTP))
    (CDR X)
    (ERROR 'CHK-XPOINTP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XPOINTP? X) (AND (PAIR? X) (EQ? (CAR X) 'XPOINTP)))
(DEFINE
  (CHK-XPOINTAP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XPOINTAP))
    (CDR X)
    (ERROR 'CHK-XPOINTAP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XPOINTAP? X) (AND (PAIR? X) (EQ? (CAR X) 'XPOINTAP)))
(DEFINE (XPOINTA-LENGTH X) (QUOTIENT (STRING-LENGTH (CHK-XPOINTAP X)) 4))
(DEFINE
  (XPOINTA->XPOINT-LIST X)
  (LET*
    ((ARRAY (CHK-XPOINTAP X)) (ASIZE (STRING-LENGTH ARRAY)) (ESIZE 4))
    (LET
      LOOP
      ((X 0))
      (IF
        (EQ? X ASIZE)
        '()
        (CONS
          (CONS 'XPOINTP (SUBSTRING ARRAY X (+ X ESIZE)))
          (LOOP (+ X ESIZE)))))))
(DEFINE
  (XPOINT-LIST->XPOINTA X)
  (CONS 'XPOINTAP (APPLY STRING-APPEND (MAP CHK-XPOINTP X))))
(DEFINE
  (CHK-XRECTANGLEP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XRECTANGLEP))
    (CDR X)
    (ERROR 'CHK-XRECTANGLEP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XRECTANGLEP? X) (AND (PAIR? X) (EQ? (CAR X) 'XRECTANGLEP)))
(DEFINE
  (CHK-XRECTANGLEAP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XRECTANGLEAP))
    (CDR X)
    (ERROR 'CHK-XRECTANGLEAP "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-XRECTANGLEAP? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XRECTANGLEAP)))
(DEFINE
  (XRECTANGLEA-LENGTH X)
  (QUOTIENT (STRING-LENGTH (CHK-XRECTANGLEAP X)) 8))
(DEFINE
  (XRECTANGLEA->XRECTANGLE-LIST X)
  (LET*
    ((ARRAY (CHK-XRECTANGLEAP X)) (ASIZE (STRING-LENGTH ARRAY)) (ESIZE 8))
    (LET
      LOOP
      ((X 0))
      (IF
        (EQ? X ASIZE)
        '()
        (CONS
          (CONS 'XRECTANGLEP (SUBSTRING ARRAY X (+ X ESIZE)))
          (LOOP (+ X ESIZE)))))))
(DEFINE
  (XRECTANGLE-LIST->XRECTANGLEA X)
  (CONS 'XRECTANGLEAP (APPLY STRING-APPEND (MAP CHK-XRECTANGLEP X))))
(DEFINE
  (CHK-XARCP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XARCP))
    (CDR X)
    (ERROR 'CHK-XARCP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XARCP? X) (AND (PAIR? X) (EQ? (CAR X) 'XARCP)))
(DEFINE
  (CHK-XARCAP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XARCAP))
    (CDR X)
    (ERROR 'CHK-XARCAP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XARCAP? X) (AND (PAIR? X) (EQ? (CAR X) 'XARCAP)))
(DEFINE (XARCA-LENGTH X) (QUOTIENT (STRING-LENGTH (CHK-XARCAP X)) 12))
(DEFINE
  (XARCA->XARC-LIST X)
  (LET*
    ((ARRAY (CHK-XARCAP X)) (ASIZE (STRING-LENGTH ARRAY)) (ESIZE 12))
    (LET
      LOOP
      ((X 0))
      (IF
        (EQ? X ASIZE)
        '()
        (CONS
          (CONS 'XARCP (SUBSTRING ARRAY X (+ X ESIZE)))
          (LOOP (+ X ESIZE)))))))
(DEFINE
  (XARC-LIST->XARCA X)
  (CONS 'XARCAP (APPLY STRING-APPEND (MAP CHK-XARCP X))))
(DEFINE
  (CHK-XKEYBOARDCONTROLP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XKEYBOARDCONTROLP))
    (CDR X)
    (ERROR 'CHK-XKEYBOARDCONTROLP "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-XKEYBOARDCONTROLP? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XKEYBOARDCONTROLP)))
(DEFINE
  (CHK-XKEYBOARDSTATEP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XKEYBOARDSTATEP))
    (CDR X)
    (ERROR 'CHK-XKEYBOARDSTATEP "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-XKEYBOARDSTATEP? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XKEYBOARDSTATEP)))
(DEFINE
  (CHK-XQKEYMAPP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XQKEYMAPP))
    (CDR X)
    (ERROR 'CHK-XQKEYMAPP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XQKEYMAPP? X) (AND (PAIR? X) (EQ? (CAR X) 'XQKEYMAPP)))
(DEFINE (XQKEYMAP-LENGTH X) (QUOTIENT (STRING-LENGTH (CHK-XQKEYMAPP X)) 1))
(DEFINE
  (XQKEYMAP X I)
  ((LAMBDA (X Y I) (C-BYTE-REF X (+ Y (* 1 I)))) (CHK-XQKEYMAPP X) 0 I))
(DEFINE
  (XQKEYMAP->CHAR-LIST X)
  (LET
    LOOP
    ((I 0) (COUNT (XQKEYMAP-LENGTH X)))
    (IF (EQ? I COUNT) '() (CONS (XQKEYMAP X I) (LOOP (+ I 1) COUNT)))))
(DEFINE
  (CHAR-LIST->XQKEYMAP L)
  (LET
    LOOP
    ((L L) (I 0) (A (MAKE-XQKEYMAP)))
    (IF L (BEGIN (XQKEYMAP! A I (CAR L)) (LOOP (CDR L) (+ I 1) A)) A)))
(DEFINE
  (XQKEYMAP! X I Z)
  ((LAMBDA (X Y I Z) (C-BYTE-SET! X (+ Y (* 1 I)) ((LAMBDA (X) X) Z)))
    (CHK-XQKEYMAPP X)
    0
    I
    Z))
(DEFINE
  (MAKE-XQKEYMAP)
  (CONS 'XQKEYMAPP (MAKE-STRING (* 1 32) (INTEGER->CHAR 0))))
(DEFINE
  (CHK-XTIMECOORDP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XTIMECOORDP))
    (CDR X)
    (ERROR 'CHK-XTIMECOORDP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XTIMECOORDP? X) (AND (PAIR? X) (EQ? (CAR X) 'XTIMECOORDP)))
(DEFINE
  (CHK-XTIMECOORDAP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XTIMECOORDAP))
    (CDR X)
    (ERROR 'CHK-XTIMECOORDAP "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-XTIMECOORDAP? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XTIMECOORDAP)))
(DEFINE
  (XTIMECOORDA-LENGTH X)
  (QUOTIENT (STRING-LENGTH (CHK-XTIMECOORDAP X)) 8))
(DEFINE
  (XTIMECOORDA->XTIMECOORD-LIST X)
  (LET*
    ((ARRAY (CHK-XTIMECOORDAP X)) (ASIZE (STRING-LENGTH ARRAY)) (ESIZE 8))
    (LET
      LOOP
      ((X 0))
      (IF
        (EQ? X ASIZE)
        '()
        (CONS
          (CONS 'XTIMECOORDP (SUBSTRING ARRAY X (+ X ESIZE)))
          (LOOP (+ X ESIZE)))))))
(DEFINE
  (XTIMECOORD-LIST->XTIMECOORDA X)
  (CONS 'XTIMECOORDAP (APPLY STRING-APPEND (MAP CHK-XTIMECOORDP X))))
(DEFINE
  (CHK-XMODIFIERKEYMAPP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XMODIFIERKEYMAPP))
    (CDR X)
    (ERROR 'CHK-XMODIFIERKEYMAPP "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-XMODIFIERKEYMAPP? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XMODIFIERKEYMAPP)))
(DEFINE
  (CHK-XNEWMODIFIERMAP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XNEWMODIFIERMAP))
    (CDR X)
    (ERROR 'CHK-XNEWMODIFIERMAP "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-XNEWMODIFIERMAP? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XNEWMODIFIERMAP)))
(DEFINE
  (CHK-XGETMODIFIERMAPPING X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XGETMODIFIERMAPPING))
    (CDR X)
    (ERROR 'CHK-XGETMODIFIERMAPPING "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-XGETMODIFIERMAPPING? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XGETMODIFIERMAPPING)))
(DEFINE
  (CHK-XDELETEMODIFIERMAPENTRY X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XDELETEMODIFIERMAPENTRY))
    (CDR X)
    (ERROR
      'CHK-XDELETEMODIFIERMAPENTRY
      "Argument is incorrect type: ~s"
      X)))
(DEFINE
  (ISA-XDELETEMODIFIERMAPENTRY? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XDELETEMODIFIERMAPENTRY)))
(DEFINE
  (CHK-XINSERTMODIFIERMAPENTRY X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XINSERTMODIFIERMAPENTRY))
    (CDR X)
    (ERROR
      'CHK-XINSERTMODIFIERMAPENTRY
      "Argument is incorrect type: ~s"
      X)))
(DEFINE
  (ISA-XINSERTMODIFIERMAPENTRY? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XINSERTMODIFIERMAPENTRY)))
(DEFINE
  (CHK-DISPLAYP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'DISPLAYP))
    (CDR X)
    (ERROR 'CHK-DISPLAYP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-DISPLAYP? X) (AND (PAIR? X) (EQ? (CAR X) 'DISPLAYP)))
(DEFINE
  (CHK-XEVENTP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XEVENTP))
    (CDR X)
    (ERROR 'CHK-XEVENTP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XEVENTP? X) (AND (PAIR? X) (EQ? (CAR X) 'XEVENTP)))
(DEFINE
  (CHK-XCHARSTRUCTP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XCHARSTRUCTP))
    (CDR X)
    (ERROR 'CHK-XCHARSTRUCTP "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-XCHARSTRUCTP? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XCHARSTRUCTP)))
(DEFINE
  (CHK-XFONTPROPP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XFONTPROPP))
    (CDR X)
    (ERROR 'CHK-XFONTPROPP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XFONTPROPP? X) (AND (PAIR? X) (EQ? (CAR X) 'XFONTPROPP)))
(DEFINE
  (CHK-XFONTSTRUCTP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XFONTSTRUCTP))
    (CDR X)
    (ERROR 'CHK-XFONTSTRUCTP "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-XFONTSTRUCTP? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XFONTSTRUCTP)))
(DEFINE
  (CHK-XFONTSTRUCTAP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XFONTSTRUCTAP))
    (CDR X)
    (ERROR 'CHK-XFONTSTRUCTAP "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-XFONTSTRUCTAP? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XFONTSTRUCTAP)))
(DEFINE
  (XFONTSTRUCTA-LENGTH X)
  (QUOTIENT (STRING-LENGTH (CHK-XFONTSTRUCTAP X)) 80))
(DEFINE
  (XFONTSTRUCTA->XFONTSTRUCT-LIST X)
  (LET*
    ((ARRAY (CHK-XFONTSTRUCTAP X)) (ASIZE (STRING-LENGTH ARRAY)) (ESIZE 80))
    (LET
      LOOP
      ((X 0))
      (IF
        (EQ? X ASIZE)
        '()
        (CONS
          (CONS 'XFONTSTRUCTP (SUBSTRING ARRAY X (+ X ESIZE)))
          (LOOP (+ X ESIZE)))))))
(DEFINE
  (XFONTSTRUCT-LIST->XFONTSTRUCTA X)
  (CONS 'XFONTSTRUCTAP (APPLY STRING-APPEND (MAP CHK-XFONTSTRUCTP X))))
(DEFINE
  (CHK-XTEXTITEMP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XTEXTITEMP))
    (CDR X)
    (ERROR 'CHK-XTEXTITEMP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XTEXTITEMP? X) (AND (PAIR? X) (EQ? (CAR X) 'XTEXTITEMP)))
(DEFINE
  (CHK-XTEXTITEMAP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XTEXTITEMAP))
    (CDR X)
    (ERROR 'CHK-XTEXTITEMAP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XTEXTITEMAP? X) (AND (PAIR? X) (EQ? (CAR X) 'XTEXTITEMAP)))
(DEFINE (XTEXTITEMA-LENGTH X) (QUOTIENT (STRING-LENGTH (CHK-XTEXTITEMAP X)) 16))
(DEFINE
  (XTEXTITEMA->XTEXTITEM-LIST X)
  (LET*
    ((ARRAY (CHK-XTEXTITEMAP X)) (ASIZE (STRING-LENGTH ARRAY)) (ESIZE 16))
    (LET
      LOOP
      ((X 0))
      (IF
        (EQ? X ASIZE)
        '()
        (CONS
          (CONS 'XTEXTITEMP (SUBSTRING ARRAY X (+ X ESIZE)))
          (LOOP (+ X ESIZE)))))))
(DEFINE
  (XTEXTITEM-LIST->XTEXTITEMA X)
  (CONS 'XTEXTITEMAP (APPLY STRING-APPEND (MAP CHK-XTEXTITEMP X))))
(DEFINE
  (CHK-XCHAR2BP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XCHAR2BP))
    (CDR X)
    (ERROR 'CHK-XCHAR2BP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XCHAR2BP? X) (AND (PAIR? X) (EQ? (CAR X) 'XCHAR2BP)))
(DEFINE
  (CHK-XCHAR2BAP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XCHAR2BAP))
    (CDR X)
    (ERROR 'CHK-XCHAR2BAP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XCHAR2BAP? X) (AND (PAIR? X) (EQ? (CAR X) 'XCHAR2BAP)))
(DEFINE (XCHAR2BA-LENGTH X) (QUOTIENT (STRING-LENGTH (CHK-XCHAR2BAP X)) 2))
(DEFINE
  (XCHAR2BA->XCHAR2B-LIST X)
  (LET*
    ((ARRAY (CHK-XCHAR2BAP X)) (ASIZE (STRING-LENGTH ARRAY)) (ESIZE 2))
    (LET
      LOOP
      ((X 0))
      (IF
        (EQ? X ASIZE)
        '()
        (CONS
          (CONS 'XCHAR2BP (SUBSTRING ARRAY X (+ X ESIZE)))
          (LOOP (+ X ESIZE)))))))
(DEFINE
  (XCHAR2B-LIST->XCHAR2BA X)
  (CONS 'XCHAR2BAP (APPLY STRING-APPEND (MAP CHK-XCHAR2BP X))))
(DEFINE
  (CHK-XTEXTITEM16P X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XTEXTITEM16P))
    (CDR X)
    (ERROR 'CHK-XTEXTITEM16P "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-XTEXTITEM16P? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XTEXTITEM16P)))
(DEFINE
  (CHK-XRMVALUEPTR X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XRMVALUEPTR))
    (CDR X)
    (ERROR 'CHK-XRMVALUEPTR "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XRMVALUEPTR? X) (AND (PAIR? X) (EQ? (CAR X) 'XRMVALUEPTR)))
(DEFINE
  (CHK-XRMHASHBUCKET X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XRMHASHBUCKET))
    (CDR X)
    (ERROR 'CHK-XRMHASHBUCKET "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-XRMHASHBUCKET? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XRMHASHBUCKET)))
(DEFINE
  (CHK-XRMHASHTABLE X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XRMHASHTABLE))
    (CDR X)
    (ERROR 'CHK-XRMHASHTABLE "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-XRMHASHTABLE? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XRMHASHTABLE)))
(DEFINE
  (CHK-XRMDATABASE X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XRMDATABASE))
    (CDR X)
    (ERROR 'CHK-XRMDATABASE "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XRMDATABASE? X) (AND (PAIR? X) (EQ? (CAR X) 'XRMDATABASE)))
(DEFINE
  (CHK-XRMDATABASEP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XRMDATABASEP))
    (CDR X)
    (ERROR 'CHK-XRMDATABASEP "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-XRMDATABASEP? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XRMDATABASEP)))
(DEFINE
  (CHK-XRMOPTIONDESCLIST X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XRMOPTIONDESCLIST))
    (CDR X)
    (ERROR 'CHK-XRMOPTIONDESCLIST "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-XRMOPTIONDESCLIST? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XRMOPTIONDESCLIST)))
(DEFINE
  (CHK-XSIZEHINTSP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XSIZEHINTSP))
    (CDR X)
    (ERROR 'CHK-XSIZEHINTSP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XSIZEHINTSP? X) (AND (PAIR? X) (EQ? (CAR X) 'XSIZEHINTSP)))
(DEFINE
  (CHK-XWMHINTSP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XWMHINTSP))
    (CDR X)
    (ERROR 'CHK-XWMHINTSP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XWMHINTSP? X) (AND (PAIR? X) (EQ? (CAR X) 'XWMHINTSP)))
(DEFINE
  (CHK-XICONSIZEP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XICONSIZEP))
    (CDR X)
    (ERROR 'CHK-XICONSIZEP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XICONSIZEP? X) (AND (PAIR? X) (EQ? (CAR X) 'XICONSIZEP)))
(DEFINE
  (CHK-XCLASSHINTP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XCLASSHINTP))
    (CDR X)
    (ERROR 'CHK-XCLASSHINTP "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-XCLASSHINTP? X) (AND (PAIR? X) (EQ? (CAR X) 'XCLASSHINTP)))
(DEFINE
  (CHK-XCOMPOSESTATUSP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XCOMPOSESTATUSP))
    (CDR X)
    (ERROR 'CHK-XCOMPOSESTATUSP "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-XCOMPOSESTATUSP? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XCOMPOSESTATUSP)))
(DEFINE
  (CHK-REGION X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'REGION))
    (CDR X)
    (ERROR 'CHK-REGION "Argument is incorrect type: ~s" X)))
(DEFINE (ISA-REGION? X) (AND (PAIR? X) (EQ? (CAR X) 'REGION)))
(DEFINE
  (CHK-XVISUALINFOP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XVISUALINFOP))
    (CDR X)
    (ERROR 'CHK-XVISUALINFOP "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-XVISUALINFOP? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XVISUALINFOP)))
(DEFINE
  (CHK-XSTANDARDCOLORMAPP X)
  (IF
    (AND (PAIR? X) (EQ? (CAR X) 'XSTANDARDCOLORMAPP))
    (CDR X)
    (ERROR 'CHK-XSTANDARDCOLORMAPP "Argument is incorrect type: ~s" X)))
(DEFINE
  (ISA-XSTANDARDCOLORMAPP? X)
  (AND (PAIR? X) (EQ? (CAR X) 'XSTANDARDCOLORMAPP)))
