/* Scheme implementation intended for JACAL.
   Copyright (C) 1989, 1990 Aubrey Jaffer.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

The author can be reached at jaffer@ai.mit.edu or
Aubrey Jaffer, 84 Pleasant St., Wakefield MA 01880
*/

#include "scm.h"
 
SCM s_cxr;
SCM s_eval;
SCM s_apply, s_map, s_foreach;
 
SCM eval_args(l,env)
SCM l,env;
{
	SCM res = EOL,*lloc = &res;
	while NIMP(l) {
		*lloc = cons(EVAL(CAR(l),env),EOL);
		lloc = &CDR(*lloc);
		l = CDR(l);
	}
	return res;
}
 
#define EXTEND_ENV(formals,actuals,env) cons(cons(formals,actuals),env)
 
SCM *envlookup(var,env)
SCM var,env;
{
	register SCM al,fl;
	for(;NIMP(env);env = CDR(env)) {
		al = CAR(env);
		fl = CAR(al);
		while(NIMP(fl)) {
			if NCONSP(fl)
			  if (fl == var) return &CDR(al);
			  else break;
			al = CDR(al);
			if (CAR(fl) == var) return &CAR(al);
			fl = CDR(fl);
		}
	}
	ASSERT(NULLP(env),env,"damaged env",s_eval);
	return 0;
}
 
SCM iqq(form, env, depth)
SCM form, env;
int depth;
{
  SCM tmp;
  int edepth = depth;
  if IMP(form) return form;
  if VECTORP(form) {
    register long i = LENGTH(form);
    register SCM *data = VELTS(form);
    tmp = EOL;
    for(;--i>=0;) tmp = cons(data[i],tmp);
    return vector(iqq(tmp,env,depth));
  }
  if NCONSP(form) return form;
  tmp = CAR(form);
  if (tmp == s_quasiquote) {
    depth++;
    goto label;
  }
  if (tmp == s_unquote) {
    --depth;
  label:
    form = CDR(form);
    ASSERT(NIMP(form)&&CONSP(form)&&NULLP(CDR(form)),form,ARG1,s_quasiquote);
    if (depth == 0) return EVAL(CAR(form),env);
    return cons(tmp,cons(iqq(CAR(form),env,depth),EOL));
  }
  if (NIMP(tmp) && CONSP(tmp) && (CAR(tmp) == s_unquote_splicing)) {
    tmp = CAR(CDR(tmp));
    if (--edepth == 0)
      return append(cons(EVAL(tmp,env), cons(iqq(CDR(form),env,depth), EOL)));
  }
  return cons(iqq(CAR(form),env,edepth),iqq(CDR(form),env,depth));
}
 
SCM ceval(x,env)
SCM x,env;
{
  union {
    SCM *lloc;
    SCM arg1;
  } 
  t;
  SCM proc;
 loop:
  switch TYP6(x) {
  case tcs_symbols:
    t.lloc = envlookup(x,env);
    if (t.lloc) return *t.lloc;
    proc = VCELL(x);
    if UNBNDP(proc) err("unbound variable",x);
    return proc;
  case MAKISYM(0L):
    switch ISYMNUM(CAR(x)) {
    case ISYMNUM(s_and):
      x = CDR(x);
      if NULLP(x) return BOOL_T;
      t.arg1 = x;
      while(NNULLP(t.arg1 = CDR(t.arg1)))
	if FALSEP(EVAL(CAR(x),env)) return BOOL_F;
	else x = t.arg1;
      goto carloop;
    case ISYMNUM(s_begin):
      x = CDR(x);
    begin:
      t.arg1 = x;
      while(NNULLP(t.arg1 = CDR(t.arg1))) {
	SIDEVAL(CAR(x),env);
	x = t.arg1;
      }
    carloop:
      x = CAR(x);
      if IMP(x) return x;
      goto loop;
    case ISYMNUM(s_case):
      x = CDR(x);
      proc = EVAL(CAR(x),env);
      while(NIMP(x = CDR(x))) {
	ASSERT(CONSP(x),x,ARG1,s_case);
	t.arg1 = CAR(x);
	ASSERT(NIMP(t.arg1) &&
	       CONSP(t.arg1),t.arg1,ARG1,s_case);
	if ((s_else == CAR(t.arg1)) ||
	    NFALSEP(memq(proc,CAR(t.arg1)))) {
	  x = CDR(t.arg1);
	  goto begin;
	}
      }
      return UNSPECIFIED;
    case ISYMNUM(s_cond):
      x = CDR(x);
      while(NIMP(x)) {
	ASSERT(CONSP(x),x,ARG1,s_cond);
	t.arg1 = CAR(x);
	ASSERT(NIMP(t.arg1) &&
	       CONSP(t.arg1),t.arg1,ARG1,s_cond);
	t.arg1 = EVAL(CAR(t.arg1),env);
	if NFALSEP(t.arg1) {
	  x = CDR(CAR(x));
	  if NULLP(x) return t.arg1;
	  ASSERT(CONSP(x),x,ARG2,s_cond);
	  if (s_arrow != CAR(x)) goto begin;
	  x = CDR(x);
	  ASSERT(CONSP(x),x,ARG3,s_cond);
	  x = CAR(x);
	  x = EVAL(x,env);
	  return apply(x,t.arg1,listofnull);
	}
	x = CDR(x);
      }
      return UNSPECIFIED;
    case ISYMNUM(s_do):
      x = CDR(x);
      {
	SCM vars = EOL,inits = EOL;
	t.arg1 = CAR(x);
	while NIMP(t.arg1) {
	  ASSERT(CONSP(t.arg1),x,ARG1,s_do);
	  proc = CAR(t.arg1);
	  ASSERT(NIMP(proc) && CONSP(proc) &&
		 SYMBOLP(CAR(proc)),x,ARG1,s_do);
	  vars = cons(CAR(proc),vars);
	  proc = CDR(proc);
	  ASSERT(NIMP(proc) && CONSP(proc),
		 x,ARG1,s_do);
	  if IMP(CDR(proc))
	    CDR(proc) = cons(CAR(vars),EOL);
	  inits = cons(EVAL(CAR(proc),env),inits);
	  t.arg1 = CDR(t.arg1);
	}
	while (1) {
	  env = EXTEND_ENV(vars,inits,env);
	  t.arg1 = CDR(x);
	  proc = CAR(t.arg1);
	  if NFALSEP(EVAL(CAR(proc),env)) {
	    x = CDR(proc);
	    if NULLP(x) return UNSPECIFIED;
	    goto begin;
	  }
	  while NIMP(t.arg1 = CDR(t.arg1))
	    SIDEVAL(CAR(t.arg1),env);
	  inits = EOL;
	  t.arg1=CAR(x);
	  for(;NIMP(t.arg1);t.arg1=CDR(t.arg1)) {
	    proc=CAR(CDR(CDR(CAR(t.arg1))));
	    inits = cons(EVAL(proc,env),
			 inits);
	  }
	}
      }
    case ISYMNUM(s_if):
      x = CDR(x);
      if NFALSEP(EVAL(CAR(x),env)) x = CDR(x);
      else if IMP(x = CDR(CDR(x))) return UNSPECIFIED;
      goto carloop;
    case ISYMNUM(s_let):
      t.arg1 = CDR(x);
      if IMP(CAR(t.arg1)) {
      	x = CDR(x);
nullet:
	ASSERT(NULLP(CAR(x)),x,ARG1,s_let);
      	x = CDR(x);
      	ASSERT(NIMP(x),x,ARG2,s_let);
      	env = EXTEND_ENV(EOL,EOL,env);
      	goto begin;
      }
      if SYMBOLP(CAR(t.arg1)) t.arg1 = CAR(CDR(t.arg1));
      else t.arg1 = CAR(t.arg1);
      {
	SCM vars = CAR(t.arg1);
	while NIMP(t.arg1) {
	  proc = CAR(t.arg1);
	  CAR(t.arg1) = CAR(CDR(proc));
	  if IMP(CDR(t.arg1)) CDR(proc) = EOL;
	  else CDR(proc) = CAR(CDR(t.arg1));
	  t.arg1 = CDR(t.arg1);
	}
	if SYMBOLP(CAR(CDR(x))) {
	  CAR(x) = cons(s_lambda,
			cons(vars,
			     CDR(CDR(CDR(x)))));
	  CAR(x) = cons(s_letrec,
			cons(cons(cons(CAR(CDR(x)),
				       cons(CAR(x)),EOL),
				  EOL),
			     cons(CAR(CDR(x)),EOL)));
	  CDR(x) = CAR(CDR(CDR(x)));
	  goto loop;
	}
	CAR(x) = cons(s_lambda,cons(vars,CDR(CDR(x))));
	CDR(x) = CAR(CDR(x));
	goto loop;
      }
    case ISYMNUM(s_letstar):
      x = CDR(x);
      proc = CAR(x);
      if IMP(proc) goto nullet;
      while NIMP(proc) {
	ASSERT(CONSP(proc),x,ARG1,s_letstar);
	t.arg1 = CAR(proc);
	ASSERT(NIMP(proc) &&
	       CONSP(t.arg1) &&
	       CONSP(CDR(t.arg1)) &&
	       SYMBOLP(CAR(t.arg1)),x,ARG1,s_letstar);
	env = EXTEND_ENV(CAR(t.arg1),
			 EVAL(CAR(CDR(t.arg1)),env),
			 env);
	proc = CDR(proc);
      }
      x = CDR(x);
      goto begin;
    case ISYMNUM(s_letrec):
      x = CDR(x);
      proc = CAR(x);
      if IMP(proc) goto nullet;
      t.arg1 = EOL;
      while NIMP(proc) {
	ASSERT(NIMP(proc) &&
	       CONSP(proc),x,ARG1,s_letrec);
	ASSERT(NIMP(CAR(proc)) && CONSP(CAR(proc)) &&
	       SYMBOLP(CAR(CAR(proc))),
	       x,ARG1,s_letrec);
	t.arg1 = cons(CAR(CAR(proc)),t.arg1);
	proc = CDR(proc);
      }
      env = EXTEND_ENV(t.arg1,undefineds,env);
      t.arg1 = EOL;
      proc = CAR(x);
      while NIMP(proc) {
	t.arg1 = cons(EVAL(CAR(CDR(CAR(proc))),env),
		      t.arg1);
	proc = CDR(proc);
      }
      CDR(CAR(env)) = t.arg1;
      x = CDR(x);
      goto begin;
    case ISYMNUM(s_or):
      x = CDR(x);
      t.arg1 = x;
      while(NNULLP(t.arg1 = CDR(t.arg1))) {
	x = EVAL(CAR(x),env);
	if NFALSEP(x) return x;
	x = t.arg1;
      }
      goto carloop;
    case ISYMNUM(s_define):
      x = CDR(x);
      proc = x;
      x = CDR(x);
      while CONSP(proc = CAR(proc))
	x = cons(cons(s_lambda,cons(CDR(proc),x)),EOL);
      ASSERT(NIMP(proc) && SYMBOLP(proc),proc,ARG1,s_define);
      x = EVAL(CAR(x),env);
      t.lloc = envlookup(proc,env);
      if (t.lloc) *t.lloc = x;
      else if NNULLP(env) {
	env = CAR(env);
	CAR(env) = cons(proc,CAR(env));
	CDR(env) = cons(x,CDR(env));
      }
      else VCELL(proc) = x;
      return UNSPECIFIED;
    case ISYMNUM(s_lambda):
      x = CDR(x);
      return closure(x,env);
    case ISYMNUM(s_quasiquote):
      x = CDR(x);
      ASSERT(NIMP(x) && CONSP(x) &&
	     NULLP(CDR(x)),x,ARG1,s_quasiquote);
      return iqq(CAR(x), env, 1);
    case ISYMNUM(s_quote):
      x = CDR(x);
      return CAR(x);
    case ISYMNUM(s_set):
      x = CDR(x);
      proc = CAR(x);
      x = EVAL(CAR(CDR(x)),env);
      ASSERT(NIMP(proc) && SYMBOLP(proc),proc,ARG1,s_set);
      t.lloc = envlookup(proc,env);
      if (!t.lloc) {
	t.lloc = &VCELL(proc);
	ASSERT(!UNBNDP(*t.lloc),proc,"unbound variable",s_set);
      }
      *t.lloc = x;
      return UNSPECIFIED;
    }
  default:
    return x;
  case tcs_cons_nimcar:
    ;
  }
  proc = CAR(x);
  ASSERT(NIMP(proc),proc,FUN,s_eval);
  switch TYP6(proc) {
  case tcs_symbols:
    t.lloc = envlookup(proc,env);
    if (t.lloc) proc = *t.lloc;
    else proc = VCELL(proc);
    if UNBNDP(proc) err("undefined variable",CAR(x));
    break;
  case tcs_cons_imcar:
  case tcs_cons_nimcar:
    proc = ceval(proc,env);
  }
  ASSERT(NIMP(proc),proc,FUN,s_eval);
  x = CDR(x);
  switch TYP6(proc) {	
  case tc6_subr_2:
    t.arg1 = EVAL(CAR(x),env);
    x = CDR(x);
    x = NULLP(x)?UNDEFINED:EVAL(CAR(x),env);
    return SUBRF(proc)(t.arg1,x);
  case tc6_subr_2x:
    t.arg1 = EVAL(CAR(x),env);
    x = CDR(x);
    x = EVAL(CAR(x),env);
    return SUBRF(proc)(x,t.arg1);
  case tc6_subr_2n:
    t.arg1 = EVAL(CAR(x),env);
    x = CDR(x);
    x = EVAL(CAR(x),env);
    x = SUBRF(proc)(t.arg1,x);
    return (SCM)((long)x^((long)BOOL_F^(long)BOOL_T));
  case tc6_subr_2xn:
    t.arg1 = EVAL(CAR(x),env);
    x = CDR(x);
    x = EVAL(CAR(x),env);
    x = SUBRF(proc)(x,t.arg1);
    return (SCM)((long)x^((long)BOOL_F^(long)BOOL_T));
  case tc6_subr_0:
    return SUBRF(proc)();
  case tc6_subr_1:
    return SUBRF(proc)(NULLP(x)?UNDEFINED:EVAL(CAR(x),env));
  case tc6_cxr:
    x = EVAL(CAR(x),env);
    {
	char *chrs = CHARS(SNAME(proc));
	while(*++chrs != 'r');
	while(*--chrs != 'c') {
	    ASSERT(NIMP(x) && CONSP(x),x,ARG1,s_cxr);
	    x = (*chrs == 'a')?CAR(x):CDR(x);
	}
    }
    return x;
  case tc6_subr_3:
    t.arg1 = EVAL(CAR(x),env);
    x = CDR(x);
    return SUBRF(proc)(t.arg1,EVAL(CAR(x),env),
		       EVAL(CAR(CDR(x)),env));
  case tc6_lsubr:
    return SUBRF(proc)(eval_args(x,env));
  case tc6_lsubr_2:
    t.arg1 = EVAL(CAR(x),env);
    x = CDR(x);
    return SUBRF(proc)(t.arg1,
		       EVAL(CAR(x),env),
		       eval_args(CDR(x),env));
  case tc6_asubr:
    if IMP(x) return SUBRF(proc)(UNDEFINED,UNDEFINED);
    t.arg1 = EVAL(CAR(x),env);
    x = CDR(x);
    while NIMP(x) {
      t.arg1 = SUBRF(proc)(t.arg1,EVAL(CAR(x),env));
      x = CDR(x);
    }
    return t.arg1;
  case tcs_closures:
    env = EXTEND_ENV(CAR(CODE(proc)),
		     eval_args(x,env),
		     ENV(proc));
    x = CDR(CODE(proc));
    goto begin;
  case tc6_contin:
    throw(proc,EVAL(CAR(x),env));
  case tcs_symbols:
  case tc6_vector:
  case tc6_string:
  case tc6_bignum:
  case tcs_cons_imcar:
  case tcs_cons_nimcar:
  default:
  badfun:
    err("bad function",proc);
    goto loop;
  }
}
 
SCM procedurep(obj)
SCM obj;
{
	if NIMP(obj) switch TYP6(obj) {
	case tcs_closures:
	case tc6_contin:
	case tcs_subrs: return BOOL_T;
	}
	return BOOL_F;
}
 
SCM apply(proc,arg1,args)
SCM proc,arg1,args;
{
	ASSERT(NIMP(proc),proc,ARG1,s_apply);
	/* This code is for lsubr apply. it is destructive on multiple args.
	this will only screw you if you do (apply apply '( ... )) */
	if NULLP(args)
		if NULLP(arg1) arg1 = UNDEFINED;
		else {
			args = CDR(arg1);
			arg1 = CAR(arg1);
		}
	else {
/*		ASSERT(NIMP(args) && CONSP(args),args,WNA,s_apply);*/
		SCM *lloc = &args;
		while NNULLP(CDR(*lloc)) lloc = &CDR(*lloc);
		*lloc = CAR(*lloc);
	}
 
	switch TYP6(proc) {
	case tc6_subr_2:
		args = NULLP(args)?UNDEFINED:CAR(args);
		return SUBRF(proc)(arg1,args);
	case tc6_subr_2x:
		ASSERT(NULLP(CDR(args)),args,WNA,s_apply);
		args = CAR(args);
		return SUBRF(proc)(args,arg1);
	case tc6_subr_2n:
		ASSERT(NULLP(CDR(args)),args,WNA,s_apply);
		args = CAR(args);
		args = SUBRF(proc)(arg1,args);
		return (SCM)((long)args^((long)BOOL_F^(long)BOOL_T));
	case tc6_subr_2xn:
		ASSERT(NULLP(CDR(args)),args,WNA,s_apply);
		args = CAR(args);
		args = SUBRF(proc)(args,arg1);
		return (SCM)((long)args^((long)BOOL_F^(long)BOOL_T));
	case tc6_subr_0:
		ASSERT(UNBNDP(arg1),arg1,WNA,s_apply);
		return SUBRF(proc)();
	case tc6_subr_1:
		ASSERT(NULLP(args),args,WNA,s_apply);
		return SUBRF(proc)(arg1);
	case tc6_cxr:
		ASSERT(NULLP(args),args,WNA,s_apply);
		{
			char *chrs = CHARS(SNAME(proc));
			while(*++chrs != 'r');
			while(*--chrs != 'c')
				arg1 = (*chrs == 'a')?CAR(arg1):CDR(arg1);
		}
		return arg1;
	case tc6_subr_3:
		return SUBRF(proc)(arg1,CAR(args),CAR(CDR(args)));
	case tc6_lsubr:
		return SUBRF(proc)(UNBNDP(arg1) ? EOL : cons(arg1,args));
	case tc6_lsubr_2:
		ASSERT(NIMP(args) && CONSP(args),args,WNA,s_apply);
		return SUBRF(proc)(arg1,CAR(args),CDR(args));
	case tc6_asubr:
		if NULLP(args) return SUBRF(proc)(arg1,UNDEFINED);
		while NIMP(args) {
			ASSERT(CONSP(args),args,ARG2,s_apply);
			arg1 = SUBRF(proc)(arg1,CAR(args));
			args = CDR(args);
		}
		return arg1;
	case tcs_closures:
		args = EXTEND_ENV(CAR(CODE(proc)),cons(arg1,args),ENV(proc));
		proc = CODE(proc);
		while NNULLP(proc = CDR(proc)) arg1 = EVAL(CAR(proc),args);
		return arg1;
	case tc6_contin:
		ASSERT(NULLP(args),args,WNA,s_apply);
		throw(proc,arg1);
	default:
		wta(proc,ARG1,s_apply);
		return arg1;
	}
}
 
SCM map(proc,arg1,args)
SCM proc,arg1,args;
{
	long i;
	SCM res = EOL,*pres = &res,*ve;
	if NULLP(arg1) return res;
	ASSERT(NIMP(arg1),arg1,ARG1,s_map);
	if NULLP(args) {
		while NIMP(arg1) {
			ASSERT(CONSP(arg1),arg1,ARG2,s_map);
			*pres = cons(apply(proc,CAR(arg1),listofnull),EOL);
			pres = &CDR(*pres);
			arg1 = CDR(arg1);
		}
		return res;
	}
	args = vector(cons(arg1,args));
	ve = VELTS(args);
	while (1) {
		arg1 = EOL;
		for (i = LENGTH(args)-1;i >= 0;i--) {
			if IMP(ve[i]) return res;
			arg1 = cons(CAR(ve[i]),arg1);
			ve[i] = CDR(ve[i]);
		}
		*pres = cons(apply(proc,arg1,EOL),EOL);
		pres = &CDR(*pres);
	}
}
SCM foreach(proc,arg1,args)
SCM proc,arg1,args;
{
	SCM *ve;
	long i;
	if NULLP(arg1) return UNSPECIFIED;
	ASSERT(NIMP(arg1),arg1,ARG1,s_map);
	if NULLP(args) {
		while NIMP(arg1) {
			ASSERT(CONSP(arg1),arg1,ARG2,s_map);
			apply(proc,CAR(arg1),listofnull);
			arg1 = CDR(arg1);
		}
		return UNSPECIFIED;
	}
	args = vector(cons(arg1,args));
	ve = VELTS(args);
	while (1) {
		arg1 = EOL;
		for (i = LENGTH(args)-1;i >= 0;i--) {
			if IMP(ve[i]) return UNSPECIFIED;
			arg1 = cons(CAR(ve[i]),arg1);
			ve[i] = CDR(ve[i]);
		}
		apply(proc,arg1,EOL);
	}
}
SCM cxr();
init_eval()
{
	s_cxr = init_subr("cxr",tc6_subr_1,cxr);
	init_subr("procedure?",tc6_subr_1,procedurep);
	s_apply = init_subr("apply",tc6_lsubr_2,apply);
	s_map = init_subr("map",tc6_lsubr_2,map);
	s_foreach = init_subr("for-each",tc6_lsubr_2,foreach);
}
