/* Scheme implementation intended for JACAL.
   Copyright (C) 1989, 1990 Aubrey Jaffer.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

The author can be reached at jaffer@ai.mit.edu or
Aubrey Jaffer, 84 Pleasant St., Wakefield MA 01880
*/

#include "scm.h"

SCM s_list_tail;
SCM s_string2list, s_string_copy, s_string_fill;
SCM s_vector2list, s_vector_fill;

SCM list_tail(lst,k)
SCM lst, k;
{
	register long i;
	ASSERT(INUMP(k),k,ARG2,s_list_tail);
	i = INUM(k);
	while (i-- > 0) {
		ASSERT(NIMP(lst)&&CONSP(lst),lst,ARG1,s_list_tail);
		lst=CDR(lst);
	}
	return lst;
}
SCM string2list(str)
SCM str;
{
	register long i;
	SCM res = EOL;
	register char *src;
	ASSERT(NIMP(str)&&STRINGP(str),str,ARG1,s_string2list);
	src = CHARS(str);
	for(i=LENGTH(str)-1;i>=0;i--) res = cons(MAKICHR(src[i]),res);
	return res;
}
SCM string_copy(str)
SCM str;
{
	ASSERT(NIMP(str)&&STRINGP(str),str,ARG1,s_string_copy);
	return makfromstr(CHARS(str),LENGTH(str));
}
SCM string_fill(str,chr)
SCM str,chr;
{
	register char *dst,c;
	register long k;
	ASSERT(NIMP(str)&&STRINGP(str),str,ARG1,s_string_fill);
	ASSERT(ICHRP(chr),chr,ARG2,s_string_fill);
	c = ICHR(chr);
	dst = CHARS(str);
	for(k=LENGTH(str)-1;k>=0;k--) dst[k] = c;
	return UNSPECIFIED;
}
SCM vector2list(v)
SCM v;
{
	SCM res = EOL;
	register long i;
	register SCM *data;
	ASSERT(NIMP(v)&&VECTORP(v),v,ARG1,s_vector2list);
	data=VELTS(v);
	for(i=LENGTH(v)-1;i>=0;i--) res = cons(data[i],res);
	return res;
}
SCM vector_fill(v,fill)
SCM v,fill;
{
	register long i;
	register SCM *data;
	ASSERT(NIMP(v)&&VECTORP(v),v,ARG1,s_vector_fill);
	data = VELTS(v);
	for(i=LENGTH(v)-1;i>=0;i--) data[i] = fill;
	return UNSPECIFIED;
}

init_scl()
{
	s_list_tail=init_subr("list-tail",tc6_subr_2,list_tail);
	s_string2list=init_subr("string->list",tc6_subr_1,string2list);
	init_subr("list->string",tc6_subr_1,string);
	s_string_copy=init_subr("string-copy",tc6_subr_1,string_copy);
	s_string_fill=init_subr("string-fill!",tc6_subr_2,string_fill);
	init_subr("list->vector",tc6_subr_1,vector);
	s_vector2list=init_subr("vector->list",tc6_subr_1,vector2list);
	s_vector_fill=init_subr("vector-fill!",tc6_subr_2,vector_fill);
}
