/* Scheme implementation intended for JACAL.
   Copyright (C) 1989, 1990 Aubrey Jaffer.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

The author can be reached at jaffer@ai.mit.edu or
Aubrey Jaffer, 84 Pleasant St., Wakefield MA 01880
*/

#include "config.h"

typedef long SCM;
typedef struct {SCM car,cdr;} cell;
typedef struct {long sname;SCM (*cproc)();} subr;

#define IMP(x) ((x)&6)
#define NIMP(x) (!IMP(x))

#define INUMP(x) ((x)&2)
#define NINUMP(x) (!INUMP(x))
#define MAKINUM(x) (((x)<<2)+2)
#define INUM0 ((SCM) 2)
#if ((((-1)<<2)+2)>>2 == -1)
#define SIGNED_RIGHT_SHIFT
#define INUM(x) ((x)>>2)
#else
#define INUM(x) (((x)<0) ? ~((~(x))>>2) : (x)>>2)
#endif

#define ICHRP(x) (((x)&255)==4)
#define ICHR(x) ((x)>>8)
#define MAKICHR(x) (((x)<<8)+4)

#define MAKFLAG(n) (SCM)(((n)<<8)+68)
#define BOOL_F MAKFLAG(0L)
#define BOOL_T MAKFLAG(1L)
#define UNDEFINED MAKFLAG(2L)
#define EOF_VAL MAKFLAG(3L)
#define EOL MAKFLAG(4L)
#define UNSPECIFIED MAKFLAG(5L)

#define ISYMP(n) ((((SCM)(n))&255)==36)
#define ISYMNUM(n) ((n)>>8)
#define ISYMCHARS(n) (isymnames[ISYMNUM(n)])
#define MAKISYM(n) (((n)<<8)+36)

extern char *isymnames[];
#define s_arrow MAKISYM(0L)
#define s_and MAKISYM(1L)
#define s_begin MAKISYM(2L)
#define s_case MAKISYM(3L)
#define s_cond MAKISYM(4L)
#define s_define MAKISYM(5L)
/* define s_delay MAKISYM(6L) */
#define s_do MAKISYM(7L)
#define s_else MAKISYM(8L)
#define s_if MAKISYM(9L)
#define s_lambda MAKISYM(10L)
#define s_let MAKISYM(11L)
#define s_letstar MAKISYM(12L)
#define s_letrec MAKISYM(13L)
#define s_or MAKISYM(14L)
#define s_quasiquote MAKISYM(15L)
#define s_quote MAKISYM(16L)
#define s_set MAKISYM(17L)
#define s_unquote MAKISYM(18L)
#define s_unquote_splicing MAKISYM(19L)
#define s_dot MAKISYM(20L)
#define NUM_ISYMS 21

#define FALSEP(x) ((x) == BOOL_F)
#define NFALSEP(x) ((x) != BOOL_F)
#define NULLP(x) ((x) == EOL)
#define NNULLP(x) ((x) != EOL)
#define UNBNDP(x) ((x) == UNDEFINED)
#define CELLP(x) (!NCELLP(x))
#define NCELLP(x) ((x) &7)

#define GCMARKP(x) (CDR(x) &1)
#define SETGCMARK(x) CDR(x) |= 1;
#define CLRGCMARK(x) CDR(x) &= ~1;
#define TYP3(x) (CAR(x) &7)
#define TYP6(x) (CAR(x) &63)

#define NCONSP(x) (CAR(x) &1)
#define CONSP(x) (!NCONSP(x))
#define CAR(x) (((cell *)(x))->car)
#define CDR(x) (((cell *)(x))->cdr)
#define GCCDR(x) (CDR(x) &~1)
#define SETCDR(x,v) CDR(x)=(SCM)(v)

#define CLOSUREP(x) (TYP3(x) == tc3_closure)
#define CODE(x) (CAR(x)-tc3_closure)
#define SETCODE(x,e) CAR(x)=(e)+tc3_closure
#define ENV(x) CDR(x)

#define SYMBOLP(x) (TYP3(x) == tc3_symbol)
#define NAMESTR(x) (CAR(x)-tc3_symbol)
#define SETNAMESTR(x,v) CAR(x)=(v)+tc3_symbol
#define VCELL(x) CDR(x)

#define PORTP(x) ((CAR(x) | 64) == tc_outport)
#define INPORTP(x) (CAR(x) == tc_inport)
#define OUTPORTP(x) (CAR(x) == tc_outport)
#define STREAM(x) ((FILE *)(CDR(x)))
#define SETSTREAM(x,v) SETCDR(x,v)
#define OPENP(x) (CDR(x))
#define CLOSEDP(x) (!OPENP(x))

#define SUBRP(x) (((CAR(x) &3) == 3) && (CAR(x) &48))
#define SNAME(x) (heap_org+(CAR(x)>>6))
#define SETSNAME(x,v,t) CAR(x)=((((cell *)(v))-heap_org)<<6)+(t)
#define SUBRF(x) (((subr *)(x))->cproc)

#define NTSTRP(x) ((CAR(x) == tc_ntstr)

#define MALLOCP(x) ((CAR(x) &51) == 3)
#define STRINGP(x) (TYP6(x) == tc6_string)
#define NSTRINGP(x) (!STRINGP(x))
#define VECTORP(x) (TYP6(x) == tc6_vector)
#define NVECTORP(x) (!VECTORP(x))
#define LENGTH(x) (CAR(x)>>6)
#define SETLENGTH(x,v,t) CAR(x) = ((v)<<6)+t
#define CHARS(x) ((char *)(CDR(x)))
#define VELTS(x) ((SCM *)(CDR(x)))
#define GCVELTS(x) ((SCM *)(CDR(x) &~1))
#define SETCHARS(x,v) SETCDR(x,v)
#define SETVELTS(x,v) SETCDR(x,v)

#define JMPBUF(x) (jmp_buf *)CHARS(x)
#define SETJMPBUF(x,v) SETCDR(x,v)

#define FREEP(x) (CAR(x) == tc_free_cell)
#define NFREEP(x) (!FREEP(x))

#define tcs_cons_imcar 2:case 4:case 6:case 10:case 12:case 14:case 18:case 20:\
	case 22:case 26:case 28:case 30:case 34:case 36:case 38:case 42:\
	case 44:case 46:case 50:case 52:case 54:case 58:case 60:case 62
#define tcs_cons_nimcar 0:case 8:case 16:case 24:case 32:case 40:case 48:case 56
#define tcs_closures 1:case 9:case 17:case 25:case 33:case 41:case 49:case 57
#define tcs_subrs tc6_subr_0:case tc6_subr_1:case tc6_cxr:case tc6_subr_3:\
	case tc6_subr_2:case tc6_subr_2x:case tc6_subr_2n:\
	case tc6_subr_2xn:case tc6_lsubr:case tc6_lsubr_2:case tc6_asubr
#define tcs_symbols 5:case 13:case 21:case 29:case 37:case 45:case 53:case 61

#define tc3_cons	0
#define tc3_closure	1
#define tc3_symbol	5

#define tc6_vector	3
#define tc6_bignum	7
#define tc6_string	11
#define tc6_contin	15
#define tc6_subr_0	19
#define tc6_subr_1	23
#define tc6_cxr		27
#define tc6_subr_3	31
#define tc6_subr_2	35
#define tc6_subr_2x	39
#define tc6_subr_2n	43
#define tc6_subr_2xn	47
#define tc6_lsubr	51
#define tc6_lsubr_2	55
#define tc6_asubr	59

#define tc6_smob	63
#define tc_free_cell	63
#define tc_ntstr	127
#define tc_inport	191
#define tc_outport	255

extern SCM sys_protects[];
#define cur_inp sys_protects[0]
#define cur_outp sys_protects[1]
#define listofnull sys_protects[2]
#define undefineds sys_protects[3]
#define nullvect sys_protects[4]
#define nullstr sys_protects[5]
#define symhash sys_protects[6]
#define NUM_PROTECTS 7

/* now for connects between source files */

extern char upcase[],downcase[];
extern int symhash_dim;
extern unsigned long heap_size;
extern cell *heap_org;
extern SCM *stack_start_ptr, freelist;
extern long gc_cells_collected,	gc_malloc_collected, gc_ports_collected;
extern long gc_cells_allocated;
extern long line_num;
extern int errjmp_ok, sig_disabled, sig_deferred;
char *must_malloc();
long ilength();
SCM intern(), makstr(), makfromstr(), makport(), closure();
SCM ceval(), gc_status(), gc(), gc_for_newcell(), init_subr();
SCM char_readyp(), iiopen();

SCM lnot(), booleanp(), eq(), equal();
SCM consp(), cons(), nullp();
SCM setcar(), setcdr();
SCM listp(), list(), length(), append(), reverse(), list_ref();
SCM memq(), member(), assq(), assoc();
SCM symbolp(), symbol2string(), string2symbol();
SCM numberp(), exactp(), inexactp(), numident();
SCM eqp(), lessp(), greaterp(), lesseqp(), greatereqp();
SCM zerop(), positivep(), negativep(), oddp(), evenp();
SCM lmax(), lmin(), sum(), product(), difference(), quotient(), absval();
SCM remainder(), modulo(), lgcd(), llcm(), number2string(), string2number();
SCM charp(), char_lessp(), char_ci_eq(), char_ci_lessp();
SCM char_alphap(), char_nump(), char_whitep(), char_upperp(), char_lowerp();
SCM char2int(), int2char(), char_upcase(), char_downcase();
SCM stringp(), make_string(), string();
SCM string_length(), string_ref(), string_set();
SCM string_equal(), string_ci_equal();
SCM string_lessp(), string_ci_lessp(), substring(), string_append();

SCM vectorp(), make_vector(), vector(), vector_length();
SCM vector_ref(), vector_set();
SCM foreach(), procedurep(), apply(), map(), call_cc();

SCM call_with_input_file(), call_with_output_file();
SCM input_portp(), output_portp(), current_input_port(), current_output_port();
SCM open_input_file(), open_output_file();
SCM lread(), read_char(), peek_char(), eof_objectp();
SCM close_port(), lwrite(), display(), newline(), write_char();

#define DIGITS '0':case '1':case '2':case '3':case '4':\
		case '5':case '6':case '7':case '8':case '9'

#ifdef RECKLESS
#define ASSERT(_cond,_arg,_pos,_subr) ;
#else
#define ASSERT(_cond,_arg,_pos,_subr) if(!(_cond))wta(_arg,_pos,_subr);
#endif

#define FUN 0L
#define ARG1 1L
#define ARG2 2L
#define ARG3 3L
#define WNA -1L
#define OUTOFRANGE -2L
#define OVERFLOW -3L
#define NALLOC -4L
#define NOFILE -5L
#define ENDFILE -6L

#define EVAL(x,env) (IMP(x)?(x):ceval((x),(env)))
#define SIDEVAL(x,env) if NIMP(x) ceval((x),(env))

#define CHECK_SIGINT {if (sig_deferred) err_ctrl_c();}
#define DEFER_SIGINT {sig_disabled = 1;}
#define ALLOW_SIGINT {sig_disabled = 0;CHECK_SIGINT}
