;;;; Template for configuration of *features* for Scheme
;;; Copyright (C) 1991 Aubrey Jaffer.

;;; (software-type) should be set to the generic operating system type.
;;; UNIX, VMS, MACOS, AMIGA and MSDOS are supported.

(define (software-type) 'UNIX)

;;; *features* should be set to a list of symbols describing features
;;; of this implementation.  Suggestions for features are:

(define *features*
      '(
;	rev3-report			;conforms to
	rev4-report			;conforms to
	ieee-p1178			;conforms to
;	sicp				;runs code from Structure and
					;Interpretation of Computer
					;Programs by Abelson and Sussman.
;	macro				;has macros
;	record				;has user defined data structures
	eval				;has
	debug				;has a native debugger

;	ieee-floating-point		;conforms to
	full-continuation		;can return multiple times

;	delay				;has
	quasiquote			;has
;	i/o-redirection			;with-input-from-file
					;with-output-from-file
;	char-ready?			;has
;	transcript			;transcript-on and transcript-off

;	pretty-print			;has
;	format				;has (format ...)
;	compiler			;has (compiler)
;	ed				;(ed) is editor
	system				;posix (system)
	getenv				;posix (getenv)
	tmpfil				;posix (tmpfil)
	program-arguments		;returns list of strings (argv)
;	Xwindows			;X support
;	curses				;screen management package
;	termcap				;terminal description package
;	terminfo			;sysV terminal description
	))

;; MOST-POSITIVE-FIXNUM is used in modular.scm
(define most-positive-fixnum #x0FFFFFFF)

;; define an error procedure for the library
(define slib:error error)

;; define these as appropriate for your system.
(define slib:tab (integer->char 9))
(define slib:form-feed (integer->char 12))

;;; Define these if your implementation's syntax can support it and if
;;; they are not already defined.

(define (1+ n) (+ n 1))
(define (-1+ n) (+ n -1))
(define 1- -1+)

;;; (implementation-vicinity) should be defined to be the pathname of
;;; the directory where any auxillary files to your Scheme
;;; implementation reside.

(define (implementation-vicinity)
  (case (software-type)
    ((UNIX)	 "/usr/src/scheme/")
    ((VMS)	"scheme$src:")
    ((MSDOS)	"C:\\scheme\\")))

;;; (library-vicinity) should be defined to be the pathname of the
;;; directory where files of Scheme library functions reside.

(define library-vicinity
  (let ((library-path
	 (if (memq 'getenv *features*)
	     (or (getenv "SCHEME_LIBRARY_PATH") "")
;;; Uses this path if your scheme does not support GETENV.
	     (case (software-type)
	       ((UNIX) "/usr/lib/scheme/")
	       ((VMS) "lib$scheme:")
	       ((MSDOS) "C:\\SLIB\\")
	       (else "")))))

    (lambda () library-path)))

(define in-vicinity string-append)

(load (in-vicinity (library-vicinity) "require.scm"))
