;;;; Implementation of rev2 procedures eliminated in subsequent versions.
;;; Copyright (C) 1991 Aubrey Jaffer.
;
;  (substring-move-left! string1 start1 end1 string2 start2)
;  (substring-move-right! string1 start1 end1 string2 start2)
;							procedure
;
;String1 and string2 must be a strings, and start1, start2 and
;end1 must be exact integers satisfying
;
;	0 <= start1 <= end1 <= (string-length string1)
;	0 <= start2 <= end1-start1+start2 <= (string-length string2).
;
;Substring-move-left! and substring-move-right! store characters of
;string1 beginning with index start1 (inclusive) and ending with
;index end1 (exclusive) into string2 beginning with index start2
;(inclusive).
;
;Substring-move-left! stores characters in time order of increasing
;indeces.  Substring-move-right! stores characters in time order of
;decreasing indeces.
;----------------------------------------------------------------------
(require 'rev3-procedures)

(define (substring-move-left! string1 start1 end1 string2 start2)
  (do ((i start1 (+ i 1))
       (j start2 (+ j 1))
       (l (- end1 start1) (- l 1)))
      ((<= l 0))
    (string-set! string2 j (string-ref string1 i))))

(define (substring-move-right! string1 start1 end1 string2 start2)
  (do ((i (+ start1 (- end1 start1) -1) (- i 1))
       (j (+ start2 (- end1 start1) -1) (- j 1))
       (l (- end1 start1) (- l 1)))
      ((<= l 0))
    (string-set! string2 j (string-ref string1 i))))

(define (substring-fill! string start end char)
  (do ((i start (+ i 1))
       (l (- end start) (- l 1)))
      ((<= l 0))
    (string-set! string j char)))

(define (string-null? str)
  (= 0 (string-length str)))

(define append!
  (lambda args
    (cond ((null? args) '())
	  ((null? (cdr args)) (car args))
	  ((null? (car args)) (cadr args))
	  (else
	   (set-cdr! (last-pair (car args))
		     (apply append! (cdr args)))
	   (car args)))))

;;;; need to add code for OBJECT-HASH and OBJECT-UNHASH

(define <? <)
(define <=? <=)
(define =? =)
(define >? >)
(define >=? >=)
