;;;; Implementation of optional Scheme^4 functions for IEEE Scheme
;;; Copyright (C) 1991 Aubrey Jaffer.
;;; See the file `COPYING' for terms applying to this program.

;;; Some of these functions may be already defined in your Scheme.
;;; Comment out those definitions for functions which are already defined.

;;; This code conforms to: William Clinger and Jonathan Rees, editors.
;;; Revised^4 Report on the Algorithmic Language Scheme.

(define (list-tail l p)
  (if (< p 1) l (list-tail (cdr l) (- p 1))))

(define (string->list s)
  (do ((i (- (string-length s) 1) (- i 1))
       (l '() (cons (string-ref s i) l)))
      ((< i 0) l)))

(define (list->string l) (apply string l))

(define (string-copy s)
  (do ((v (make-string (string-length s)))
       (i (- (string-length s) 1) (- i 1)))
      ((< i 0) v)
      (string-set! v i (string-ref s i))))

(define (string-fill! s obj)
  (do ((i (- (string-length s) 1) (- i 1)))
      ((< i 0))
      (string-set! s i obj)))

(define (list->vector l) (apply vector l))

(define (vector->list s)
  (do ((i (- (vector-length s) 1) (- i 1))
       (l '() (cons (vector-ref s i) l)))
      ((< i 0) l)))

(define (vector-fill! s obj)
  (do ((i (- (vector-length s) 1) (- i 1)))
      ((< i 0))
      (vector-set! s i obj)))
