@part[FEATURE, root "TMAN.MSS"] @Comment{-*-System:TMAN-*-}
@chap[Miscellaneous features]


@section[Comments and declarations]

@info[NOTES="Special form"]
@desc[(COMMENT . @i[comment]) @yl[] @i[undefined]]
Does nothing and returns no value of interest.
@tc[COMMENT]-expressions may be used to write comments in code.
(The preferred way to write comments, however, is with the semicolon
read macro character; see page @pageref[SEMICOLON].)
@EndDesc[COMMENT]

@info[NOTES="Special form"]
@desc[(IGNORE . @i[variables]) @yl[] @i[undefined]]
Ordinarily, programs
such as compilers
which manipulate source programs
consider it to be an exceptional condition
when a bound variable is not referenced, and may generate warning messages
when they detect this condition.
@tc[IGNORE]-expressions may be used to suppress such warnings
and also to request that a warning be issued if in fact there are
any references to @i[variables].
  @begin[ProgramExample]
(LAMBDA (X Y) (IGNORE X) (CAR Y))
  @end[ProgramExample]
@EndDesc[IGNORE]

@info[NOTES="Special form"]
@desc[(IGNORABLE . @i[variables]) @yl[] @i[undefined]]

@tc[IGNORABLE] is like @tc[IGNORE] except that permission is @i[not]
given to give warnings if any of @i[variables] actually is referenced.
This is not useful for human-generated expressions, but may be useful
in the expansion of a macro invocation where the macro expander may
not know whether a bound variable in the expansion is referenced or
not, and wants to declare that it is all right if the variable is
not referenced.

@EndDesc[IGNORABLE]


@section[Errors and dead ends]
@label[Errors Section]  @Comment{ref: errors interface section}

@desc[(ERROR @i[control-string] . @i[arguments]) @yl[] @i[object]]
Signals an error.  @i[Control-string] and @i[arguments]
should be arguments suitable for a call to @tc[FORMAT]
(page @pageref[FORMAT]).
The error is reported in an implementation-dependent
manner, and an opportunity is provided to possibly correct
or proceed from the error.  (See section @ref[Errors Interface Section]
for details of @Timp[]'s handling of errors.)
  @begin[ProgramExample]
(ERROR "cannot wash the dishes because ~A" EXCUSE-DESCRIPTION-STRING)
  @end[ProgramExample]
@index[Errors]
@EndDesc[ERROR]

@desc[(SYNTAX-ERROR @i[control-string] . @i[arguments]) @yl[] @i[object]]
Similar to @tc[ERROR], but signals a syntax error.
This should be called, for example, from within macro expanders
when an illegal syntax is encountered.
@EndDesc[SYNTAX-ERROR]

@desc[(READ-ERROR @i[stream control-string] . @i[arguments]) @yl[] @i[object]]
Similar to @tc[ERROR], but signals a read error.
This should be called, for example, from within read macros
when an illegal read syntax is encountered.
@EndDesc[READ-ERROR]

@desc[(CHECK-ARG @i[predicate object procedure]) @yl[] @i[object]]
@index[Types]
Verifies that an object is of a particular type.
@i[Predicate] should be a type predicate, and @i[object] can be any object.
If @i[predicate], when applied to @i[object], returns false,
then an error is signalled.
If it returns true, then the @tc[CHECK-ARG] returns @i[object].
@i[Procedure] is a procedure whose name will be given in any
message printed by the error system.

The user interface (see section @ref[Errors Interface Section])
may provide a way to supply a value to use in place of @i[object].
If the user attempts to correct the error in this way, then
@tc[CHECK-ARG] again verifies that the new value answers true to
@i[predicate], and returns it.

For example:
  @begin[ProgramExample]
(DEFINE (WASH-DISH DISH)
  (LET ((DISH (CHECK-ARG DISH? DISH WASH-DISH)))
    ...))
  @end[ProgramExample]
@EndDesc[CHECK-ARG]

@label[UndefinedSection]        @Comment{ref: semantics chapter}

@desc[(PROCLAIM @i[predicate] @i[object]) @yl[] @i[object]]
Returns @i[object], which must answer true to @i[predicate].
A call to @tc[PROCLAIM] serves as a type declaration;
this may assist an optimizing compiler in generating efficient code.
  @begin[ProgramExample]
(PROCLAIM @i[predicate] @i[object])
  @ce[]
(LET ((VALUE @i[object]))
  (COND ((@i[predicate] VALUE) VALUE)
        (ELSE (UNDEFINED-EFFECT))))
  @end[ProgramExample]
@enddesc[PROCLAIM]

@desc[(ASSERT @i[boolean]) @yl[] @i[undefined]]
Has no effect and returns an undefined value,
unless @i[boolean] is false, in which case the effect
is undefined (normally, this means that an error is signalled).
@enddesc[ASSERT]

@Desc[(UNDEFINED-VALUE . @i[arguments]) @yl[] @i[undefined]]
@index[Undefined]
Has no effect and yields some undefined value.  An implementation will
endeavor to return some object which, when printed or otherwise
displayed, will show the @i[arguments].  This feature may be useful in
debugging, for example in tracking down the origin of the undefined
value, if the value has propagated to an undesirable place.
@EndDesc[UNDEFINED-VALUE]

@Desc[(UNDEFINED-EFFECT . @i[arguments]) @yl[] @i[undefined]]
The effect of calling @tc[UNDEFINED-EFFECT] is undefined.  An
implementation will endeavor to signal an error condition if such a call
ever occurs; however, an optimizing compiler may make use of the fact
that the control path leading to a call to @tc[UNDEFINED-EFFECT] will
never be taken in a correctly running program, and so in some cases may
eliminate the call.
@EndDesc[UNDEFINED-EFFECT]


@begin[group]

@section[Early binding]
@index[Early binding]

@dc{ Streamline the following!  Talk about early vs. late binding and
incremental redefinition. }

@info[NOTES="Special form"]
@desc[(DEFINE-CONSTANT @i[variable value]) @yl[] @i[undefined]]
This is semantically identical to @tc[DEFINE], but also declares that
the value of the variable will not change.  This might permit a compiler
to perform constant-folding.
Also, if the variable is defined to be a small integer, this may
interact well with @tc[SELECT] to obtain fast numeric dispatch on
@qu"enumerated types."
@EndDesc[DEFINE-CONSTANT]

@end[group]

@AnEquivE[Tfn="DEFINE-INTEGRABLE",Efn="DEF-OPEN-CODED"]
@AnEquivE[Tfn="DEFINE-INTEGRABLE",Efn="DEFSUBST"]
@info[NOTES="Special form"]
@descN[
F1="(DEFINE-INTEGRABLE @i[variable value]) @yl[] @i[undefined]",
FN1="DEFINE-INTEGRABLE",
F2="(DEFINE-INTEGRABLE (@i[variable] . @i[arguments]) . @i[body]) @yl[] @i[undefined]"
]
This is semantically identical to @tc[DEFINE], but also declares
that the value of the variable is not expected to change.
For example, if a reference to the variable is encountered in
functional position in a call, its definition may be @i[integrated],
that is, substituted in-line.
    @BeginInset[Bug:]
    TC 1.4 will blow up on integrating a recursive procedure defined with
    @tc[DEFINE-INTEGRABLE].
    @EndInset[]
@EndDescN[]
@Label[DefineIntegrableSection]

@section[Symbol generators]
@index[Symbols]

@desc[(GENERATE-SYMBOL @i[prefix]) @yl[] @i[symbol]]
Each call to @tc[GENERATE-SYMBOL] generates a unique identifier.  The
form which the new identifier's name takes is not defined, but the
identifier is guaranteed to be different from any identifier created
in any other way.  The identifier's external representation will begin
with @i[prefix].
    @BeginInset[Bug:]
    Uniqueness is not entirely guaranteed in @Timp[] 2.7, because
    the resulting symbol, although obscurely named, may already exist
    in the symbol table.
    @EndInset[]
@EndDesc[GENERATE-SYMBOL]

@desc[(CONCATENATE-SYMBOL . @i[things]) @yl[] @i[symbol]]
Creates a symbol whose print name is obtained by appending the printed
representations of @i[things] according to the @tc[DISPLAY] operation.
  @begin[ProgramExample]
(CONCATENATE-SYMBOL 'FOO- "THING-" 34)  @ev[]  FOO-THING-34
  @end[ProgramExample]
@EndDesc[CONCATENATE-SYMBOL]


@section[Combinators]
@index[Combinators]

@desc[(ALWAYS @i[value]) @yl[] @i[procedure]]
Returns a procedure which ignores its arguments and always returns @i[value].
@begin[ProgramExample]
(ALWAYS @i[value]) @ce[] (LAMBDA X (IGNORE X) @i[value])
@end[ProgramExample]
@EndDesc[ALWAYS]

@desc[(IDENTITY @i[object]) @yl[] @i[object]]
Identity function.  Returns its argument.
@EndDesc[IDENTITY]

@desc[(PROJN @i[n]) @yl[] @i[procedure]]
Returns a procedure which returns (projects) its @i[n]@+(th) argument, ignoring
any others.
@begin[ProgramExample]
(PROJN 1)  @ce[]  (LAMBDA (A B . REST) (IGNORE A REST) B)
@end[ProgramExample]
@EndDesc[PROJN]

@desc[(PROJ0 @i[object . rest]) @yl[] @i[object]]
Projection function: returns its zero@+(th) argument, ignoring the rest.
@begin[ProgramExample]
PROJ0  @ce[]  (PROJN 0)
@end[ProgramExample]
@tc[PROJ0] is similar to @tc[BLOCK0] (page @pageref[BLOCK0]), except
that it is a procedure, not a special form.
@EndDesc[PROJ0]

@desc[(PROJ1 @i[object0 object1 . rest]) @yl[] @i[object1]]
Returns its second argument.
@EndDesc[PROJ1]

@desc[(PROJ2 @i[object0 object1 object2 . rest]) @yl[] @i[object2]]
Returns its third argument.
@EndDesc[PROJ2]

@desc[(PROJ3 @i[object0 object1 object2 object3 . rest]) @yl[] @i[object3]]
Returns its fourth argument.
@EndDesc[PROJ3]

@desc[(CONJOIN . @i[predicates]) @yl[] @i[predicate]]
Returns a predicate which is the logical conjunction of all of the
@i[predicates].
@begin[ProgramExample]
((CONJOIN >0? ODD?) 13)  @ev[]  @r[true]
((CONJOIN >0? ODD?) 8)  @ev[]  @r[false]
@end[ProgramExample]
@EndDesc[CONJOIN]

@desc[(DISJOIN . @i[predicates]) @yl[] @i[predicate]]
Returns a predicate which is the logical disjunction of all of the
@i[predicates].
@begin[ProgramExample]
((DISJOIN >0? ODD?) 13)  @ev[]  @r[true]
((DISJOIN >0? ODD?) 8)  @ev[]  @r[true]
@end[ProgramExample]
@EndDesc[DISJOIN]

@desc[(COMPLEMENT @i[predicate])@ @yl() @i[predicate]]
Returns a predicate which is the logical complement of the @i[predicate].
@begin[ProgramExample]
ATOM? @ce[] (COMPLEMENT PAIR?)
((COMPLEMENT MEMQ?) 'A '(X Y Z))  @ev[]  @r[true]
@end[ProgramExample]
@EndDesc[COMPLEMENT]

@desc[(COMPOSE . @i[procedures]) @yl[] @i[procedure]]
Returns a procedure which is the composition of the @i[procedures].
The last of the @i[procedures] may take any number of arguments, and the resulting
procedure will take that same number of arguments; all the other
@i[procedures] must take one argument.
@begin[ProgramExample, LongLines Keep]
@tabclear
((COMPOSE CAR CDR) '(A B)) @^@ev[]  B
(COMPLEMENT @i[predicate]) @\@ce[]  (COMPOSE NOT @i[predicate])
PROPER-LIST? @\@ce[]  (DISJOIN NULL? (COMPOSE NULL? CDR LASTCDR))
NTH @\@ce[]  (COMPOSE CAR NTHCDR)
@tabclear
@end[ProgramExample]
@EndDesc[COMPOSE]

@dc{ Is this the right place to talk about these things...? }

@info[NOTES="Type predicate"]
@desc[(TRUE . @i[arguments]) @yl[] @i[true]]
Ignores its arguments, and always returns true.
This may be used as a predicate representing the @qu"universal type"
@dash[] the type which subsumes all objects.
@EndDesc[TRUE]

@info[NOTES="Type predicate"]
@desc[(FALSE . @i[arguments]) @yl[] @i[false]]
Ignores its arguments, and always returns false.
This may be used as a predicate representing the @qu"null type" @dash[] the
type which subsumes no objects.
@EndDesc[FALSE]

@info[NOTES="Type predicate"]
@desc[(TRUE? @i[value]) @yl[] @i[boolean]]
Returns true if @i[value] is @i[some] true value, false otherwise.
This is convenient where one wants to coerce a truth value
to be a @i[standard] truth value; that is,
@tc[TRUE?] maps false to itself, and any true value to
the standard true value (@tc[T]).
@begin[ProgramExample]
@tabclear
(TRUE? @i[object])  @^@ce[]  (NOT (FALSE? @i[object]))
(TRUE? NIL)@\@ev[]  @r[false]
(TRUE? T)@\@ev[]  @r[true]
(TRUE? 3)@\@ev[]  @r[true]
@tabclear
@end[ProgramExample]
@EndDesc[TRUE?]

@info[NOTES="Type predicate"]
@desc[(BOOLEAN? @i[object]) @yl[] @i[boolean]]
This returns true if @i[object] is either the standard true value
or the standard false value.
@dc{ It is a nearly useless predicate, and probably oughtn't be documented
until such time as @tc[PROCLAIM] and types are better supported. }
@begin[ProgramExample]
(BOOLEAN? NIL)  @ev[]  @r[true]
(BOOLEAN? T)    @ev[]  @r[true]
(BOOLEAN? 3)    @ev[]  @r[false]
@end[ProgramExample]
@EndDesc[BOOLEAN?]


@section[Vectors]
@label[VectorsSection]  @Comment{ref: objects chapter}
@index[Vectors]

@iix[Vectors] can be thought of as
one-dimensional, zero-based arrays, or as fixed-length, random-access lists.
They read and print like lists with a @tc[#] in front.
Like lists, but unlike numbers and strings, vectors are not
self-evaluating.  To write a constant vector, quote it: @wt['#(X Y (1 2))].

@Comment{@subsection[Predicates]}

@info[NOTES="Type predicate"]
@desc[(VECTOR? @i[object]) @yl[] @i[boolean]]
Returns true if @i[object] is a vector.
@EndDesc[VECTOR?]

@Comment{@subsection[Constructors]}

@desc[(MAKE-VECTOR @i[size]) @yl[] @i[vector]]
Returns a vector whose length is @i[size].
The elements are not initialized to any particular value.
@comment{All elements are not necessarily initialized to some useful value.
Maybe later such initialization will become part of the definition of
this routine, but for now, don't count on it.}
@tc[VECTOR-FILL] (see below) may be used
to fill the vector with some useful value (such as @tc[()]).
@EndDesc[MAKE-VECTOR]

@desc[(LIST->VECTOR @i[list]) @yl[] @i[vector]]
Converts a list to a vector.
@begin[ProgramExample]
(LIST->VECTOR '(A B C))  @ev[]  #(A B C)
@end[ProgramExample]
@EndDesc[LIST->VECTOR]

@desc[(VECTOR->LIST @i[vector]) @yl[] @i[list]]
Converts a vector to a list.
@begin[ProgramExample]
(VECTOR->LIST '#(A B C))  @ev[]  (A B C)
@end[ProgramExample]
@EndDesc[VECTOR->LIST]

@Comment{@subsection[Selectors]}

@info[NOTES="Settable"]
@descN[
F1="(VECTOR-ELT @i[vector n]) @yl[] @i[object]", FN1="VECTOR-ELT",
F2="(VREF @i[vector n]) @yl[] @i[object]", FN2="VREF"
]
Accesses the @i[n]@+[th] element of @i[vector] (zero-based).
@begin[ProgramExample]
(VECTOR-ELT '#(A B C) 1) @ev[]  B
@end[ProgramExample]
@EndDescN[]

@desc[(VSET @i[vector n object]) @yl[] @i[object]]
Sets the @i[n]@+[th] element of @i[vector] to @i[object].
  @begin[ProgramExample]
(VSET @i[vector n object]) @ce[] (SET (VREF @i[vector n]) @i[object])
  @end[ProgramExample]
@EndDesc[VSET]

@desc[(COPY-VECTOR @i[vector]) @yl[] @i[vector]]
Makes a copy of @i[vector].
@EndDesc[COPY-VECTOR]

@desc[(VECTOR-FILL @i[vector value]) @yl[] @i[vector]]
Sets every element of @i[vector] to @i[value], and returns the
modified @i[vector].
@EndDesc[VECTOR-FILL]

@desc[(VECTOR-REPLACE @i[target source n]) @yl[] @i[vector]]
Sets the first @i[n] elements of @i[target] to be the same as the
corresponding elements of @i[source], and returns the (modified)
@i[target].
@EndDesc[VECTOR-REPLACE]
 
@desc[(VECTOR-LENGTH @i[vector]) @yl[] @i[integer]]
Returns @i[vector]'s length.
@EndDesc[VECTOR-LENGTH]

@desc[(VECTOR-POS @i[predicate object vector]) @yl[] @i[integer] @r[or] @i[false]]
Returns index of the first element @i[x] of @i[vector]
such that @tc[(@i[predicate object x])], or false if there is no such element.
@EndDesc[VECTOR-POS]

@desc[(VECTOR-POSQ @i[object vector]) @yl[] @i[integer] @r[or] @i[false]]
@begin[ProgramExample]
(VECTOR-POSQ @i[object vector]) @ce[] (VECTOR-POS EQ? @i[object vector])
@end[ProgramExample]
@EndDesc[VECTOR-POSQ]

@desc[(WALK-VECTOR @i[procedure vector]) @yl[] @i[undefined]]
Applies @i[procedure] to every element in @i[vector].
@EndDesc[WALK-VECTOR]


@section[Pools]

@dc{ More documentation should be written.  Talk about GC interaction, etc. }

@iix[Pools] give a convenient way to perform explicit storage management in T.
One may obtain an object from a pool (popping the pool's free list, or
creating a new object if the free list is empty), and later return an
object to a pool.  By managing storage allocation in this way, the
frequency of garbage collections @dc{where explained?} can be reduced.
@index[Freelists]

All pools are emptied when a garbage collection occurs.  Garbage
collections occur asynchronously in an implementation-dependent manner.
@index[Garbage collection]

@desc[(MAKE-POOL @i[identification] @i[generator]) @yl[] @i[pool]]
Creates a pool.  @i[Generator] should be a procedure, and will be
called by @tc[OBTAIN-FROM-POOL] whenever the pool's free list is empty.
@i[Identification] is only for identification purposes, for example,
when the pool is printed.
@enddesc[MAKE-POOL]

@desc[(OBTAIN-FROM-POOL @i[pool]) @yl[] @i[object]]
Obtains an object from @i[pool].  If the pool is empty, the pool's generator
is called to obtain an object, which is then returned directly.
@enddesc[OBTAIN-FROM-POOL]

@desc[(RETURN-TO-POOL @i[pool] @i[object]) @yl[] @i[undefined]]
Returns @i[object] to @i[pool].  A future call to
@tc[OBTAIN-FROM-POOL] may yield @i[object].
@enddesc[RETURN-TO-POOL]


@section[Weak pointers]

@desc[(OBJECT-HASH @i[object]) @yl[] @i[integer]]
Returns a unique numeric identifier for @i[object].
That is,
  @begin[ProgramExample]
(EQ? @i[object1] @i[object2])
  @end[ProgramExample]
if and only if
  @begin[ProgramExample]
(= (OBJECT-HASH @i[object1]) (OBJECT-HASH @i[object2]))
  @end[ProgramExample]
Because @tc[OBJECT-HASH] is invertible (see below), it can be used
to create @ix[weak pointers] to objects, that is, @qu"pointers" or
@qu"references" which are not strong enough to prevent an object from
being reclaimed by the garbage collector.  This concept of weak pointer
is implemented by the integers returned by @tc[OBJECT-HASH], which
can be dereferenced by calling @tc[OBJECT-UNHASH].

@tc[OBJECT-HASH] is used by standard methods for the @tc[PRINT] operation
when printing objects which have no read syntax.
@EndDesc[OBJECT-HASH]

@desc[(OBJECT-UNHASH @i[integer]) @yl[] @i[object] @r[or] @i[false]]
Returns the object whose unique identifier is @i[integer],
or false if the object is no longer accessible (e.g. due to garbage
collection).
  @begin[ProgramExample]
(OBJECT-UNHASH (OBJECT-HASH @i[object]))  @ev[]  @i[object]
  @end[ProgramExample]
@EndDesc[OBJECT-UNHASH]

@iix[Populations] provide a way to keep track of a collection of objects.
They are sometimes known as @iix[weak sets] because they behave much like
sets, but an object in a population may go away if the only pointer to
the object is via the population.  The garbage collector will remove
such objects from populations.
@index[Garbage collection]

@desc[(MAKE-POPULATION @i[identification]) @yl[] @i[population]]
Creates a new population.
@enddesc[MAKE-POPULATION]

@desc[(ADD-TO-POPULATION @i[population] @i[object]) @yl[] @i[undefined]]
Adds @i[object] to @i[population].
@enddesc[ADD-TO-POPULATION]

@desc[(REMOVE-FROM-POPULATION @i[population] @i[object]) @yl[] @i[undefined]]
Removes @i[object] from @i[population].
@enddesc[REMOVE-FROM-POPULATION]

@desc[(POPULATION->LIST @i[population]) @yl[] @i[list]]
Returns a list of all objects currently in @i[population].  Note that as
long as this list is accessible, none of the objects will be implicitly
removed from the population, because they will be accessible via this list.
@enddesc[POPULATION->LIST]

@desc[(WALK-POPULATION @i[population] @i[procedure]) @yl[] @i[undefined]]
Calls @i[procedure] on each member of @i[population].
  @begin[ProgramExample]
(WALK-POPULATION @i[population] @i[procedure])
  @ce[]
(WALK @i[procedure] (POPULATION->LIST @i[population]))
  @end[ProgramExample]
@enddesc[WALK-POPULATION]
