(herald (assemble n32orbas t 11)
        (env t (assembler as_open))
;        (syntax-table
;         (block (*require 'as_syntax '(assembler as_syntax) (repl-env))
;                (env-syntax-table (repl-env))))
        )

;;; Orbit & N32 specific extensions to the assembler

(define  (assemble-init c)
  (assemble-init-1 c n32 emit-n32-template))

(define n32emit %%emit)

;;; ---------------- make machine operations available in orbit env

(table-walk (machine-ops-table n32)
            (lambda (key val)
              ;(format t "defining N32/~s~%" key)
              (*define orbit-env (concatenate-symbol 'n32/ key) val)))

(define-local-syntax (n32op opname)
  `(vref (machine-ops-vector n32) ,(concatenate-symbol '%n32% opname)))

(define r (n32op r))
(define d@r (n32op d@r))
(define (@r reg) (d@r reg 0))
(define d@d@r (n32op d@d@r))
(define (*d@r reg disp) (d@d@r reg disp 0))
(define index (n32op index))
(define $ (n32op $))
(define tos (n32op tos))

(define (d@slink disp) (d@d@r 10 cpu/slink disp))
(define (d@task disp) (d@d@r 10 cpu/task disp))
(define %nil ($ 2))
(define %t ($ 14))

(define b 'b)
(define w 'w)
(define d 'd)
(define f 'f)
(define l 'l)

(define (template tag) (n32/label *current-assembly-section* tag))
(define (label tag) (n32/label *current-assembly-section* tag))

;;; ---------------- Lap additions

(walk (lambda (name index)
        (*define-lap-register n32 name index))
      '(p a1 a2 a3 a4 a5 an nargs tp  sp cpu)
      '(0  1 2  3  4  5  6    7    8  9   10))

(walk (lambda (i)
        (set (table-entry (machine-pseudo-operands n32) (car i)) (cdr i)))
      `(
        (static  . ,(lambda (form section)
                      (destructure (((static id) form))
                        (static id))))
        
        (template . ,(lambda (form section)
                       (destructure (((template tag) form))
                         (n32/label section tag))))
        ))


;;; -------------------------- Template stuff.

;    |  handler offset               |  annotation offset        |H|I| :0
;    +---------------+---------------+-------------------------------+
;    |  # ptr cells  |  # scr cells  |   offset within bit vector    | :4
;    +---------------+---------------+---------------+---------+-+---+
;    |<- instructions|  used regs    |   # of args   |    tmplt|0|imm| <--- ptr
                                                   

;;; these fields are in the wrong order ?

(define-data-fg (n32/template lambda-node handler-ib)
  (printer ".template")
  (local template-end)
  (fields
   (fixed 8 (get-registers-used lambda-node))
   (fixed 16 (get-template-annotation lambda-node))        
   ;;handler offset
   (fixed 16 (fixnum-ashr (from template-end handler-ib) 3))   
   ;;bitv offset
   (fixed 16 (fx+ (fixnum-ashr (mark-address template-end) 3) 2)) 
   (fixed 16 (get-template-cells lambda-node))
   (fixed 1 (if (template-nary lambda-node)  1 0))
   (fixed 7 (identity header/template))
   (fixed 8 (get-template-nargs lambda-node))
   (mark template-end)
   ))

(define (emit-n32-template code-node code-ib handler-ib template-ib)
   (set (ib-align template-ib) '(24 31 -8))
   (as-emit template-ib (n32/template code-node handler-ib))
   (set-ib-follower template-ib code-ib)
   )


(define (n32-quick-value x invert?)
  (and (n32-imm? x)
       (let* ((qq (fg-argref (n32-operand-extension x) 0))
	      (q (if invert? (- qq) qq)))
	 (and (fx>= q -8) (fx< q 8) q))))

(define (n32/movi size src dest)
  (if (n32-quick-value src nil)
      (n32/movqi size src dest)
      (n32/%movi size src dest)))

(define (n32/addi size src dest)
  (if (n32-quick-value src nil)
      (n32/addqi size src dest)
      (n32/%addi size src dest)))

(define (n32/cmpi size src dest)
  (if (n32-quick-value src nil)
      (n32/cmpqi size src dest)
      (n32/%cmpi size src dest)))

(define (n32/subi size src dest)
  (cond ((n32-quick-value src t)
	 => (lambda (q)
	      (n32/addqi size ($ q) dest)))
	(else
	 (n32/%subi size src dest))))

(walk (lambda (x y) (*define-lap-global n32 x y))
      '(movi addi cmpi subi)
      (list n32/movi n32/addi n32/cmpi n32/subi))