;;; -------------------------- Template stuff.



;    |  handler offset               |  annotation offset        |H|I| :0
;    +---------------+---------------+-------------------------------+
;    |  # ptr cells  |  # scr cells  |   offset within bit vector    | :4
;    +---------------+---------------+---------------+---------+-+---+
;    |          <<---- instructions  |   # of args   |    tmplt|0|imm| <--- ptr
                                                   

;;; these fields are in the wrong order.

(define-data-fg (vax/template lambda-node handler-ib)
  (printer ".template")
  (local template-end)
  (fields
   (fixed 16 (get-template-annotation lambda-node))        
   ;;handler offset
   (fixed 16 (fixnum-ashr (from template-end handler-ib) 3))   
   ;;bitv offset
   (fixed 16 (fx+ (fixnum-ashr (mark-address template-end) 3) 2)) 
   (fixed 16 (get-template-cells lambda-node))
   (fixed 1 (if (template-nary lambda-node)  1 0))
   (fixed 7 (identity header/template))
   (fixed 8 (get-template-nargs lambda-node))
   (mark template-end)
   ))

(define (emit-vax-template code-node code-ib handler-ib template-ib)
   (set (ib-align template-ib) '(24 31 0))
   (emit-to-ib template-ib (vax/template code-node handler-ib))
   (set-ib-follower template-ib code-ib)
   )

;;; A few more machine parameters

(set (machine-template-emitter *vax-machine*) emit-vax-template)

(define vax-register-names
  '#( "s0" "s1" "s2" "s3"  "p"    "a1" "a2" "a3" 
      "a4" "an" "tp" "nil" "task" "fp" "sp" "pc" ))
