(herald (back_end m682arithgen)
  (env t (orbit_top defs) (back_end bookkeep)))

(define (do-assignment movers node)
  (iterate loop1 ((movers movers)
                  (targets (map arg-mover-to movers))
                  (temp nil))
    (cond ((null? movers))
        (else
         (iterate loop2 ((candidates targets))
           (cond ((null? candidates)
                  (let ((mover (car movers)))
                    (case (arg-mover-to-rep mover)
                      ((rep/double)
                       (generate-move-double (arg-mover-to mover) 
                               (reg-offset TASK task/extra-scratch)))
                      ((rep/pointer)
                       (generate-move (arg-mover-to mover)
                                   (reg-offset TASK task/extra-pointer)))
                      (else
                       (generate-move (arg-mover-to mover)
                                   (reg-offset TASK task/extra-scratch))))
                    (really-rep-convert node
                                        (arg-mover-from mover)
                                        (arg-mover-from-rep mover)
                                        (arg-mover-to mover)
                                        (arg-mover-to-rep mover))
                    (loop1 (cdr movers)
                           (delq (arg-mover-to mover) targets)
                           (arg-mover-to mover))))
                 ((not (mem? from-reg-eq? (car candidates) movers))
                  (let ((mover (car (mem to-reg-eq? (car candidates) movers))))
                    (really-rep-convert node
                         (cond ((eq? (arg-mover-from mover) temp)
                                (if (eq? (arg-mover-to-rep mover) 'rep/pointer)
                                    (reg-offset TASK task/extra-pointer)
                                    (reg-offset TASK task/extra-scratch)))
                               (else
                                (arg-mover-from mover)))
                         (arg-mover-from-rep mover)
                         (arg-mover-to mover)
                         (arg-mover-to-rep mover))
                    (loop1 (delq mover movers)
                           (delq (arg-mover-to mover) targets)
                           temp)))
                 (else
                  (loop2 (cdr candidates)))))))))

(define (m68-floatop inst)
  (xcase inst
    ((add) m68/fadd)
    ((subtract) m68/fsub)
    ((multiply) m68/fmul)
    ((divide) m68/fdiv)
    ((sin) m68/fsin)
    ((cos) m68/fcos)
    ((tan) m68/ftan)
    ((atan) m68/fatan)
    ((exp) m68/fetox)
    ((log) m68/flogn)
    ((sqrt) m68/fsqrt)
    ((acos) m68/facos)
    ((asin) m68/fasin)))
                         
(define (mark-floating-continuation node rep reg size)
  (xcase rep
    ((rep/double) (mark-continuation node reg))
    ((rep/pointer)
     (free-register node AN)                     
     (generate-slink-jump slink/make-double-float AN)
     (emit m68/fmove .d reg (reg-offset AN 2))
     (mark-continuation node AN))))           


(define (generate-flonum-binop node inst commutes? rep size)
  (destructure (((cont right left) (call-args node)))
    (receive (t-spec t-rep) (continuation-wants cont)
      (let* ((lvar (leaf-value left))
             (rvar (leaf-value right))
             (l-acc (access-float node lvar rep)))
        (protect-access l-acc)
        (let ((r-acc (access-float node rvar rep)))
          (release-access l-acc) 
          (let ((l-target? (and (floating-register? l-acc) 
                                (dying? lvar node) 
                                commutes?))
                (r-target? (and (floating-register? r-acc) 
                                (dying? rvar node))))
            (cond ((and l-target?
                        (or (not r-target?) 
                            (eq? t-spec l-acc)))
                   (emit (m68-floatop inst) size r-acc l-acc)
                   (kill lvar)
                   (mark-floating-continuation node t-rep l-acc size))
                  (r-target?
                   (emit (m68-floatop inst) size l-acc r-acc)
                   (kill rvar)
                   (mark-floating-continuation node t-rep r-acc size))
                  (else
                   (protect-access l-acc)
                   (let ((t-reg (cond ((and (floating-register? t-spec)
                                            (not (locked? t-spec)))
                                        t-spec)
                                      (else
                                       (get-floating-register node)))))
                     (release-access l-acc)
                     (emit m68/fmove size r-acc t-reg)
                     (emit (m68-floatop inst) size l-acc t-reg)                                                                       
                     (mark-floating-continuation node t-rep t-reg size))))))))))


(define (generate-flonum-unop node inst rep size)
  (destructure (((cont arg) (call-args node)))
    (receive (t-spec t-rep) (continuation-wants cont)
      (let* ((var (leaf-value arg))
             (acc (access-float node var rep)))
          (let ((target? (and (floating-register? acc) 
                               (dying? var node)))) 
            (cond (target?
                   (emit (m68-floatop inst) size acc acc)
                   (kill var)
                   (mark-floating-continuation node t-rep acc size))
                  (else
                   (protect-access acc)
                   (let ((t-reg (cond ((and (floating-register? t-spec)
                                            (not (locked? t-spec)))
                                        t-spec)
                                      (else
                                       (get-floating-register node)))))
                     (release-access acc)
                     (emit (m68-floatop inst) size acc t-reg)                                                                       
                     (mark-floating-continuation node t-rep t-reg size)))))))))

(define (flonum-comparator node inst rep size)
  (destructure (((then else () ref1 ref2) (call-args node)))
    (let* ((val1 (leaf-value ref2))     ;; ARGHH opposite of VAX for cond branch
           (val2 (leaf-value ref1)))
      (let ((access2 (access-float node val2 rep)))
        (protect-access access2)
        (let ((access1 (access-float node val1 rep)))
          (cond ((floating-register? access1)
                 (emit m68/fcmp size access2 access1)
                 (floating-emit-jump (get-floating-jop inst t) else then))
                ((floating-register? access2)
                 (emit m68/fcmp size access1 access2)
                 (floating-emit-jump (get-floating-jop inst nil) else then))
                (t                 
                 (let ((reg (get-floating-register node)))
                   (emit m68/fmove size access2 reg)
                   (emit m68/fcmp size access1 reg)
                   (floating-emit-jump (get-floating-jop inst nil) else then)))))
        (release-access access2)))))
                                                
(define (get-floating-jop inst reverse?)
  (xcase inst 
    ((jneq) jump-op/fln=)
    ((jgeq)
     (if reverse? jump-op/fl<= jump-op/fl>=))))
                                                                    
(define *non-float-registers* 
        (+ *pointer-temps* *scratch-temps* *real-registers*))


(define *no-of-registers* (+ *no-of-registers* 8))

(define (likely-next-reg var cont)
  (let ((spec (really-likely-next-reg var cont)))
    (cond ((fixnum? spec)
           (xcase (reg-type spec)
             ((pointer)
              (case (variable-rep var)
                ((rep/pointer) spec)
                ((rep/double) 'float)
                (else 'scratch)))
             ((scratch)
              (case (variable-rep var)
                ((rep/pointer) 'pointer)
                ((rep/double) 'float)
                (else spec)))
             ((float)
              (case (variable-rep var)
                ((rep/pointer) 'pointer)
                ((rep/double) spec)
                (else 'scratch)))))
          (else spec))))


(define (floating-register? x)
  (and (fixnum? x) (fx>= x *non-float-registers*) (fx< x *no-of-registers*)))


(define (reg-type reg)
  (cond ((fx>= reg *non-float-registers*) 'float)
        ((or (fx< reg *scratch-registers*)
             (fx>= reg (fx+ *real-registers* *pointer-temps*)))
         'scratch)
        (else 'pointer)))

(define (get-floating-register node)
  (iterate loop ((i *non-float-registers*) (kick nil))
    (cond ((fx>= i *no-of-registers*)
           (if kick 
               (kick-floating-register node kick)
               (bug "all floating-registers locked")))     
          ((not (reg-node i))
           i)
          ((locked? i)
           (loop (fx+ i 1) kick))
          (else
           (loop (fx+ i 1) i)))))

(define (kick-floating-register node reg)
  (do ((j (fx+ *real-registers* *pointer-temps*) (fx+ j 1)))
      ((if (fx>= j (fx- *non-float-registers* 1))
           (bug "ran out of registers in KICK-FLOATING-REGISTER")
           (and (not (reg-node j))
                (not (reg-node (fx+ j 1)))))
       (let ((value (reg-node reg)))
         (set (register-loc value) nil)
         (set (temp-loc value) j)
         (set (reg-node reg) nil)
         (generate-move-double reg j)
         reg))))

(define (restore-slots)
    (restore-registers)
    (restore-temps)
    (restore-floats))

(define (restore-floats)
  (do ((i *non-float-registers* (fx+ i 1)))
      ((fx>= i *no-of-registers*))
    (cond ((reg-node i)
           (set (register-loc (reg-node i)) i)))))

(define (restore-temps)
  (do ((i *real-registers* (fx+ i 1)))
      ((fx>= i *non-float-registers* ))
    (cond ((temp-node i)
           (set (temp-loc (temp-node i)) i)))))

(define (mark value reg)
  (set (reg-node reg) value)
  (if (or (register? reg)
          (floating-register? reg))
      (set (register-loc value) reg)
      (set (temp-loc value) reg)))



(define (access-float node value rep)                 
  (if (and (variable? value) (eq? (variable-rep value) rep))
      (access-value node value)
      (let ((reg (->register 'pointer node value '*)))
        (reg-offset reg 2))))

     
(define (generate-move-double ref1 ref2)
  (cond ((eq? ref1 ref2))
        ((or (floating-register? ref1) (floating-register? ref2))
         (emit m68/fmove .d ref1 ref2))
        (else
         (emit m68/move .l ref1 ref2)
         (emit m68/move .l (hacked-addr+1 ref1) (hacked-addr+1 ref2)))))
                                               
(define (hacked-addr+1 ref)
  (cond ((fixnum? ref) 
          (fx+ ref 1))
         ((fixnum? (cdr ref)) 
          (cons (car ref) (fx+ (cdr ref) 4)))
         (else
          (cons (car ref) (cons (fx+ (car (cdr ref)) 4) (cdr (cdr ref)))))))

(define (scaled-indexer address offset data scale)
  (cons (cons address data) (cons offset scale)))


(define (->field-group operand)
  (cond ((fg? operand) operand)
        ((fixnum? operand)
         (register->field-group operand))
        ((atom? operand) operand)
        ((fg? (car operand)) operand)
        ((fixnum? (car operand))
         (d@r (symbolic->machine-reg (car operand)) (cdr operand)))
        ((fixnum? (cdr operand))                                     
         (destructure ((((base . idex) . offset) operand))
           (index (d@r (symbolic->machine-reg base) offset)
                  (symbolic->machine-reg idex))))
        (else
         (destructure ((((base . idex) . (offset . scale)) operand))
           (scaled-index (d@r (symbolic->machine-reg base) offset)
                  (symbolic->machine-reg idex)
                  scale)))))
         

(define (register->field-group reg)
  (cond ((fx< reg 0)
         (r (vref *reserved-registers* (fx- 0 reg))))
        ((fx< reg 6)
         (r reg))   
        ((fx< reg *real-registers*)
         (r (fx+ reg 2)))
        ((fx>= reg *non-float-registers*)
         (fx- reg *non-float-registers*))
        (else
         (d@r 14 (fx* (fx- reg *real-registers*) CELL)))))


                


