(herald loadn32)

(set (print-env-warnings?) nil)
(set *compile-primops?* nil)
(define (cs x) (create-support x x))
(set (table-entry *modules* 'bignum) '(osys n32_bignum))
(load-quietly '(t3_primops nconstants t))
(set (orbit-syntax-table) (env-syntax-table t-implementation-env))

(define *orbit-n32-files*
    '((back_end n32)
      (back_end n32emit)
      (back_end n32bookkeep)
      (back_end n32gen)
      (back_end n32locgen)
      (back_end n32arithgen)
      (back_end n32rep)
      ))

;;; the following are from ~as/adm/asfiles.t

(define *tas-files*
    '((ntas as_open)      ;; for ntas & machine descriptions
      (ntas as_utils)     ;; utilities for the ntas
      (ntas as)           ;; client compiler interface
      ;; the ntas
      (ntas fg)
      (ntas ib)
      (ntas count)
      (ntas mark)
      (ntas mini)
      (ntas bits)
      (ntas listing)
      ;; lap user interface
      (ntas lap)
    ))

(define *tas-syntax-files*
    '((ntas expand)
      (ntas compile_fgs)
      (ntas as_syntax) 
    ))

(define *tas-n32-files*
    '((ntas/n32 n32machine)
      (ntas/n32 n32ams)
      (ntas/n32 n32forms)
      (ntas/n32 n32ops)
      (ntas/n32 n32lapenv)
      ))


  (walk load (append *tas-syntax-files*
                     *tas-files*
                     *tas-n32-files*
                     '((ntas/faces dkas)
                       (ntas/faces n32orbas)
                       (ntas fix))))
  (walk load *orbit-n32-files*)
  (load '(back_end unn32gen))
  (orbit-n32-init 't3_primops)

(define (comsys system . start)
  (walk (lambda (file)
	  (xcase (car file)
            ((osys)
	     (set (tc-syntax-table) (env-syntax-table t-implementation-env))
	     (comfile file))
	    ((t3_primops)
	     (set (tc-syntax-table) primop-syntax-table)
	     (bind ((write-support-file false))
	       (comfile file)))))
	(let ((files (xcase system
		       ((z) *zvm-system*)
		       ((t) *t-system*))))
	  (if start (mem alikev? (car start) files) files))))

(set (print-env-warnings?) t)

