(herald n32)

(define (create-unit thing)
 (let ((unit (make-closure))) 
   (receive (a-list count) (do-unit-variables thing)   
     (do ((lits *unit-literals* (cdr lits))
          (count count (fx+ count CELL))
          (a-list a-list `((,(car lits) . ,count) ,@a-list)))
       ((null? lits)
        (do ((closures (reverse! *unit-closures*) (cdr closures))
             (count count (fx+ count CELL))
             (a-list a-list `((,(car closures) . ,count) ,@a-list)))
            ((null? closures)
             (do ((templates *unit-templates* (cdr templates))
                  (count count (fx+ count (fx* CELL 4)))
                  (a-list a-list `((,(car templates) . ,(fx+ count CELL)) ,@a-list)))
                 ((null? templates)
                  (set (closure-pointer unit) (fx- (fx/ count CELL) 1))
                  (set (closure-scratch unit) 0)
                  (set (closure-env unit)  (reverse! a-list))
                  (set (closure-cit-offset unit) nil)
                  unit) 
               (set (closure-cit-offset (car templates)) (fx+ count CELL))))
          (create-environment (car closures) unit count)))))))

(define (create-comex filename h unit templates thing code)
  (if (fx>= (bytev-length code) 65536)
      (user-message-without-location 'error "Object file was too big~%" '#f))
  (let ((size (fx+ (fx+ (length unit) 4) (fx* (length templates) 3))) ; hack,
        (comex (make-comex)))                                         ; template
    (receive (objects opcodes)                                        ; in both
             (create-obj-op-vectors thing unit size filename h)
      (set (comex-module-name comex) version-number)
      (set (comex-code comex) code)
      (set (comex-objects comex) objects)
      (set (comex-opcodes comex) opcodes)           
      (set (comex-annotation comex) nil)
      comex)))

(define (create-obj-op-vectors thing unit size filename h)
  (let ((objects (make-vector size))
        (opcodes (make-bytev size)))
    (set (bref opcodes 0) op/literal)                         
    (vset objects 0 (->compiler-filename filename))
    (set (bref opcodes 1) op/literal)                         
    (vset objects 1 h)                       
    (set (bref opcodes 2) op/literal)                         
    (vset objects 2 'unit-env)                  
    (set (bref opcodes 3) op/closure)
    (vset objects 3 (code-vector-offset thing))
    (iterate loop ((a-list unit) (i 4))         
      (cond ((null? a-list)
             (return objects opcodes))
            ((closure? (caar a-list))
             (vset objects i
                   (code-vector-offset (cit->lambda (caar a-list))))
             (set (bref opcodes i) op/template1)
             (set (bref opcodes (fx+ i 1)) op/template2)
             (set (bref opcodes (fx+ i 2)) op/template2)
             (set (bref opcodes (fx+ i 3)) op/template2)
             (loop (cdr a-list) (fx+ i 4)))
            (else
             (receive (opcode obj) (comex-decipher (caar a-list))
               (vset objects i obj)
               (set (bref opcodes i) opcode)
               (loop (cdr a-list) (fx+ i 1))))))))


(define (protect-access access)
  (cond ((fixnum? access)
         (cond ((fx>= access 0)
                (lock access))))
        ((tas-operand? access) access)
        ((register? (car access)) 
         (if (fxn= (car access) SP)
             (lock (car access))))
        ((pair? (car access))
         (lock (caar access))
         (lock (cdar access)))))
         
(define (release-access access)
  (cond ((fixnum? access)
         (cond ((fx>= access 0)
                (unlock access))))
        ((tas-operand? access) access)
        ((register? (car access)) 
         (if (fxn= (car access) SP)
             (unlock (car access))))
        ((pair? (car access))
         (unlock (caar access))
         (unlock (cdar access)))))

(define (really-access-value node value)               
 (let ((value (cond ((and (variable? value) (variable-known value))
                     => lambda-self-var)
                    (else value))))
  (cond ((register-loc value)
         => (lambda (spec)
              (cond ((fixnum? spec))
                    (else
                     (cond ((pair? (car spec))
                            (unlock (caar spec))
                            (cond ((reg-node (caar spec))
                                   => (lambda (var) (kill-if-dying var node))))
                            (unlock (cdar spec)))
                           (else
                            (unlock (car spec))
                            (cond ((reg-node (car spec))
                                   => (lambda (var) (kill-if-dying var node))))))
                     (set (register-loc value) nil)))
              spec))
        ((temp-loc value))
        ((variable? value)
         (let ((binder (variable-binder value)))
           (cond ((not binder)
                  (lookup node value nil))
                 ((and (fx= (variable-number value) 0) 
                       (assq binder (closure-env *unit*)))
                  (lookup node binder nil))
                 (else
                  (lookup node value binder)))))
        ((primop? value)
         (if (eq? value primop/undefined)
             (machine-num 0)
             (lookup node value nil)))
        ((eq? value '#T)
         (machine-num header/true))
        ((or (eq? value '#F) (eq? value '()))
	 (reg-offset nil-reg 1))
        ((addressable? value)
         (lit value))
        (else
         (lookup node value nil)))))

(define (orbit-n32-init . directory)
  (orbit-n32-setup (if directory (car directory) '#f))
  (orbit-init 'base
              'constants
              'primops
              'arith
              'locations
              'low
              'predicates
              'open
              'aliases
              'carcdr
	      'n32genarith))

(define (orbit-n32-setup directory)
  (set *object-file-extension* 'no)
  (set *information-file-extension* 'ni)
  (set *noise-file-extension* 'nn)
  (set (table-entry *modules* 'constants) `(,directory nconstants))
  (set (table-entry *modules* 'primops)   `(,directory n32primops))
  (set (table-entry *modules* 'arith)     `(,directory n32arith))
  (set (table-entry *modules* 'low)       `(,directory n32low))
  (set (table-entry *modules* 'n32genarith)       `(,directory n32genarith))
  (orbit-setup directory)
  nil)