(herald n32bookkeep)                                                   ;87/02/09
  
(define-constant *pointer-registers* 5)     ;; A1,A2,A3,AN,P           ;87/02/09
(define-constant *scratch-registers* 2)     ;; S0,NARGS
(define-constant *argument-registers* 3)    ;; A1,A2,A3
(define-constant *real-registers* 7)        ;; 5+2
(define-constant *pointer-temps* 64)
(define-constant *scratch-temps* 5)
(define-constant *no-of-registers* 
                 (+ *pointer-temps* *scratch-temps* *real-registers*))
(define-constant *maximum-number-of-arguments* *pointer-temps*)             

(define-constant S0 0)                                                 ;87/02/09
(define-constant NARGS 1)
(define-constant P 2)
(define-constant A1 3)
(define-constant A2 4)
(define-constant A3 5)
(define-constant AN 6)
(define-constant AN-1 5)
(define-constant TP -1)
(define-constant nil-reg -2)
(define-constant SP -3)
(define-constant TASK -4)

(define (addressable? value)
  (or (and (fixnum? value)
	   (fx>= value #x-8000000)  ; 28 bits!
	   (fx< value #x8000000))
      (char? value)
      (eq? value '#F)
      (eq? value '#T)))

(define *pos-list1* (make-vector (fx+ *argument-registers* 1)))        ;87/05/26
(define *pos-list2* (make-vector (fx+ *argument-registers* 2))) 
  

(let ((base  '((3 . rep/pointer)                                       ;87/02/09
               (4 . rep/pointer)
               (5 . rep/pointer))))
  (set (vref *pos-list1* 0) (sublist base 0 0))
  (set (vref *pos-list1* 1) (sublist base 0 1))
  (set (vref *pos-list1* 2) (sublist base 0 2))
  (set (vref *pos-list1* 3) (sublist base 0 3)))

(let ((base  '((2 . rep/pointer)                                       ;87/02/09
               (3 . rep/pointer)
               (4 . rep/pointer)
               (5 . rep/pointer))))
  (set (vref *pos-list2* 0) (sublist base 0 0))
  (set (vref *pos-list2* 1) (sublist base 0 1))
  (set (vref *pos-list2* 2) (sublist base 0 2))
  (set (vref *pos-list2* 3) (sublist base 0 3))
  (set (vref *pos-list2* 4) (sublist base 0 4)))

;;; 3 is length of *pos-list1*; 4 is length of *pos-list2*

;(define (reg-positions i proc?)                                        ;87/02/26
;  (cond ((fx<= i (if proc? 4 3))
;         (vref (if proc? *pos-list2* *pos-list1*) i))
;        (else
;         (append (if proc? (vref *pos-list2* 4) (vref *pos-list1* 3))
;                 (make-num-list (fx- i (if proc? 4 3)))))))

(define (reg-positions i proc?)                                        ;87/05/26
  (let* ((pos-list (if proc? *pos-list2* *pos-list1*))
         (end-elt (fx- (vector-length pos-list) 1)))
    (cond ((fx<= i end-elt)
           (vref pos-list i))
          (else
           (append (vref pos-list end-elt)
                   (make-num-list (fx- i end-elt)))))))

(define (make-num-list amount)                                         ;87/05/26
  (let ((end (fx+ (fx+ *real-registers* *argument-registers*) amount)))
    (do ((i (fx+ *real-registers* *argument-registers*) (fx+ i 1))
         (l '() (cons (cons i 'rep/pointer) l)))
        ((fx>= i end) (reverse! l)))))

(define (do-trivial-lambda call-node node reg-rep)                     ;87/02/09
  (let ((offset (environment-cic-offset (lambda-env node))))
    (cond ((eq? (lambda-strategy node) strategy/hack)
           (generate-move-address (reg-offset SP (fx+ offset 2)) 
                                  (car reg-rep)))
          ((fx= offset 0)
           (generate-move AN (car reg-rep)))
          (else
           (generate-move-address (reg-offset AN offset) (car reg-rep))))
    (cond ((reg-node (car reg-rep))
                => kill))
    (lock (car reg-rep))))

                                                                            
;;; MAKE-HEAP-CLOSURE The first member of the closure corresponds to the
;;; template so we call %make-extend with this template and the size of the
;;; closure to be created.  Then we fill in the slots with the need variables
;;; and the addresses of templates for any closure-internal-closures.

(define (make-heap-closure node closure)                               ;87/02/09
  (let* ((members (closure-members closure))
         (template-binder (variable-binder (car members))))
    (walk (lambda (var)
            (lambda-queue (variable-binder var)))
          members)
    (free-register node AN)
    (let ((cl (environment-closure (lambda-env template-binder))))
      (cond ((closure-cit-offset cl)
             (let ((acc (lookup node cl nil)))
               (free-register node AN)
               (generate-move acc AN)))
            (else
             (generate-move-address (template template-binder) AN))))
    (lock AN)
    (generate-extend node (closure-size closure))
    (walk (lambda (pair)
      (let ((var (car pair))
            (offset (cdr pair)))
        (cond ((eq? var *dummy-var*))
              ((memq? var members)
               (generate-move-address (template (variable-binder var))
                                      (reg-offset AN
                                                  (fx- offset tag/extend))))
              (else
               (really-rep-convert node
                                   (access-value node var)
                                   (variable-rep var)
                                   (reg-offset AN
                                               (fx- offset tag/extend))
                                   (variable-rep var))))))
      (cdr (closure-env closure)))
    (unlock AN)))


(define (generate-extend node n)                                       ;87/02/09
  (free-register node S0)
  (free-register node NARGS)
  (generate-move (machine-num (fx- n CELL)) S0)   ;; don't include template
  (generate-slink-jump slink/make-extend))

(define exchange-hack false)                                           ;87/02/09
