(herald n32emit)                                                       ;87/02/09

;;; Copyright (c) 1985 Yale University
;;;     Authors: N Adams, R Kelsey, D Kranz, J Philbin, J Rees.
;;; This material was developed by the T Project at the Yale University Computer 
;;; Science Department.  Permission to copy this software, to redistribute it, 
;;; and to use it for any purpose is granted, subject to the following restric-
;;; tions and understandings.
;;; 1. Any copy made of this software must include this copyright notice in full.
;;; 2. Users of this software agree to make their best efforts (a) to return
;;;    to the T Project at Yale any improvements or extensions that they make,
;;;    so that these may be included in future releases; and (b) to inform
;;;    the T Project of noteworthy uses of this software.
;;; 3. All materials developed as a consequence of the use of this software
;;;    shall duly acknowledge such use, in accordance with the usual standards
;;;    of acknowledging credit in academic research.
;;; 4. Yale has made no warrantee or representation that the operation of
;;;    this software will be error-free, and Yale is under no obligation to
;;;    provide any services, by way of maintenance, update, or otherwise.
;;; 5. In conjunction with products arising from the use of this material,
;;;    there shall be no use of the name of the Yale University nor of any
;;;    adaptation thereof in any advertising, promotional, or sales literature
;;;    without prior written consent from Yale in each case.
;;;

(lset *open-procedure-calls?* nil)                                     ;87/02/09

;;; To properly handle special registers, we should check for the following
;;; cases:
;;;    (1)  move regular1, regular2         movi d regular1 regular2
;;;    (2)  move special1, regular2         spri d special1 regular2
;;;    (3)  move regular1, special2         lpri d special2 regular1
;;;    (4)  move special1, special2         spri d special1 temp
;;;                                         lpri d special2 temp
;;;    (5)  addr regular1, regular2         addr   regular1 regular2
;;;    (6)  addr regular1, special2         addr   regular1 temp
;;;                                         lpri d special2 temp
;;; But currently nobody calls generate-move with a special register
;;; (nil-reg,SP,TASK), so we'll leave it as it stands.

(define (generate-move ref1 ref2)                                      ;87/02/09
  (if (neq? ref1 ref2)
      (if (and (pair? ref1) (null? (cdr ref1)))
          (generate-move-address (car ref1) ref2)
          (emit n32/movi d ref1 ref2))))

(define (generate-push access)                                         ;87/02/09
  (increment-stack)
  (if (and (pair? access) (null? (cdr access)))
      (emit n32/addr (car access) (tos))
      (emit n32/movi d access (tos))))

(define-integrable (generate-pop access)                               ;87/02/09
  (emit n32/movi d (tos) access))

(define (adjust-stack-pointer n)   ;; n is # of bytes                  ;87/02/09
  (if (fxn= n 0) (emit n32/adjspi d ($ (fx- 0 n)))))

(define (generate-move-address from to)
  (cond ((register? to)
         (if (or (atom? from)
                 (neq? (car from) to)
                 (neq? (cdr from) 0))
             (emit n32/addr from to)))
        (else
         (emit n32/addr from to))))

(define-integrable (generate-slink-jump offset)                  ;87/02/09
  (emit n32/jsr (*d@r 10 offset)))       ;; 10 is nil-reg

(define-integrable (generate-jump-to-subroutine fg)                    ;87/02/09
  (emit n32/jsr fg))

(define-integrable (generate-jump-absolute fg)                         ;87/02/09
  (emit n32/jump fg))

(define (generate-jump label)                                          ;87/02/09
  (emit-jump 'jmp label nil))

(define (generate-avoid-jump label)                                    ;87/02/09
  (emit-avoid-jump 'jmp label nil))

(define (generate-return n-args)                                       ;87/02/09
  (emit n32/movi d (machine-num (fx- -1 n-args)) NARGS)
  (emit n32/movi d (reg-offset SP 0) TP)
  (emit n32/jump (reg-offset TP 0)))


(define (generate-general-call proc-var n-args)
  (emit n32/movi d  (machine-num (fx+ n-args 1)) NARGS)
  (cond ((and (or (variable-binder proc-var)
		  (var-is-vcell? proc-var)))
         (emit n32/jump (*d@r 10 slink/icall)))
        (else
         (emit n32/movi d (reg-offset P -2) TP)
         (emit n32/jump (reg-offset tp 0)))))

(define-integrable (generate-push-address access)                      ;87/02/09
  (increment-stack)
  (emit n32/addr access (tos)))

(define-integrable (increment-stack)                                   ;87/02/09
  (set *stack-pos* (fx+ *stack-pos* CELL)))

(define-integrable (n-decrement-stack n)                               ;87/02/09
  (set *stack-pos* (fx- *stack-pos* (fx* n CELL))))

(define (emit op . args)                                               ;87/05/19
  (n32emit (apply op (map! ->field-group args))))

(define (index-b base reg) (index base reg ':b))                       ;87/05/11
(define (index-w base reg) (index base reg ':w))
(define (index-d base reg) (index base reg ':d))
(define (index-q base reg) (index base reg ':q))

(define-constant (tas-operand? x) (n32-operand? x))                    ;87/06/15

(define (->field-group operand)                                        ;87/06/02
  (cond ((tas-operand? operand) operand)     ;; for ($ ... )
        ((fixnum? operand)
         (register->field-group operand))
        ((atom? operand)                     ;; for sizes (b,w,d)
         (cdr (assq operand '((d . 3) (w . 1) (b . 0)))))
        ((fixnum? (car operand))
         (d@r (symbolic->machine-reg (car operand)) (cdr operand)))
        (else
         (index-b (d@r (symbolic->machine-reg (caar operand)) (cdr operand))
                  (symbolic->machine-reg (cdar operand))))))

(define (symbolic->machine-reg reg)                                    ;87/02/09
  (cond ((fx< reg 0)
         (vref *reserved-registers* (fx- 0 reg)))
        (else reg)))

(define (register->field-group reg)                                    ;87/02/09
  (cond ((fx< reg 0)
         (r (vref *reserved-registers* (fx- 0 reg))))
        ((fx< reg *real-registers*)
         (r reg))
        (else
         (d@r 8 (fx* (fx- reg *real-registers*) CELL)))))   ;; 8 is TASK

(define *reserved-registers*                                           ;87/02/09
  '#(nil  7  10  9    8))
;        TP nil SP TASK


