(herald (back_end n32locgen)                                           ;86/10/15
  (env t (orbit_top defs)))

;;; Copyright (c) 1985 Yale University
;;;     Authors: N Adams, R Kelsey, D Kranz, J Philbin, J Rees.
;;; This material was developed by the T Project at the Yale University Computer 
;;; Science Department.  Permission to copy this software, to redistribute it, 
;;; and to use it for any purpose is granted, subject to the following restric-
;;; tions and understandings.
;;; 1. Any copy made of this software must include this copyright notice in full.
;;; 2. Users of this software agree to make their best efforts (a) to return
;;;    to the T Project at Yale any improvements or extensions that they make,
;;;    so that these may be included in future releases; and (b) to inform
;;;    the T Project of noteworthy uses of this software.
;;; 3. All materials developed as a consequence of the use of this software
;;;    shall duly acknowledge such use, in accordance with the usual standards
;;;    of acknowledging credit in academic research.
;;; 4. Yale has made no warrantee or representation that the operation of
;;;    this software will be error-free, and Yale is under no obligation to
;;;    provide any services, by way of maintenance, update, or otherwise.
;;; 5. In conjunction with products arising from the use of this material,
;;;    there shall be no use of the name of the Yale University nor of any
;;;    adaptation thereof in any advertising, promotional, or sales literature
;;;    without prior written consent from Yale in each case.
;;;

;;; Copyright (c) 1985 David Kranz

                                                                       ;87/02/09
(define (generate-set-location node)    ;; cont type-primop value . args
  ((xselect (length (call-args node))
     ((4) generate-set-fixed-accessor)
     ((5) generate-set-vector-elt))
   node))


(define (generate-set-fixed-accessor node)                             ;87/02/09
  (destructure (((#f type value loc) (call-args node)))
    (let* ((prim (leaf-value type))
           (do-it 
            (lambda (access)
              (cond ((and (eq? prim primop/cell-value)
                          (eq? (variable-definition (leaf-value loc)) 'one))
                     (let ((lc (access-value node (leaf-value loc))))
                       (generate-move access lc)
                       (cond ((and (register? lc) (temp-loc (leaf-value loc)))
                              => (lambda (lc)
                                   (set (temp-node lc) nil)
                                   (set (temp-loc (leaf-value loc)) nil))))))
                    (else
                     (let ((reg (->register 'pointer node (leaf-value loc) '*)))
                       (generate-move access
                             (reg-offset reg (primop.location-specs prim)))))))))
      (cond ((lambda-node? value)
             (let ((access (access/make-closure node value)))
               (if access (protect-access access) (lock AN))
               (do-it (if access access AN))
               (if access (release-access access) (unlock AN))))
            (else
             (let ((access (access-with-rep node (leaf-value value) 'rep/pointer)))
               (protect-access access)                         
               (do-it access)
               (release-access access)))))))

(define (generate-set-vector-type-length node)                         ;87/02/09
  (destructure (((#f vec val) (call-args node)))
    (let ((reg (->register 'pointer node (leaf-value vec) '*))
          (val (leaf-value val)))
      (lock reg)
      (let ((scratch (get-register 'scratch node '*)))
        (cond ((variable? val)
               (generate-move (access-value node val) scratch)
               (emit n32/ashi d
                     (machine-num (if (eq? (variable-rep val) 'rep/pointer) 6 8))
                     scratch))
              (else 
               (emit n32/movi d (machine-num (fixnum-ashl val 8)) scratch)))
        (emit n32/movi b (reg-offset reg -2) scratch)
        (emit n32/movi d scratch (reg-offset reg -2))
        (unlock reg)))))              
                    
;;; I have retained the M68 hack of accessing IDEX in rep/pointer and using
;;; index-b when IDEX is counting descriptors (first COND branch).

(define (generate-set-vector-elt node)
  (destructure (((#f type value loc idex) (call-args node)))
    (let ((idex (leaf-value idex))
          (rep (primop.rep-wants (leaf-value type)))
	  (reg (->register 'pointer node (leaf-value loc) '*)))
      (lock reg)
      (cond ((eq? rep 'rep/pointer)  ;; IDEX is # of descriptors
             (let* ((access (if (lambda-node? value)
                                (access/make-closure node value)
                                (access-value node (leaf-value value))))
                    (value-acc (if access access AN)))
               (if access (protect-access access) (lock AN))
	       (let ((i-reg (->register-with-rep 'pointer node idex 'rep/pointer)))
                 (generate-move value-acc (index-b (d@r reg 2) i-reg))
		 (unlock reg)
                 (if access (release-access access) (unlock AN)))))
            (else    ;; IDEX is # of bytes
             (let ((i-reg (->register-with-rep 'scratch node idex 'rep/integer))
                   (value (leaf-value value)))
                 (lock i-reg)
                 (cond ((variable? value)                       
                        (let ((acc (access-value node value)))
                          (protect-access acc)
                          (really-rep-convert node acc (variable-rep value)
                                   (index-b (d@r reg tag/extend) i-reg)
                                   rep)
                          (release-access acc)))
                       (else
                        (really-rep-convert node (value-with-rep value rep)
                                            rep
                                            (index-b (d@r reg tag/extend) i-reg)
                                            rep)))
                 (unlock i-reg)
                 (unlock reg)))))))

(define (->register-with-rep reg-type node var rep)
  (let ((acc (access-with-rep node var rep)))
    (if (register? acc)
        acc
        (into-register reg-type node var acc '*))))

(define (generate-contents-location node)                              ;87/02/09
  ((xselect (length (call-args node))
     ((3) generate-fixed-accessor)
     ((4) generate-vector-elt))
   node))

(define (generate-fixed-accessor node)                                 ;87/02/09
  (destructure (((cont type loc) (call-args node)))
   (if (or (leaf-node? cont) (used? (car (lambda-variables cont))))   
       (receive (t-spec t-rep) (continuation-wants cont)
         (let* ((type (leaf-value type))
                (base (leaf-value loc))
                (target (get-target-register node t-spec)))
           (cond ((and (eq? type primop/cell-value)
                       (eq? (variable-definition base) 'one))
                  (really-rep-convert node (access-value node base)
                                      'rep/pointer target t-rep))
                 (else
                  (let ((reg (->register 'pointer node base '*)))
                    (really-rep-convert node 
                               (reg-offset reg (primop.location-specs type))
                               'rep/pointer target t-rep))))
           (cond ((reg-node target) 
                  => (lambda (node) (set (register-loc node) nil))))
           (mark-continuation node target))))))

(define (generate-vector-type-length node)                             ;87/02/09
  (destructure (((cont vec) (call-args node)))
    (receive (t-spec t-rep) (continuation-wants cont)
      (let* ((base (leaf-value vec))
             (target (get-target-register node t-spec))
             (reg (->register 'pointer node base '*))
             (temp (if (eq? (reg-type target) 'scratch) 
                       target 
                       (get-register 'scratch node '*))))
        (emit n32/movi d (reg-offset reg -2) temp)
        (emit n32/ashi d (machine-num -8) temp)
        (if (eq? t-rep 'rep/pointer)
            (emit n32/ashi d (machine-num 2) temp))
        (generate-move temp target)
        (cond ((reg-node target) 
               => (lambda (node) (set (register-loc node) nil))))
        (mark-continuation node target)))))

(define (generate-vector-elt node)                                     ;87/02/09
  (destructure (((cont type loc idex) (call-args node)))
    (receive (t-spec t-rep) (continuation-wants cont)
      (let* ((base (leaf-value loc))
             (rep (primop.rep-wants (leaf-value type)))                    
             (idex (leaf-value idex))
             (t-reg (get-target-register node t-spec))
             (reg (->register 'pointer node base '*)))
        (lock reg)
        (cond ((fixnum? idex) 
               (really-rep-convert node 
                        (reg-offset reg (fx+ (if (eq? rep 'rep/pointer)
                                                 (fx* idex 4)
                                                 idex)
                                              tag/extend))
                        rep t-reg t-rep))
              (else
               (let* ((i-rep (if (eq? rep 'rep/pointer)
                                 'rep/pointer
                                 'rep/integer))
                      (i-reg (->register-with-rep 'scratch node idex i-rep)))
                 (really-rep-convert node (index-b (d@r reg tag/extend) i-reg)
                                     rep t-reg t-rep))))
          (unlock reg)
          (cond ((reg-node t-reg) 
                 => (lambda (node) (set (register-loc node) nil))))
          (mark-continuation node t-reg)))))

;;; IDEX is # of descriptors.  I retain the M68 hack of accessing IDEX in
;;; rep/pointer and using index-b.

(define (generate-make-pointer node)                                   ;86/10/27
  (destructure (((cont loc idex) (call-args node)))
    (receive (t-spec t-rep) (continuation-wants cont)
      (let ((t-reg (get-target-register node t-spec))
            (reg (->register 'pointer node (leaf-value loc) '*)))
        (lock reg)
        (let ((i-reg (->register-with-rep 'pointer node (leaf-value idex)
                                          'rep/pointer)))
          (emit n32/addr (index-b (d@r reg 4) i-reg) t-reg))
        (unlock reg)
        (cond ((reg-node t-reg) 
               => (lambda (node) (set (register-loc node) nil))))
        (mark-continuation node t-reg)))))
 

(define (generate-location-access node)                                ;87/02/09
  ((xselect (length (call-args node))
     ((3) defer-fixed-accessor)
     ((4) defer-vector-elt))
   node))

(define (defer-fixed-accessor node)                                    ;87/02/09
  (destructure (((cont type loc) (call-args node)))
    (let* ((type (leaf-value type))
           (base (leaf-value loc))
           (reg (->register 'pointer node base '*)))
      (lock reg)
      (set (register-loc (car (lambda-variables cont)))
           (cons reg (primop.location-specs type)))
      (allocate-call (lambda-body cont)))))



(define (defer-vector-elt node)                                        ;87/02/09
  (destructure (((cont type loc index) (call-args node)))
    (let* ((base (leaf-value loc))
           (rep (primop.rep-wants (leaf-value type)))
           (index (leaf-value index))
           (reg (->register 'pointer node base '*)))
      (lock reg)                                                            
      (cond ((fixnum? index)
             (set (register-loc (car (lambda-variables cont)))
                  (cons reg (fx+ (if (eq? rep 'rep/pointer)
                                     (fx* 4 index)
                                     index)
                                  tag/extend))))
            (else
             (let* ((i-acc (access-with-rep node index 
                                 (if (eq? rep 'rep/pointer)
                                     'rep/pointer
                                     'rep/integer)))
                    (i-reg (cond ((register? i-acc) i-acc)
                                 (else
                                  (let ((i (get-register 'scratch node '*)))
                                    (emit n32/movi d i-acc i)
                                    i)))))
               (unlock reg)
               (kill-if-dying index node)
               (lock reg)
               (lock i-reg)
               (set (register-loc (car (lambda-variables cont)))
                    (cons (cons reg i-reg) 2)))))
      (allocate-call (lambda-body cont)))))
          

(define (generate-%chdr node)                                          ;87/02/02
  (destructure (((#f vec val) (call-args node)))
    (let ((reg (->register 'pointer node (leaf-value vec) '*))
          (val (leaf-value val)))
      (lock reg)                                              
      (cond ((fixnum? val)
             (emit n32/addi d (machine-num val) 
                            (reg-offset reg offset/string-base))
             (emit n32/subi d (machine-num (fixnum-ashl val 8))
                            (reg-offset reg -2)))
            (else
             (let* ((n (access-with-rep node val 'rep/integer)))
               (emit n32/addi d n (reg-offset reg offset/string-base))
               (let ((s (get-register 'scratch node '*)))
                 (emit n32/movi d n s)
                 (emit n32/ashi d (machine-num 8) s)
                 (emit n32/subi d s (reg-offset reg -2))))))
      (unlock reg))))
