(herald orbit_changes)
(set (print-env-warnings?) nil)
(define quicklist listing)
(set *compile-primops?* nil)
(define (cs x) (create-support x x))
(set (table-entry *modules* 'bignum) '(osys m68_bignum))
(load-quietly '(t3_primops m68constants t))
(set (orbit-syntax-table) (env-syntax-table t-implementation-env))
(*define user-env 'make-empty-early-binding-locale
make-empty-early-binding-locale)
(comment
(walk load '((assembler texpand)
                (assembler tfg_spec)  
             (assembler tfg_expr)  
          (assembler tas_syntax)))
)
(lset *fix-files* 
      '((top orbit_syntax t)
	(back_end fix)
	(back_end ffix)
	(back_end fix1)
	(back_end m68fix)
	(back_end ttype)
	(back_end tm68gen)
	(back_end tm682arithgen)
	(back_end tunm68gen)
	(assembler m68fix)))
(walk load *fix-files*)
(orbit-m68-init 't3_primops)
(load '(back_end new_syntax) t-implementation-env)

(define (comsys system . start)
  (walk (lambda (file)
	  (xcase (car file)
            ((osys)
	     (set (tc-syntax-table) (env-syntax-table t-implementation-env))
	     (comfile file))
	    ((t3_primops)
	     (set (tc-syntax-table) primop-syntax-table)
	     (bind ((write-support-file false))
	       (comfile file)))))
	(let ((files (xcase system
		       ((z) *zvm-system*)
		       ((t) *t-system*))))
	  (if start (mem alikev? (car start) files) files))))
	
(set (print-env-warnings?) t)

