(herald m68low
  (env (make-empty-early-binding-locale 'nil) constants primops arith locations))

;;; Copyright (c) 1985 Yale University
;;;     Authors: N Adams, R Kelsey, D Kranz, J Philbin, J Rees.
;;; This material was developed by the T Project at the Yale University Computer 
;;; Science Department.  Permission to copy this software, to redistribute it, 
;;; and to use it for any purpose is granted, subject to the following restric-
;;; tions and understandings.
;;; 1. Any copy made of this software must include this copyright notice in full.
;;; 2. Users of this software agree to make their best efforts (a) to return
;;;    to the T Project at Yale any improvements or extensions that they make,
;;;    so that these may be included in future releases; and (b) to inform
;;;    the T Project of noteworthy uses of this software.
;;; 3. All materials developed as a consequence of the use of this software
;;;    shall duly acknowledge such use, in accordance with the usual standards
;;;    of acknowledging credit in academic research.
;;; 4. Yale has made no warrantee or representation that the operation of
;;;    this software will be error-free, and Yale is under no obligation to
;;;    provide any services, by way of maintenance, update, or otherwise.
;;; 5. In conjunction with products arising from the use of this material,
;;;    there shall be no use of the name of the Yale University nor of any
;;;    adaptation thereof in any advertising, promotional, or sales literature
;;;    without prior written consent from Yale in each case.
;;;


;|handler offset   | annotation offsetSHI|
;|           code vector offset          |    
;| pointer | scratch | nargs | ?template |          
                                

(define-constant (return . args)
  (ignore args)
  (lap ()                           
    (jmpl (d@r cont-reg 8) zero)           
    (sub nargs zero nargs)))
                 
(declare simplifier return simplify-values)

(define-constant (receive-values recipient thunk)
  (ignore recipient thunk)
  (lap ()
    (move  i2 o0)                      ; prepare to call thunk
    (move i1 i0)
    (move ($ 1) NARGS)               ; thunk takes no arguments
    (ld (d@r nil-reg slink/icall) l0)
    (jmpl (@r l0) i7)
    (save ($ -64) o6 o6)
    (restore zero o1 i1)
    (move o2 i2)
    (move o3 i3)
    (move o4 i4)
    (move o5 i5)
    (jmpl (@r l0) zero)
    (sub nargs zero nargs)))


(declare simplifier receive-values simplify-receive-values)

(define-constant make-pointer        ; extend and number of bytes
  (primop make-pointer ()                                        
    ((primop.generate self node)
     (generate-make-pointer node))
    ((primop.type self node)
     '#[type (proc #f (proc #f top) top fixnum)])))
;     '#[type (proc #f (proc #f top) extend fixnum)])))

(define-constant task-ref
  (primop task-ref ()
    ((primop.generate self node)
     (generate-task-ref node))))

(define-constant set-task-ref
  (primop set-task-ref ()
    ((primop.side-effects? self) t)
    ((primop.generate self node)
     (generate-set-task-ref node))))

(define-constant slink-ref
  (primop slink-ref ()
    ((primop.generate self node)
     (generate-slink-ref node))))

(define-constant set-slink-ref
  (primop set-slink-ref ()
    ((primop.side-effects? self) t)
    ((primop.generate self node)
     (generate-set-slink-ref node))))

(define-constant system-global
  (object (lambda (i) (slink-ref i))
    ((setter self)
     (lambda (i val) (set-slink-ref i val)))))

(define-constant process-global
  (object (lambda (i) (task-ref i))
    ((setter self)
     (lambda (i val) (set-task-ref i val)))))

(define-constant stack-pointer
  (primop stack-pointer ()
    ((primop.generate self node)
     (generate-stack-pointer node))))

;; template junk, see template.doc

(define-constant template-enclosing-object
  (primop template-enclosing-object ()
    ((primop.generate self node)
     (generate-template-enclosing-object node))
    ((primop.type self node)
     '#[type (proc #f (proc #f top) template)])))

(define-constant gc-extend->pair
  (primop gc-extend->pair ()
    ((primop.generate self node)
     (generate-one-arg node (lambda (acc t-reg)
			      (emit sparc/add (machine-num 1) acc t-reg))))
    ((primop.type self node)
     '#[type (proc #f (proc #f top) top)])))
;     '#[type (proc #f (proc #f pair) extend)])))

(define-constant gc-pair->extend
  (primop gc-pair->extend ()
    ((primop.generate self node)
     (generate-one-arg node (lambda (acc t-reg)
			      (emit sparc/sub (machine-num 1) acc t-reg))))
    ((primop.type self node)
     '#[type (proc #f (proc #f top) top)])))
;     '#[type (proc #f (proc #f extend) pair)])))
    
(define-constant closure-enclosing-object
  (primop closure-enclosing-object ()
    ((primop.generate self node)
     (generate-closure-enclosing-object node))
    ((primop.type self node)
     '#[type (proc #f (proc #f top) top)])))
;     '#[type (proc #f (proc #f top) extend)])))

(define-constant current-continuation
  (primop current-continuation ()
    ((primop.generate self node)
     (generate-current-continuation node))))

; see template.doc
                                                    
(define-constant (bit-test operand bit)    ; true if bit is on
  (if (fixnum-equal? (fixnum-logand operand (fixnum-ashl 1 bit)) 0)
      '#f
      '#t))

(define-constant (template-internal-bit? tem)
    (bit-test (mref-16-u tem -10) 0))

(define-constant (template-superior-bit? tem) '#f)
                                    
(define-constant (template-nary? tem)
  (alt-bit-set? tem))

(define-constant (template-pointer-slots tem)
  (mref-8-u tem -4))

(define-constant (template-scratch-slots tem) 0)

(define-constant (template-nargs tem)
  (mref-8-s tem -2))

(define-constant (template-encloser-offset template)
  (fixnum-ashr (mref-integer template -8) 2))

(define-constant (template-handler-offset template)
  (mref-16-u template -12))

(define-constant (closure-encloser-offset closure)
  (fixnum-ashr (mref-16-u (extend-header closure) -4) 2))

(define-constant (unit-top-level-forms unit)
  (make-pointer unit 3))

(define-constant (alt-bit-set? extend)            ; if bit 7 of header is on
  (fixnum-less? (mref-8-s extend -1) 0))

(define-constant (set-alt-bit! x)
  (modify (mref-8-u x -1) (lambda (x) (fixnum-logior #b10000000 x))))

(define-constant (clear-alt-bit! x)
  (modify (mref-8-u x -1) (lambda (x) (fixnum-logand #b01111111 x))))


(define-constant vcell-defined? alt-bit-set?)

(define-constant set-vcell-defined set-alt-bit!)

(define-constant set-vcell-undefined clear-alt-bit!)

(define-constant pure? alt-bit-set?)

(define-constant (purify! x)
  (set-alt-bit! x)
  (return))
                       
(define-constant (vframe-pointer-slots vframe)
  (mref-16-u vframe -3))

(define-constant (vframe-scratch-slots vframe) 0)

