(herald mac_link (env t (link defs)))

;;; Look at a Unix a.out description and template.doc

(define (create-lstate)
  (let ((l (make-lstate)))
    (set (lstate-foreign l) '())
    (set (lstate-pure l) (make-area))
    (set (lstate-impure l) (make-area))
    (set (lstate-symbols l) '())
    (set (lstate-symbol-count l) 6)     ;;; because of .text, .data and .bss
    (set (lstate-foreign-reloc l) '())
    (set (lstate-text-reloc l) '())
    (set (lstate-data-reloc l) '())
    l))


(define (link modules out-spec)
  (really-link modules 'mo out-spec 'o))

(define-constant SIZE-OF-HEADERS 140)
(define-constant RELOC-SIZE 10)
(define-constant MAGIC #o520)
(define-constant RELOC #o21)                          
(define-constant TEXT-SYM 0)
(define-constant DATA-SYM 2)
    
(define-constant %%d-ieee-size 53)
(define-constant %%d-ieee-excess 1023)

(define (write-double-float stream float)
  (receive (sign mantissa exponent)
           (normalized-float-parts float
                                   %%d-ieee-size 
                                   %%d-ieee-excess 
                                   t)
    (write-int stream header/double-float)
    (write-half stream (fx+ (fixnum-ashl sign 15)
                            (fx+ (fixnum-ashl exponent 4)
                                 (bignum-bit-field mantissa 48 4))))
    (write-half stream (bignum-bit-field mantissa 32 16)) 
    (write-half stream (bignum-bit-field mantissa 16 16)) 
    (write-half stream (bignum-bit-field mantissa 0 16))))
  
(define (write-vcell-header var stream)
  (write-half stream 0)
  (write-byte stream (if (fx= (vector-length (var-node-refs var))
			      0)
			 0
			 -1))
  (write-byte stream (if (eq? (var-node-defined var) 'define)
			 (fx+ header/vcell 128)
			 header/vcell)))

(define (write-template stream tmplt)
  (write-byte stream (cit-pointer tmplt))
  (write-byte stream (cit-scratch tmplt))
  (write-half stream (cit-unit-offset tmplt))
  (write-byte stream (cit-header/nary? tmplt))
  (write-byte stream (cit-nargs tmplt))
  (write-half stream M68-JUMP-ABSOLUTE)
  (write-int  stream 
              (fx+ (heap-offset (table-entry *reloc-table* (cit-code-vec tmplt)))
                          (fx+ CELL (cit-aux-offset tmplt))))) ;; for header


;;; fetch the template store slots out of the closure-internal-template's
;;; auxiliary template.                  

(define (set-template-store-slots ts code index offset)
  (set (cit-unit-offset ts) (fx* (fx+ offset 1) CELL))
  (set (cit-pointer ts) (bref-8 code (fx- index 6)))
  (set (cit-scratch ts) (bref-8 code (fx- index 5)))
  (set (cit-nargs ts)   (bref-8 code (fx- index 1)))
  (set (cit-header/nary? ts) (bref-8 code (fx- index 2)))
  (set (cit-code-vec ts) code)
  (set (cit-aux-offset ts) index))

(define (vgc-copy-foreign foreign)
  (let* ((heap (lstate-impure *lstate*))
         (addr (area-frontier heap))
         (name (foreign-object-name foreign))
         (desc (object nil
                 ((heap-stored self) (lstate-impure *lstate*))
                 ((heap-offset self) addr)
                 ((write-descriptor self stream)
                  (write-data stream (fx+ addr tag/extend)))
                 ((write-store self stream)
                  (write-int stream header/foreign)
                  (write-slot name stream)
                  (write-int stream 0)))))
    (set (area-frontier heap) (fx+ addr 12))
    (set-table-entry *reloc-table* foreign desc)
    (generate-slot-relocation name (fx+ addr 4))
    (push (area-objects heap) desc)                
    (cymbal-thunk (symbol->string name) 0)
    (reloc-thunk (lstate-symbol-count *lstate*) (fx+ addr 8))
    (modify (lstate-symbol-count *lstate*) (lambda (x) (fx+ x 1)))
    desc))

(define (relocate-unit-variable var addr external?)
  (let ((area (lstate-impure *lstate*))
        (type (var-value-type var)))
   (cond (type
    (cond ((and external? 
                (memq? (var-node-name var) '(big_bang interrupt_dispatcher)))
           (cymbal-thunk (string-downcase! (symbol->string (var-node-name var)))
                         (unit-var-value (var-node-value var)))
           (modify (lstate-symbol-count *lstate*) (lambda (x) (fx+ x 1)))))
    (if (fx= type DATA-SYM)
        (reloc-thunk DATA-SYM addr)
        (reloc-thunk TEXT-SYM addr))))))



(define (var-value-type var)
  (let ((value (var-node-value var)))
    (cond ((eq? value NONVALUE) 
           (vgc (var-node-name var))
           nil)
          ((unit-loc? value) DATA-SYM)
          (else
           (let ((desc (vgc value)))
             (if (eq? (heap-stored desc) (lstate-impure *lstate*))
                 DATA-SYM                                                                
                 TEXT-SYM))))))

(define (generate-slot-relocation obj slot-address)
  (cond ((or (fixnum? obj) (char? obj) (eq? obj '#t)))
        ((eq? (heap-stored (vgc obj)) (lstate-impure *lstate*))
         (reloc-thunk DATA-SYM slot-address))
        (else
         (reloc-thunk TEXT-SYM slot-address))))

(define (text-relocation addr)
  (reloc-thunk TEXT-SYM addr))

(define (data-relocation addr)
  (reloc-thunk DATA-SYM addr))

(define (reloc-thunk type address)
  (push (lstate-data-reloc *lstate*)
        (cons address type)))
            
(lset the-string-table nil)

(define (cymbal-thunk stryng value)
 (push (lstate-symbols *lstate*)
  (object (lambda (stream)                    
            (xcond ((fx<= (string-length stryng) 8)
                    (write-string stream stryng)
                    (do ((i (string-length stryng) (fx+ i 1)))
                        ((fx= i 8))  
                      (write-byte stream 0)))
                   ((table-entry the-string-table stryng)
                    => (lambda (offset)
                         (write-int stream 0)
                         (write-int stream offset))))
            (cond ((fx= value 0)            ; undefined external (foreign)
                   (write-int stream 0)
                   (write-half stream 0)    ; section number
                   (write-half stream 0)    ; type
                   (write-byte stream 2))
                  (else
                   (write-data stream value)
                   (write-half stream 2)    ; section
                   (write-half stream 0)    ; type
                   (write-byte stream 2)))
            (write-byte stream 0))
          ((cymbal-thunk.stryng self) stryng))))

(define-operation (cymbal-thunk.stryng thunk))


(define (write-slot obj stream)
  (cond ((table-entry *reloc-table* obj)
         => (lambda (desc) (write-descriptor desc stream)))
        ((fixnum? obj)
         (write-fixnum stream obj))
        ((char? obj)
         (write-int stream (fx+ (fixnum-ashl (char->ascii obj) 8)
                                 header/char)))
        ((eq? obj '#t)
         (write-int stream header/true))
        (else
         (error "bad immediate type ~s" obj))))

(define-integrable (write-data stream int)
  (write-int stream (fx+ (lstate-pure-size *lstate*) int)))

(define-integrable (write-int stream int)
  (write-half stream (fixnum-ashr int 16))
  (write-half stream int))

(define (write-half stream int)
  (write-byte stream (fixnum-ashr int 8))
  (write-byte stream int))

(define-integrable (write-byte stream n)
  (writec stream (ascii->char (fixnum-logand n 255))))
                                 
(define-integrable (write-fixnum stream fixnum)
  (write-half stream (fixnum-ashr fixnum 14))
  (write-half stream (fixnum-ashl fixnum 2)))

(define (write-link-file stream)
  (write-header     stream)
  (write-text-section-header stream)
  (write-data-section-header stream)
  (write-bss-section-header stream)
  (write-area       stream (lstate-pure *lstate*))
  (write-area       stream (lstate-impure *lstate*))
  (write-relocation stream) 
  (write-cymbal&stryng-table stream (reverse (lstate-symbols *lstate*))))

(define (write-header stream)
    (write-half stream MAGIC)                 ;magic number
    (write-half stream 3)                     ; # of sections
    (write-int stream 0)                      ; time and date 
    (write-int stream (cymbal-table-offset))
    (write-int stream (lstate-symbol-count *lstate*))
    (write-half stream 0)                      ; no extra header
    (write-half stream #o1006))                  ; flags

(define (write-text-section-header stream)   
  (write-string stream ".text")
  (write-byte stream 0)
  (write-byte stream 0)
  (write-byte stream 0)
  (write-int stream 0)      ; phys addr
  (write-int stream 0)      ; virtual addr
  (write-int stream (lstate-pure-size *lstate*))
  (write-int stream SIZE-OF-HEADERS)
  (write-int stream 0)      ; no reloc
  (write-int stream 0)      ; no line numbers
  (write-half stream 0)      
  (write-half stream 0)      
  (write-int stream #x20))
  
(define (write-data-section-header stream)   
  (write-string stream ".data")
  (write-byte stream 0)
  (write-byte stream 0)
  (write-byte stream 0)
  (write-int stream (lstate-pure-size *lstate*))      ; phys addr
  (write-int stream (lstate-pure-size *lstate*))      ; virtual addr
  (write-int stream (area-frontier (lstate-impure *lstate*)))
  (write-int stream (+ SIZE-OF-HEADERS (lstate-pure-size *lstate*)))
  (write-int stream (+ SIZE-OF-HEADERS 
                       (lstate-pure-size *lstate*)
                       (area-frontier (lstate-impure *lstate*))))
  (write-int stream 0)      ; no line numbers
  (write-half stream (length (lstate-data-reloc *lstate*)))
  (write-half stream 0)      
  (write-int stream #x40))

(define (write-bss-section-header stream)   
  (write-string stream ".bss")
  (write-byte stream 0)
  (write-byte stream 0)
  (write-byte stream 0)
  (write-byte stream 0)
  (write-int stream (fx+ (area-frontier (lstate-impure *lstate*))
                         (lstate-pure-size *lstate*)))      ; phys addr
  (write-int stream (fx+ (area-frontier (lstate-impure *lstate*))
                         (lstate-pure-size *lstate*)))      ; virt addr
  (write-int stream 0)
  (write-int stream 0)
  (write-int stream 0)
  (write-int stream 0)      
  (write-half stream 0)
  (write-half stream 0)      
  (write-int stream #x80))

(define (cymbal-table-offset)
  (+ SIZE-OF-HEADERS 
     (lstate-pure-size *lstate*)
     (area-frontier (lstate-impure *lstate*))
     (* RELOC-SIZE (length (lstate-data-reloc *lstate*)))))

(define (write-area stream area)
  (walk (lambda (x) (write-store x stream))
        (reverse! (area-objects area))))


(define (write-relocation stream)
  (walk (lambda (item)      
          (write-int stream (fx+ (car item) (lstate-pure-size *lstate*)))
          (write-int stream (cdr item))
          (write-half stream #o21))
        (sort-list! (lstate-data-reloc *lstate*)
                    (lambda (x y)      
                       (fx< (car x) (car y))))))


(define (write-map-entry stream name value) nil)

(define  (write-text-and-data-cymbals stream)
    (write-string stream ".text")
    (write-byte stream 0)
    (write-byte stream 0)
    (write-byte stream 0)
    (write-int  stream 0)
    (write-half stream 1)    ; section
    (write-half stream 0)    ; type
    (write-byte stream 3)
    (write-byte stream 1)

    (write-int stream (lstate-pure-size *lstate*))
    (write-int stream 0)
    (write-int stream 0)
    (write-int stream 0)
    (write-half stream 0)

    (write-string stream ".data")
    (write-byte stream 0)
    (write-byte stream 0)
    (write-byte stream 0)
    (write-int  stream (lstate-pure-size *lstate*))
    (write-half stream 2)    ; section
    (write-half stream 0)    ; type
    (write-byte stream 3)
    (write-byte stream 1)

    (write-int stream (area-frontier (lstate-impure *lstate*)))
    (write-int stream (length (lstate-data-reloc *lstate*)))
    (write-int stream 0)
    (write-int stream 0)
    (write-half stream 0)
 
    (write-string stream ".bss")
    (write-byte stream 0)
    (write-byte stream 0)
    (write-byte stream 0)
    (write-byte stream 0)
    (write-int  stream (fx+ (lstate-pure-size *lstate*) 
                            (area-frontier (lstate-impure *lstate*))))
    (write-half stream 3)    ; section
    (write-half stream 0)    ; type
    (write-byte stream 3)
    (write-byte stream 1)

    (write-int stream 0)
    (write-int stream 0)
    (write-int stream 0)
    (write-int stream 0)
    (write-half stream 0))
 
(define (write-cymbal&stryng-table stream cyms)
  (let ((size (make-stryng-table cyms)))   
    (write-text-and-data-cymbals stream)
    (walk (lambda (cym) (cym stream)) cyms)
    (write-stryng-table stream size cyms)))        

(define (make-stryng-table cyms)
  (set the-string-table (make-string-table 'stryngs))
  (iterate loop ((i 4) (cyms cyms))
      (cond ((null? cyms) i)
            (else
             (let* ((string (cymbal-thunk.stryng (car cyms)))
                    (len (string-length string)))
               (cond ((fx<= len 8)
                      (loop i (cdr cyms)))
                     (else                      
                      (set (table-entry the-string-table string) i)
                      (loop (fx+ i (fx+ len 1)) (cdr cyms)))))))))
                                                       

(define (write-stryng-table stream size cyms)
  (write-int stream size)
  (do ((cyms cyms (cdr cyms)))
      ((null? cyms))
    (let* ((string (cymbal-thunk.stryng (car cyms)))
           (len (string-length string)))
      (cond ((fx<= len 8))
            (else                      
             (write-string stream string)
             (write-byte stream 0))))))


